/*
 * Decompiled with CFR 0.152.
 */
package org.zxp.esclientrhl.repository;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.ParsedMin;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.Percentile;
import org.elasticsearch.search.aggregations.metrics.PercentileRanks;
import org.elasticsearch.search.aggregations.metrics.PercentileRanksAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Percentiles;
import org.elasticsearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Stats;
import org.elasticsearch.search.aggregations.metrics.StatsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ValueCount;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGeneratorBuilder;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.zxp.esclientrhl.annotation.ESID;
import org.zxp.esclientrhl.annotation.ESMapping;
import org.zxp.esclientrhl.config.ElasticsearchProperties;
import org.zxp.esclientrhl.enums.AggsType;
import org.zxp.esclientrhl.enums.DataType;
import org.zxp.esclientrhl.enums.SqlFormat;
import org.zxp.esclientrhl.index.ElasticsearchIndex;
import org.zxp.esclientrhl.repository.Attach;
import org.zxp.esclientrhl.repository.Down;
import org.zxp.esclientrhl.repository.ElasticsearchTemplate;
import org.zxp.esclientrhl.repository.HighLight;
import org.zxp.esclientrhl.repository.PageList;
import org.zxp.esclientrhl.repository.PageSortHighLight;
import org.zxp.esclientrhl.repository.Sort;
import org.zxp.esclientrhl.repository.response.ScrollResponse;
import org.zxp.esclientrhl.repository.response.UriResponse;
import org.zxp.esclientrhl.util.BeanTools;
import org.zxp.esclientrhl.util.Constant;
import org.zxp.esclientrhl.util.HttpClientTool;
import org.zxp.esclientrhl.util.IndexTools;
import org.zxp.esclientrhl.util.JsonUtils;
import org.zxp.esclientrhl.util.MetaData;
import org.zxp.esclientrhl.util.Tools;

@Component
public class ElasticsearchTemplateImpl<T, M>
implements ElasticsearchTemplate<T, M> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RestHighLevelClient client;
    @Autowired
    ElasticsearchIndex elasticsearchIndex;
    @Autowired
    ElasticsearchProperties elasticsearchProperties;
    private static final String keyword = ".keyword";
    private static Map<Class, String> classIDMap = new ConcurrentHashMap<Class, String>();

    @Override
    public Response request(Request request) throws Exception {
        Response response = this.client.getLowLevelClient().performRequest(request);
        return response;
    }

    @Override
    public boolean save(T t) throws Exception {
        return this.save(t, null);
    }

    @Override
    public boolean save(T t, String routing) throws Exception {
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        String id = Tools.getESId(t);
        IndexRequest indexRequest = null;
        indexRequest = StringUtils.isEmpty((Object)id) ? new IndexRequest(indexname, indextype) : new IndexRequest(indexname, indextype, id);
        String source = JsonUtils.obj2String(t);
        indexRequest.source(source, XContentType.JSON);
        if (!StringUtils.isEmpty((Object)routing)) {
            indexRequest.routing(routing);
        }
        IndexResponse indexResponse = null;
        indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
        if (indexResponse.getResult() == DocWriteResponse.Result.CREATED) {
            this.logger.info("INDEX CREATE SUCCESS");
            this.elasticsearchIndex.rollover(t.getClass(), true);
        } else if (indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
            this.logger.info("INDEX UPDATE SUCCESS");
        } else {
            return false;
        }
        return true;
    }

    @Override
    public BulkResponse save(List<T> list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        T t = list.get(0);
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        return this.savePart(list, indexname, indextype);
    }

    @Override
    public BulkResponse[] saveBatch(List<T> list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        T t = list.get(0);
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        List<List<T>> lists = Tools.splitList(list, true);
        BulkResponse[] bulkResponses = new BulkResponse[lists.size()];
        for (int i = 0; i < lists.size(); ++i) {
            bulkResponses[i] = this.savePart(lists.get(i), indexname, indextype);
        }
        return bulkResponses;
    }

    private BulkResponse savePart(List<T> list, String indexname, String indextype) throws Exception {
        BulkRequest rrr = new BulkRequest();
        Class<?> clazz = null;
        for (int i = 0; i < list.size(); ++i) {
            T tt = list.get(i);
            clazz = tt.getClass();
            String id = Tools.getESId(tt);
            String sourceJsonStr = JsonUtils.obj2String(tt);
            rrr.add(new IndexRequest(indexname, indextype, id).source(sourceJsonStr, XContentType.JSON));
        }
        BulkResponse bulkResponse = this.client.bulk(rrr, RequestOptions.DEFAULT);
        this.elasticsearchIndex.rollover(clazz, true);
        return bulkResponse;
    }

    @Override
    public BulkResponse bulkUpdate(List<T> list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        T t = list.get(0);
        if (Tools.checkNested(t)) {
            throw new Exception("nested\u5bf9\u8c61\u66f4\u65b0\uff0c\u8bf7\u4f7f\u7528\u8986\u76d6\u66f4\u65b0");
        }
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        return this.updatePart(list, indexname, indextype);
    }

    @Override
    public BulkResponse[] bulkUpdateBatch(List<T> list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        T t = list.get(0);
        if (Tools.checkNested(t)) {
            throw new Exception("nested\u5bf9\u8c61\u66f4\u65b0\uff0c\u8bf7\u4f7f\u7528\u8986\u76d6\u66f4\u65b0");
        }
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        List<List<T>> lists = Tools.splitList(list, true);
        BulkResponse[] bulkResponses = new BulkResponse[lists.size()];
        for (int i = 0; i < lists.size(); ++i) {
            bulkResponses[i] = this.updatePart(lists.get(i), indexname, indextype);
        }
        return bulkResponses;
    }

    private BulkResponse updatePart(List<T> list, String indexname, String indextype) throws Exception {
        BulkRequest rrr = new BulkRequest();
        for (int i = 0; i < list.size(); ++i) {
            T tt = list.get(i);
            String id = Tools.getESId(tt);
            rrr.add(new UpdateRequest(indexname, indextype, id).doc(Tools.getFieldValue(tt)));
        }
        BulkResponse bulkResponse = this.client.bulk(rrr, RequestOptions.DEFAULT);
        return bulkResponse;
    }

    @Override
    public boolean update(T t) throws Exception {
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        String id = Tools.getESId(t);
        if (StringUtils.isEmpty((Object)id)) {
            throw new Exception("ID cannot be empty");
        }
        if (Tools.checkNested(t)) {
            throw new Exception("nested\u5bf9\u8c61\u66f4\u65b0\uff0c\u8bf7\u4f7f\u7528\u8986\u76d6\u66f4\u65b0");
        }
        UpdateRequest updateRequest = new UpdateRequest(indexname, indextype, id);
        updateRequest.doc(Tools.getFieldValue(t));
        UpdateResponse updateResponse = null;
        updateResponse = this.client.update(updateRequest, RequestOptions.DEFAULT);
        if (updateResponse.getResult() == DocWriteResponse.Result.CREATED) {
            this.logger.info("INDEX CREATE SUCCESS");
        } else if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
            this.logger.info("INDEX UPDATE SUCCESS");
        } else {
            return false;
        }
        return true;
    }

    @Override
    public BulkResponse batchUpdate(QueryBuilder queryBuilder, T t, Class clazz, int limitcount, boolean asyn) throws Exception {
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        if (queryBuilder == null) {
            throw new NullPointerException();
        }
        if (Tools.checkNested(t)) {
            throw new Exception("nested\u5bf9\u8c61\u66f4\u65b0\uff0c\u8bf7\u4f7f\u7528\u8986\u76d6\u66f4\u65b0");
        }
        if (Tools.getESId(t) == null || "".equals(Tools.getESId(t))) {
            PageSortHighLight psh = new PageSortHighLight(1, limitcount);
            psh.setHighLight(null);
            PageList<T> pageList = this.search(queryBuilder, psh, clazz, indexname);
            if (pageList.getTotalElements() > (long)limitcount) {
                throw new Exception("beyond the limitcount");
            }
            if (asyn) {
                new Thread(() -> {
                    try {
                        this.batchUpdate(pageList.getList(), indexname, indextype, t);
                        this.logger.info("asyn batch finished update");
                    }
                    catch (Exception e) {
                        this.logger.error("asyn batch update fail", (Throwable)e);
                    }
                }).start();
                return null;
            }
            return this.batchUpdate(pageList.getList(), indexname, indextype, t);
        }
        throw new Exception("\u6279\u91cf\u66f4\u65b0\u8bf7\u4e0d\u8981\u7ed9\u4e3b\u952e\u4f20\u503c");
    }

    private BulkResponse batchUpdate(List<T> list, String indexname, String indextype, T tot) throws Exception {
        Map map = Tools.getFieldValue(tot);
        BulkRequest rrr = new BulkRequest();
        for (int i = 0; i < list.size(); ++i) {
            T tt = list.get(i);
            rrr.add(new UpdateRequest(indexname, indextype, Tools.getESId(tt)).doc(map));
        }
        BulkResponse bulkResponse = this.client.bulk(rrr, RequestOptions.DEFAULT);
        return bulkResponse;
    }

    @Override
    public boolean updateCover(T t) throws Exception {
        return this.save(t);
    }

    @Override
    public boolean delete(T t) throws Exception {
        return this.delete(t, null);
    }

    @Override
    public boolean delete(T t, String routing) throws Exception {
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        String id = Tools.getESId(t);
        if (StringUtils.isEmpty((Object)id)) {
            throw new Exception("ID cannot be empty");
        }
        DeleteRequest deleteRequest = new DeleteRequest(indexname, indextype, id);
        if (!StringUtils.isEmpty((Object)routing)) {
            deleteRequest.routing(routing);
        }
        DeleteResponse deleteResponse = null;
        deleteResponse = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        if (deleteResponse.getResult() != DocWriteResponse.Result.DELETED) {
            return false;
        }
        this.logger.info("INDEX DELETE SUCCESS");
        return true;
    }

    @Override
    public BulkByScrollResponse deleteByCondition(QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        DeleteByQueryRequest request = new DeleteByQueryRequest(indexname);
        request.setQuery(queryBuilder);
        BulkByScrollResponse bulkResponse = this.client.deleteByQuery(request, RequestOptions.DEFAULT);
        return bulkResponse;
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return searchResponse;
    }

    @Override
    public List<T> search(QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.search(queryBuilder, clazz, indexname);
    }

    @Override
    public List<T> search(QueryBuilder queryBuilder, Class<T> clazz, String ... indexs) throws Exception {
        SearchHit[] searchHits;
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indextype = metaData.getIndextype();
        ArrayList<T> list = new ArrayList<T>();
        SearchRequest searchRequest = new SearchRequest(indexs);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        searchSourceBuilder.from(0);
        searchSourceBuilder.size(Constant.DEFALT_PAGE_SIZE);
        searchRequest.source(searchSourceBuilder);
        if (metaData.isPrintLog()) {
            this.logger.info(searchSourceBuilder.toString());
        }
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = searchResponse.getHits();
        for (SearchHit hit : searchHits = hits.getHits()) {
            T t = JsonUtils.string2Obj(hit.getSourceAsString(), clazz);
            this.correctID(clazz, t, hit.getId());
            list.add(t);
        }
        return list;
    }

    @Override
    public List<T> searchMore(QueryBuilder queryBuilder, int limitSize, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.searchMore(queryBuilder, limitSize, clazz, indexname);
    }

    @Override
    public List<T> searchMore(QueryBuilder queryBuilder, int limitSize, Class<T> clazz, String ... indexs) throws Exception {
        PageSortHighLight pageSortHighLight = new PageSortHighLight(1, limitSize);
        PageList<T> pageList = this.search(queryBuilder, pageSortHighLight, clazz, indexs);
        if (pageList != null) {
            return pageList.getList();
        }
        return null;
    }

    @Override
    public List<T> searchUri(String uri, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        ArrayList list = new ArrayList();
        Request request = new Request("GET", "/" + indexname + "/" + indextype + "/_search/?" + uri);
        Response response = this.request(request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        if (metaData.isPrintLog()) {
            this.logger.info("searchUri\u8bf7\u6c42\u62a5\u6587\uff1a/" + indexname + "/" + indextype + "/_search/?" + uri);
            this.logger.info("searchUri\u8fd4\u56de\u62a5\u6587\uff1a" + responseBody);
        }
        UriResponse uriResponse = JsonUtils.string2Obj(responseBody, UriResponse.class);
        Object[] ts = (Object[])Array.newInstance(clazz, uriResponse.getHits().getHits().size());
        for (int i = 0; i < uriResponse.getHits().getHits().size(); ++i) {
            T t = clazz.newInstance();
            Object obj = BeanTools.mapToObject((Map)uriResponse.getHits().getHits().get(i).get_source(), clazz);
            BeanUtils.copyProperties((Object)obj, t);
            this.correctID(clazz, t, uriResponse.getHits().getHits().get(i).get_id());
            ts[i] = t;
        }
        return Arrays.asList(ts);
    }

    @Override
    public String queryBySQL(String sql, SqlFormat sqlFormat) throws Exception {
        String host = this.elasticsearchProperties.getHost();
        if (StringUtils.isEmpty((Object)host)) {
            host = Constant.DEFAULT_ES_HOST;
        }
        String ipport = "";
        String[] hosts = host.split(",");
        if (hosts.length == 1) {
            ipport = hosts[0];
        } else {
            int randomindex = new Random().nextInt(hosts.length);
            ipport = hosts[randomindex];
        }
        ipport = "http://" + ipport;
        this.logger.info(ipport + "/_sql?format=" + sqlFormat.getFormat());
        this.logger.info("{\"query\":\"" + sql + "\"}");
        String username = this.elasticsearchProperties.getUsername();
        String password = this.elasticsearchProperties.getPassword();
        if (!StringUtils.isEmpty((Object)username)) {
            return HttpClientTool.execute(ipport + "/_sql?format=" + sqlFormat.getFormat(), "{\"query\":\"" + sql + "\"}", username, password);
        }
        return HttpClientTool.execute(ipport + "/_sql?format=" + sqlFormat.getFormat(), "{\"query\":\"" + sql + "\"}");
    }

    @Override
    public long count(QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.count(queryBuilder, clazz, indexname);
    }

    @Override
    public long count(QueryBuilder queryBuilder, Class<T> clazz, String ... indexs) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        CountRequest countRequest = new CountRequest(indexs);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        countRequest.source(searchSourceBuilder);
        CountResponse countResponse = this.client.count(countRequest, RequestOptions.DEFAULT);
        long count = countResponse.getCount();
        return count;
    }

    @Override
    public T getById(M id, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        if (StringUtils.isEmpty(id)) {
            throw new Exception("ID cannot be empty");
        }
        GetRequest getRequest = new GetRequest(indexname, indextype, id.toString());
        GetResponse getResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
        if (getResponse.isExists()) {
            return JsonUtils.string2Obj(getResponse.getSourceAsString(), clazz);
        }
        return null;
    }

    @Override
    public List<T> mgetById(M[] ids, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        MultiGetRequest request = new MultiGetRequest();
        for (int i = 0; i < ids.length; ++i) {
            request.add(new MultiGetRequest.Item(indexname, indextype, ids[i].toString()));
        }
        MultiGetResponse response = this.client.mget(request, RequestOptions.DEFAULT);
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < response.getResponses().length; ++i) {
            MultiGetItemResponse item = response.getResponses()[i];
            GetResponse getResponse = item.getResponse();
            if (!getResponse.isExists()) continue;
            list.add(JsonUtils.string2Obj(getResponse.getSourceAsString(), clazz));
        }
        return list;
    }

    @Override
    public boolean exists(M id, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        if (StringUtils.isEmpty(id)) {
            throw new Exception("ID cannot be empty");
        }
        GetRequest getRequest = new GetRequest(indexname, indextype, id.toString());
        GetResponse getResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
        return getResponse.isExists();
    }

    @Override
    public Map aggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, String bucketName) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.aggs(metricName, aggsType, queryBuilder, clazz, bucketName, indexname);
    }

    @Override
    public Map aggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, String bucketName, String ... indexs) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = indexs;
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        Field f_bucket = clazz.getDeclaredField(bucketName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        if (f_bucket == null) {
            throw new Exception("bucket field is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        bucketName = this.genKeyword(f_bucket, bucketName);
        String by = "by_" + bucketName.replaceAll(keyword, "");
        String me = aggsType.toString() + "_" + metricName.replaceAll(keyword, "");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        TermsAggregationBuilder aggregation = (TermsAggregationBuilder)AggregationBuilders.terms((String)by).field(bucketName);
        aggregation.order(BucketOrder.aggregation((String)me, (boolean)false));
        if (AggsType.count == aggsType) {
            ((TermsAggregationBuilder)aggregation.subAggregation((AggregationBuilder)AggregationBuilders.count((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        } else if (AggsType.min == aggsType) {
            ((TermsAggregationBuilder)aggregation.subAggregation((AggregationBuilder)AggregationBuilders.min((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        } else if (AggsType.max == aggsType) {
            ((TermsAggregationBuilder)aggregation.subAggregation((AggregationBuilder)AggregationBuilders.max((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        } else if (AggsType.sum == aggsType) {
            ((TermsAggregationBuilder)aggregation.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        } else if (AggsType.avg == aggsType) {
            ((TermsAggregationBuilder)aggregation.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        }
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        if (metaData.isPrintLog()) {
            this.logger.info(searchSourceBuilder.toString());
        }
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Aggregations aggregations = searchResponse.getAggregations();
        Terms by_risk_code = (Terms)aggregations.get(by);
        LinkedHashMap<Object, Number> map = new LinkedHashMap<Object, Number>();
        for (Terms.Bucket bucket : by_risk_code.getBuckets()) {
            if (AggsType.count == aggsType) {
                ValueCount count = (ValueCount)bucket.getAggregations().get(me);
                long value = count.getValue();
                map.put(bucket.getKey(), value);
                continue;
            }
            if (AggsType.min == aggsType) {
                ParsedMin min = (ParsedMin)bucket.getAggregations().get(me);
                double value = min.getValue();
                map.put(bucket.getKey(), value);
                continue;
            }
            if (AggsType.max == aggsType) {
                ParsedMax max = (ParsedMax)bucket.getAggregations().get(me);
                double value = max.getValue();
                map.put(bucket.getKey(), value);
                continue;
            }
            if (AggsType.sum == aggsType) {
                ParsedSum sum = (ParsedSum)bucket.getAggregations().get(me);
                double value = sum.getValue();
                map.put(bucket.getKey(), value);
                continue;
            }
            if (AggsType.avg != aggsType) continue;
            ParsedAvg avg = (ParsedAvg)bucket.getAggregations().get(me);
            double value = avg.getValue();
            map.put(bucket.getKey(), value);
        }
        return map;
    }

    @Override
    public List<Down> aggswith2level(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, String[] bucketNames) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.aggswith2level(metricName, aggsType, queryBuilder, clazz, bucketNames, indexname);
    }

    @Override
    public List<Down> aggswith2level(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, String[] bucketNames, String ... indexs) throws Exception {
        int i;
        String[] indexname = indexs;
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        if (bucketNames == null) {
            throw new NullPointerException();
        }
        if (bucketNames.length != 2) {
            throw new Exception("\u4ec5\u652f\u6301\u4e24\u5c42\u4e0b\u94bb\u805a\u5408!");
        }
        Field[] f_buckets = new Field[bucketNames.length];
        for (int i2 = 0; i2 < bucketNames.length; ++i2) {
            f_buckets[i2] = clazz.getDeclaredField(bucketNames[i2].replaceAll(keyword, ""));
            if (f_buckets[i2] != null) continue;
            throw new Exception("bucket field is null");
        }
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        String me = aggsType.toString() + "_" + metricName.replaceAll(keyword, "");
        String[] bys = new String[bucketNames.length];
        for (int i3 = 0; i3 < f_buckets.length; ++i3) {
            bucketNames[i3] = this.genKeyword(f_buckets[i3], bucketNames[i3]);
            bys[i3] = "by_" + bucketNames[i3].replaceAll(keyword, "");
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        TermsAggregationBuilder[] termsAggregationBuilders = new TermsAggregationBuilder[bucketNames.length];
        for (i = 0; i < bucketNames.length; ++i) {
            TermsAggregationBuilder aggregationBuilder;
            termsAggregationBuilders[i] = aggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)bys[i]).field(bucketNames[i]);
        }
        for (i = 0; i < termsAggregationBuilders.length; ++i) {
            if (i == termsAggregationBuilders.length - 1) continue;
            ((TermsAggregationBuilder)termsAggregationBuilders[i].subAggregation((AggregationBuilder)termsAggregationBuilders[i + 1])).size(Constant.AGG_RESULT_COUNT);
        }
        if (AggsType.count == aggsType) {
            ((TermsAggregationBuilder)termsAggregationBuilders[termsAggregationBuilders.length - 1].subAggregation((AggregationBuilder)AggregationBuilders.count((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        } else if (AggsType.min == aggsType) {
            ((TermsAggregationBuilder)termsAggregationBuilders[termsAggregationBuilders.length - 1].subAggregation((AggregationBuilder)AggregationBuilders.min((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        } else if (AggsType.max == aggsType) {
            ((TermsAggregationBuilder)termsAggregationBuilders[termsAggregationBuilders.length - 1].subAggregation((AggregationBuilder)AggregationBuilders.max((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        } else if (AggsType.sum == aggsType) {
            ((TermsAggregationBuilder)termsAggregationBuilders[termsAggregationBuilders.length - 1].subAggregation((AggregationBuilder)AggregationBuilders.sum((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        } else if (AggsType.avg == aggsType) {
            ((TermsAggregationBuilder)termsAggregationBuilders[termsAggregationBuilders.length - 1].subAggregation((AggregationBuilder)AggregationBuilders.avg((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        }
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)termsAggregationBuilders[0]);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        ArrayList<Down> downList = new ArrayList<Down>();
        Terms terms1 = (Terms)searchResponse.getAggregations().get(bys[0]);
        for (Terms.Bucket bucket : terms1.getBuckets()) {
            Terms terms2 = (Terms)bucket.getAggregations().get(bys[1]);
            for (Terms.Bucket bucket2 : terms2.getBuckets()) {
                Down down = new Down();
                down.setLevel_1_key(bucket.getKey().toString());
                down.setLevel_2_key(bucket2.getKey().toString());
                if (AggsType.count == aggsType) {
                    ValueCount count = (ValueCount)bucket2.getAggregations().get(me);
                    long value = count.getValue();
                    down.setValue(value);
                } else if (AggsType.min == aggsType) {
                    ParsedMin min = (ParsedMin)bucket2.getAggregations().get(me);
                    double value = min.getValue();
                    down.setValue(value);
                } else if (AggsType.max == aggsType) {
                    ParsedMax max = (ParsedMax)bucket2.getAggregations().get(me);
                    double value = max.getValue();
                    down.setValue(value);
                } else if (AggsType.sum == aggsType) {
                    ParsedSum sum = (ParsedSum)bucket2.getAggregations().get(me);
                    double value = sum.getValue();
                    down.setValue(value);
                } else if (AggsType.avg == aggsType) {
                    ParsedAvg avg = (ParsedAvg)bucket2.getAggregations().get(me);
                    double value = avg.getValue();
                    down.setValue(value);
                }
                downList.add(down);
            }
        }
        return downList;
    }

    private String genKeyword(Field field, String name) {
        ESMapping esMapping = field.getAnnotation(ESMapping.class);
        if (name == null || name.indexOf(keyword) > -1) {
            return name;
        }
        if (esMapping == null ? field.getType() == String.class : esMapping.datatype() == DataType.text_type && esMapping.keyword()) {
            return name + keyword;
        }
        return name;
    }

    @Override
    public double aggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.aggs(metricName, aggsType, queryBuilder, clazz, indexname);
    }

    @Override
    public double aggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, String ... indexs) throws Exception {
        String[] indexname = indexs;
        String me = aggsType.toString() + "_" + metricName.replaceAll(keyword, "");
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.size(0);
        if (AggsType.count == aggsType) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.count((String)me).field(metricName));
        } else if (AggsType.min == aggsType) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.min((String)me).field(metricName));
        } else if (AggsType.max == aggsType) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.max((String)me).field(metricName));
        } else if (AggsType.sum == aggsType) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.sum((String)me).field(metricName));
        } else if (AggsType.avg == aggsType) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.avg((String)me).field(metricName));
        }
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        if (AggsType.count == aggsType) {
            ValueCount count = (ValueCount)searchResponse.getAggregations().get(me);
            long value = count.getValue();
            return Double.parseDouble(String.valueOf(value));
        }
        if (AggsType.min == aggsType) {
            ParsedMin min = (ParsedMin)searchResponse.getAggregations().get(me);
            double value = min.getValue();
            return value;
        }
        if (AggsType.max == aggsType) {
            ParsedMax max = (ParsedMax)searchResponse.getAggregations().get(me);
            double value = max.getValue();
            return value;
        }
        if (AggsType.sum == aggsType) {
            ParsedSum sum = (ParsedSum)searchResponse.getAggregations().get(me);
            double value = sum.getValue();
            return value;
        }
        if (AggsType.avg == aggsType) {
            ParsedAvg avg = (ParsedAvg)searchResponse.getAggregations().get(me);
            double value = avg.getValue();
            return value;
        }
        return 0.0;
    }

    @Override
    public Stats statsAggs(String metricName, QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.statsAggs(metricName, queryBuilder, clazz, indexname);
    }

    @Override
    public Stats statsAggs(String metricName, QueryBuilder queryBuilder, Class<T> clazz, String ... indexs) throws Exception {
        String[] indexname = indexs;
        String me = "stats";
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.size(0);
        StatsAggregationBuilder aggregation = (StatsAggregationBuilder)AggregationBuilders.stats((String)me).field(metricName);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Stats stats = (Stats)searchResponse.getAggregations().get(me);
        return stats;
    }

    @Override
    public Map<String, Stats> statsAggs(String metricName, QueryBuilder queryBuilder, Class<T> clazz, String bucketName) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.statsAggs(metricName, queryBuilder, clazz, bucketName, indexname);
    }

    @Override
    public Map<String, Stats> statsAggs(String metricName, QueryBuilder queryBuilder, Class<T> clazz, String bucketName, String ... indexs) throws Exception {
        String[] indexname = indexs;
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        Field f_bucket = clazz.getDeclaredField(bucketName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        if (f_bucket == null) {
            throw new Exception("bucket field is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        bucketName = this.genKeyword(f_bucket, bucketName);
        String by = "by_" + bucketName.replaceAll(keyword, "");
        String me = "stats_" + metricName.replaceAll(keyword, "");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        TermsAggregationBuilder aggregation = (TermsAggregationBuilder)AggregationBuilders.terms((String)by).field(bucketName);
        aggregation.order(BucketOrder.count((boolean)false));
        ((TermsAggregationBuilder)aggregation.subAggregation((AggregationBuilder)AggregationBuilders.stats((String)me).field(metricName))).size(Constant.AGG_RESULT_COUNT);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Aggregations aggregations = searchResponse.getAggregations();
        Terms by_risk_code = (Terms)aggregations.get(by);
        LinkedHashMap<String, Stats> map = new LinkedHashMap<String, Stats>();
        for (Terms.Bucket bucket : by_risk_code.getBuckets()) {
            Stats stats = (Stats)bucket.getAggregations().get(me);
            map.put(bucket.getKey().toString(), stats);
        }
        return map;
    }

    @Override
    public Aggregations aggs(AggregationBuilder aggregationBuilder, QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.aggs(aggregationBuilder, queryBuilder, clazz, indexname);
    }

    @Override
    public Aggregations aggs(AggregationBuilder aggregationBuilder, QueryBuilder queryBuilder, Class<T> clazz, String ... indexs) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = indexs;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation(aggregationBuilder);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        if (metaData.isPrintLog()) {
            this.logger.info(searchSourceBuilder.toString());
        }
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return searchResponse.getAggregations();
    }

    @Override
    public long cardinality(String metricName, QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.cardinality(metricName, queryBuilder, clazz, indexname);
    }

    @Override
    public long cardinality(String metricName, QueryBuilder queryBuilder, Class<T> clazz, String ... indexs) throws Exception {
        String[] indexname = indexs;
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        String me = "cardinality_" + metricName.replaceAll(keyword, "");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CardinalityAggregationBuilder aggregation = (CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)me).field(metricName);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Cardinality agg = (Cardinality)searchResponse.getAggregations().get(me);
        return agg.getValue();
    }

    @Override
    public Map<Double, Double> percentilesAggs(String metricName, QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.percentilesAggs(metricName, queryBuilder, clazz, Constant.DEFAULT_PERCSEGMENT, indexname);
    }

    @Override
    public Map percentilesAggs(String metricName, QueryBuilder queryBuilder, Class<T> clazz, double[] customSegment, String ... indexs) throws Exception {
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        if (customSegment == null) {
            throw new Exception("customSegment is null");
        }
        if (customSegment.length == 0) {
            throw new Exception("customSegment is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        String me = "percentiles_" + metricName.replaceAll(keyword, "");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        PercentilesAggregationBuilder aggregation = ((PercentilesAggregationBuilder)AggregationBuilders.percentiles((String)me).field(metricName)).percentiles(customSegment);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(indexs);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        LinkedHashMap<Double, Double> map = new LinkedHashMap<Double, Double>();
        Percentiles agg = (Percentiles)searchResponse.getAggregations().get(me);
        for (Percentile entry : agg) {
            double percent = entry.getPercent();
            double value = entry.getValue();
            map.put(percent, value);
        }
        return map;
    }

    @Override
    public Map percentileRanksAggs(String metricName, QueryBuilder queryBuilder, Class<T> clazz, double ... customSegment) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.percentileRanksAggs(metricName, queryBuilder, clazz, customSegment, indexname);
    }

    @Override
    public Map percentileRanksAggs(String metricName, QueryBuilder queryBuilder, Class<T> clazz, double[] customSegment, String ... indexs) throws Exception {
        String[] indexname = indexs;
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        if (customSegment == null || customSegment.length == 0) {
            throw new Exception("customSegment is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        String me = "percentiles_" + metricName.replaceAll(keyword, "");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        PercentileRanksAggregationBuilder aggregation = (PercentileRanksAggregationBuilder)AggregationBuilders.percentileRanks((String)me, (double[])customSegment).field(metricName);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        LinkedHashMap<Double, Double> map = new LinkedHashMap<Double, Double>();
        PercentileRanks agg = (PercentileRanks)searchResponse.getAggregations().get(me);
        for (Percentile entry : agg) {
            double percent = entry.getPercent();
            double value = entry.getValue();
            map.put(percent, value);
        }
        return map;
    }

    @Override
    public Map filterAggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, FiltersAggregator.KeyedFilter ... filters) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.filterAggs(metricName, aggsType, queryBuilder, clazz, filters, indexname);
    }

    @Override
    public Map filterAggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, FiltersAggregator.KeyedFilter[] filters, String ... indexs) throws Exception {
        String[] indexname = indexs;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (filters == null) {
            throw new NullPointerException();
        }
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        String me = aggsType.toString() + "_" + metricName.replaceAll(keyword, "");
        FiltersAggregationBuilder aggregation = AggregationBuilders.filters((String)"filteragg", (FiltersAggregator.KeyedFilter[])filters);
        searchSourceBuilder.size(0);
        if (AggsType.count == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.count((String)me).field(metricName));
        } else if (AggsType.min == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.min((String)me).field(metricName));
        } else if (AggsType.max == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.max((String)me).field(metricName));
        } else if (AggsType.sum == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)me).field(metricName));
        } else if (AggsType.avg == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)me).field(metricName));
        }
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Filters agg = (Filters)searchResponse.getAggregations().get("filteragg");
        LinkedHashMap<Object, Number> map = new LinkedHashMap<Object, Number>();
        for (Filters.Bucket entry : agg.getBuckets()) {
            if (AggsType.count == aggsType) {
                ValueCount count = (ValueCount)entry.getAggregations().get(me);
                long value = count.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.min == aggsType) {
                ParsedMin min = (ParsedMin)entry.getAggregations().get(me);
                double value = min.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.max == aggsType) {
                ParsedMax max = (ParsedMax)entry.getAggregations().get(me);
                double value = max.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.sum == aggsType) {
                ParsedSum sum = (ParsedSum)entry.getAggregations().get(me);
                double value = sum.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.avg != aggsType) continue;
            ParsedAvg avg = (ParsedAvg)entry.getAggregations().get(me);
            double value = avg.getValue();
            map.put(entry.getKey(), value);
        }
        return map;
    }

    @Override
    public Map histogramAggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, String bucketName, double interval) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.histogramAggs(metricName, aggsType, queryBuilder, clazz, bucketName, interval, indexname);
    }

    @Override
    public Map histogramAggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, String bucketName, double interval, String ... indexs) throws Exception {
        String[] indexname = indexs;
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        Field f_bucket = clazz.getDeclaredField(bucketName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        if (f_bucket == null) {
            throw new Exception("bucket field is null");
        }
        metricName = this.genKeyword(f_metric, metricName);
        bucketName = this.genKeyword(f_bucket, bucketName);
        String by = "by_" + bucketName.replaceAll(keyword, "");
        String me = aggsType.toString() + "_" + metricName.replaceAll(keyword, "");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        HistogramAggregationBuilder aggregation = ((HistogramAggregationBuilder)AggregationBuilders.histogram((String)by).field(bucketName)).interval(interval);
        searchSourceBuilder.size(0);
        if (AggsType.count == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.count((String)me).field(metricName));
        } else if (AggsType.min == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.min((String)me).field(metricName));
        } else if (AggsType.max == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.max((String)me).field(metricName));
        } else if (AggsType.sum == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)me).field(metricName));
        } else if (AggsType.avg == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)me).field(metricName));
        }
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        ParsedHistogram agg = (ParsedHistogram)searchResponse.getAggregations().get(by);
        LinkedHashMap<Object, Number> map = new LinkedHashMap<Object, Number>();
        for (Histogram.Bucket entry : agg.getBuckets()) {
            if (AggsType.count == aggsType) {
                ValueCount count = (ValueCount)entry.getAggregations().get(me);
                long value = count.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.min == aggsType) {
                ParsedMin min = (ParsedMin)entry.getAggregations().get(me);
                double value = min.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.max == aggsType) {
                ParsedMax max = (ParsedMax)entry.getAggregations().get(me);
                double value = max.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.sum == aggsType) {
                ParsedSum sum = (ParsedSum)entry.getAggregations().get(me);
                double value = sum.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.avg != aggsType) continue;
            ParsedAvg avg = (ParsedAvg)entry.getAggregations().get(me);
            double value = avg.getValue();
            map.put(entry.getKey(), value);
        }
        return map;
    }

    @Override
    public Map dateHistogramAggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, String bucketName, DateHistogramInterval interval) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.dateHistogramAggs(metricName, aggsType, queryBuilder, clazz, bucketName, interval, indexname);
    }

    @Override
    public Map dateHistogramAggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, Class<T> clazz, String bucketName, DateHistogramInterval interval, String ... indexs) throws Exception {
        String[] indexname = indexs;
        Field f_metric = clazz.getDeclaredField(metricName.replaceAll(keyword, ""));
        Field f_bucket = clazz.getDeclaredField(bucketName.replaceAll(keyword, ""));
        if (f_metric == null) {
            throw new Exception("metric field is null");
        }
        if (f_bucket == null) {
            throw new Exception("bucket field is null");
        }
        if (f_bucket.getType() != Date.class) {
            throw new Exception("bucket type is not support");
        }
        ESMapping esMapping = f_bucket.getAnnotation(ESMapping.class);
        if (esMapping != null && esMapping.datatype() != DataType.date_type) {
            throw new Exception("bucket type is not support");
        }
        metricName = this.genKeyword(f_metric, metricName);
        bucketName = this.genKeyword(f_bucket, bucketName);
        String by = "by_" + bucketName.replaceAll(keyword, "");
        String me = aggsType.toString() + "_" + metricName.replaceAll(keyword, "");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        DateHistogramAggregationBuilder aggregation = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)by).field(bucketName)).dateHistogramInterval(interval);
        searchSourceBuilder.size(0);
        if (AggsType.count == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.count((String)me).field(metricName));
        } else if (AggsType.min == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.min((String)me).field(metricName));
        } else if (AggsType.max == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.max((String)me).field(metricName));
        } else if (AggsType.sum == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)me).field(metricName));
        } else if (AggsType.avg == aggsType) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)me).field(metricName));
        }
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        ParsedDateHistogram agg = (ParsedDateHistogram)searchResponse.getAggregations().get(by);
        LinkedHashMap<Object, Number> map = new LinkedHashMap<Object, Number>();
        for (Histogram.Bucket entry : agg.getBuckets()) {
            if (AggsType.count == aggsType) {
                ValueCount count = (ValueCount)entry.getAggregations().get(me);
                long value = count.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.min == aggsType) {
                ParsedMin min = (ParsedMin)entry.getAggregations().get(me);
                double value = min.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.max == aggsType) {
                ParsedMax max = (ParsedMax)entry.getAggregations().get(me);
                double value = max.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.sum == aggsType) {
                ParsedSum sum = (ParsedSum)entry.getAggregations().get(me);
                double value = sum.getValue();
                map.put(entry.getKey(), value);
                continue;
            }
            if (AggsType.avg != aggsType) continue;
            ParsedAvg avg = (ParsedAvg)entry.getAggregations().get(me);
            double value = avg.getValue();
            map.put(entry.getKey(), value);
        }
        return map;
    }

    @Override
    public boolean deleteById(M id, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        if (StringUtils.isEmpty(id)) {
            throw new Exception("ID cannot be empty");
        }
        DeleteRequest deleteRequest = new DeleteRequest(indexname, indextype, id.toString());
        DeleteResponse deleteResponse = null;
        deleteResponse = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        if (deleteResponse.getResult() != DocWriteResponse.Result.DELETED) {
            return false;
        }
        this.logger.info("INDEX DELETE SUCCESS");
        return true;
    }

    @Override
    public PageList<T> search(QueryBuilder queryBuilder, PageSortHighLight pageSortHighLight, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        if (pageSortHighLight == null) {
            throw new NullPointerException("PageSortHighLight\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.search(queryBuilder, pageSortHighLight, clazz, indexname);
    }

    @Override
    public PageList<T> search(QueryBuilder queryBuilder, PageSortHighLight pageSortHighLight, Class<T> clazz, String ... indexs) throws Exception {
        if (pageSortHighLight == null) {
            throw new NullPointerException("PageSortHighLight\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Attach attach = new Attach();
        attach.setPageSortHighLight(pageSortHighLight);
        return this.search(queryBuilder, attach, clazz, indexs);
    }

    @Override
    public PageList<T> search(QueryBuilder queryBuilder, Attach attach, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        if (attach == null) {
            throw new NullPointerException("Attach\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.search(queryBuilder, attach, clazz, indexname);
    }

    @Override
    public PageList<T> search(QueryBuilder queryBuilder, Attach attach, Class<T> clazz, String ... indexs) throws Exception {
        SearchHit[] searchHits;
        if (attach == null) {
            throw new NullPointerException("Attach\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        MetaData metaData = IndexTools.getIndexType(clazz);
        PageList pageList = new PageList();
        ArrayList<T> list = new ArrayList<T>();
        PageSortHighLight pageSortHighLight = attach.getPageSortHighLight();
        SearchRequest searchRequest = new SearchRequest(indexs);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        boolean highLightFlag = false;
        boolean idSortFlag = false;
        if (pageSortHighLight != null) {
            HighLight highLight;
            int i;
            pageList.setCurrentPage(pageSortHighLight.getCurrentPage());
            pageList.setPageSize(pageSortHighLight.getPageSize());
            if (pageSortHighLight.getPageSize() != 0) {
                if (!attach.isSearchAfter()) {
                    searchSourceBuilder.from((pageSortHighLight.getCurrentPage() - 1) * pageSortHighLight.getPageSize());
                }
                searchSourceBuilder.size(pageSortHighLight.getPageSize());
            }
            if (pageSortHighLight.getSort() != null) {
                Sort sort = pageSortHighLight.getSort();
                List<Sort.Order> orders = sort.listOrders();
                for (i = 0; i < orders.size(); ++i) {
                    if (orders.get(i).getProperty().equals("_id")) {
                        idSortFlag = true;
                    }
                    searchSourceBuilder.sort(new FieldSortBuilder(orders.get(i).getProperty()).order(orders.get(i).getDirection()));
                }
            }
            if ((highLight = pageSortHighLight.getHighLight()) != null && highLight.getHighLightList() != null && highLight.getHighLightList().size() != 0) {
                HighlightBuilder highlightBuilder = new HighlightBuilder();
                if (!StringUtils.isEmpty((Object)highLight.getPreTag()) && !StringUtils.isEmpty((Object)highLight.getPostTag())) {
                    highlightBuilder.preTags(new String[]{highLight.getPreTag()});
                    highlightBuilder.postTags(new String[]{highLight.getPostTag()});
                }
                for (i = 0; i < highLight.getHighLightList().size(); ++i) {
                    highLightFlag = true;
                    highlightBuilder.field(highLight.getHighLightList().get(i), 0);
                }
                searchSourceBuilder.highlighter(highlightBuilder);
            }
        }
        if (attach.isSearchAfter()) {
            if (pageSortHighLight == null || pageSortHighLight.getPageSize() == 0) {
                searchSourceBuilder.size(10);
            } else {
                searchSourceBuilder.size(pageSortHighLight.getPageSize());
            }
            if (attach.getSortValues() != null && attach.getSortValues().length != 0) {
                searchSourceBuilder.searchAfter(attach.getSortValues());
            }
            if (!idSortFlag) {
                Sort.Order order = new Sort.Order(SortOrder.ASC, "_id");
                pageSortHighLight.getSort().and(new Sort(order));
                searchSourceBuilder.sort(new FieldSortBuilder("_id").order(SortOrder.ASC));
            }
        }
        if (attach.isTrackTotalHits()) {
            searchSourceBuilder.trackTotalHits(attach.isTrackTotalHits());
        }
        if (attach.getExcludes() != null || attach.getIncludes() != null) {
            searchSourceBuilder.fetchSource(attach.getIncludes(), attach.getExcludes());
        }
        searchRequest.source(searchSourceBuilder);
        if (!StringUtils.isEmpty((Object)attach.getRouting())) {
            searchRequest.routing(attach.getRouting());
        }
        if (metaData.isPrintLog()) {
            this.logger.info(searchSourceBuilder.toString());
        }
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = searchResponse.getHits();
        for (SearchHit hit : searchHits = hits.getHits()) {
            T t = JsonUtils.string2Obj(hit.getSourceAsString(), clazz);
            this.correctID(clazz, t, hit.getId());
            if (highLightFlag) {
                Map hmap = hit.getHighlightFields();
                hmap.forEach((k, v) -> {
                    try {
                        Object obj = this.mapToObject(hmap, clazz);
                        BeanUtils.copyProperties((Object)obj, (Object)t, (String[])BeanTools.getNoValuePropertyNames(obj));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            list.add(t);
            pageList.setSortValues(hit.getSortValues());
        }
        pageList.setList(list);
        pageList.setTotalElements(hits.getTotalHits().value);
        if (pageSortHighLight != null && pageSortHighLight.getPageSize() != 0) {
            pageList.setTotalPages(this.getTotalPages(hits.getTotalHits().value, pageSortHighLight.getPageSize()));
        }
        return pageList;
    }

    private void correctID(Class clazz, T t, M _id) {
        try {
            if (StringUtils.isEmpty(_id)) {
                return;
            }
            if (classIDMap.containsKey(clazz)) {
                Field field = clazz.getDeclaredField(classIDMap.get(clazz));
                field.setAccessible(true);
                if (field.get(t) == null) {
                    field.set(t, _id);
                }
                return;
            }
            for (int i = 0; i < clazz.getDeclaredFields().length; ++i) {
                Field field = clazz.getDeclaredFields()[i];
                field.setAccessible(true);
                if (field.getAnnotation(ESID.class) == null) continue;
                classIDMap.put(clazz, field.getName());
                if (field.get(t) != null) continue;
                field.set(t, _id);
            }
        }
        catch (Exception e) {
            this.logger.error("correctID error!", (Throwable)e);
        }
    }

    private Object mapToObject(Map map, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            int mod;
            if (map.get(field.getName()) == null || StringUtils.isEmpty(map.get(field.getName())) || Modifier.isStatic(mod = field.getModifiers()) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            if (!(map.get(field.getName()) instanceof HighlightField) || ((HighlightField)map.get(field.getName())).fragments().length <= 0) continue;
            field.set(obj, ((HighlightField)map.get(field.getName())).fragments()[0].string());
        }
        return obj;
    }

    @Override
    public List<T> searchTemplate(Map<String, Object> template_params, String templateName, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        SearchTemplateRequest request = new SearchTemplateRequest();
        request.setRequest(new SearchRequest(indexname));
        request.setScriptType(ScriptType.STORED);
        request.setScript(templateName);
        HashMap params = new HashMap();
        if (template_params != null) {
            template_params.forEach((k, v) -> params.put(k, v));
        }
        request.setScriptParams(params);
        SearchTemplateResponse response = this.client.searchTemplate(request, RequestOptions.DEFAULT);
        SearchResponse searchResponse = response.getResponse();
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        ArrayList<T> list = new ArrayList<T>();
        for (SearchHit hit : searchHits) {
            T t = JsonUtils.string2Obj(hit.getSourceAsString(), clazz);
            list.add(t);
        }
        return list;
    }

    @Override
    public List<T> searchTemplateBySource(Map<String, Object> template_params, String templateSource, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        SearchTemplateRequest request = new SearchTemplateRequest();
        request.setRequest(new SearchRequest(new String[]{indexname}));
        request.setScriptType(ScriptType.INLINE);
        request.setScript(templateSource);
        HashMap scriptParams = new HashMap();
        if (template_params != null) {
            template_params.forEach((k, v) -> scriptParams.put(k, v));
        }
        request.setScriptParams(scriptParams);
        SearchTemplateResponse response = this.client.searchTemplate(request, RequestOptions.DEFAULT);
        SearchResponse searchResponse = response.getResponse();
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        ArrayList<T> list = new ArrayList<T>();
        for (SearchHit hit : searchHits) {
            T t = JsonUtils.string2Obj(hit.getSourceAsString(), clazz);
            list.add(t);
        }
        return list;
    }

    @Override
    public Response saveTemplate(String templateName, String templateSource) throws Exception {
        Request scriptRequest = new Request("POST", "_scripts/" + templateName);
        scriptRequest.setJsonEntity(templateSource);
        Response scriptResponse = this.request(scriptRequest);
        return scriptResponse;
    }

    @Override
    public List<T> scroll(QueryBuilder queryBuilder, Class<T> clazz, Long time, String ... indexs) throws Exception {
        if (queryBuilder == null) {
            queryBuilder = new MatchAllQueryBuilder();
        }
        ArrayList list = new ArrayList();
        ScrollResponse<T> scrollResponse = this.createScroll(queryBuilder, clazz, time, 50);
        scrollResponse.getList().forEach(s -> list.add(s));
        String scrollId = scrollResponse.getScrollId();
        while ((scrollResponse = this.queryScroll(clazz, time, scrollId)).getList() != null && scrollResponse.getList().size() != 0) {
            scrollResponse.getList().forEach(s -> list.add(s));
            scrollId = scrollResponse.getScrollId();
        }
        return list;
    }

    @Override
    public ScrollResponse<T> createScroll(QueryBuilder queryBuilder, Class<T> clazz, Long time, Integer size) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        return this.createScroll(queryBuilder, clazz, time, size, indexname);
    }

    @Override
    public ScrollResponse<T> createScroll(QueryBuilder queryBuilder, Class<T> clazz, Long time, Integer size, String ... indexs) throws Exception {
        SearchHit[] searchHits;
        if (queryBuilder == null) {
            queryBuilder = new MatchAllQueryBuilder();
        }
        String[] indexname = indexs;
        ArrayList<T> list = new ArrayList<T>();
        Scroll scroll = new Scroll(TimeValue.timeValueHours((long)time));
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.scroll(scroll);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (size == null || size == 0) {
            searchSourceBuilder.size(Constant.DEFAULT_SCROLL_PERPAGE);
        } else {
            searchSourceBuilder.size(size.intValue());
        }
        searchSourceBuilder.query(queryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        String scrollId = searchResponse.getScrollId();
        for (SearchHit hit : searchHits = searchResponse.getHits().getHits()) {
            T t = JsonUtils.string2Obj(hit.getSourceAsString(), clazz);
            this.correctID(clazz, t, hit.getId());
            list.add(t);
        }
        ScrollResponse scrollResponse = new ScrollResponse(list, scrollId);
        return scrollResponse;
    }

    @Override
    public ScrollResponse<T> queryScroll(Class<T> clazz, Long time, String scrollId) throws Exception {
        SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
        Scroll scroll = new Scroll(TimeValue.timeValueHours((long)time));
        scrollRequest.scroll(scroll);
        SearchResponse searchResponse = this.client.scroll(scrollRequest, RequestOptions.DEFAULT);
        scrollId = searchResponse.getScrollId();
        SearchHit[] searchHits = searchResponse.getHits().getHits();
        ArrayList<T> list = new ArrayList<T>();
        for (SearchHit hit : searchHits) {
            T t = JsonUtils.string2Obj(hit.getSourceAsString(), clazz);
            this.correctID(clazz, t, hit.getId());
            list.add(t);
        }
        ScrollResponse scrollResponse = new ScrollResponse(list, scrollId);
        return scrollResponse;
    }

    @Override
    public List<T> scroll(QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.scroll(queryBuilder, clazz, Constant.DEFAULT_SCROLL_TIME, indexname);
    }

    @Override
    public List<String> completionSuggest(String fieldName, String fieldValue, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.completionSuggest(fieldName, fieldValue, clazz, indexname);
    }

    @Override
    public List<String> completionSuggest(String fieldName, String fieldValue, Class<T> clazz, String ... indexs) throws Exception {
        String[] indexname = indexs;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        CompletionSuggestionBuilder completionSuggestionBuilder = new CompletionSuggestionBuilder(fieldName + ".suggest");
        completionSuggestionBuilder.text(fieldValue);
        completionSuggestionBuilder.skipDuplicates(true);
        completionSuggestionBuilder.size(Constant.COMPLETION_SUGGESTION_SIZE);
        suggestBuilder.addSuggestion("suggest_" + fieldName, (SuggestionBuilder)completionSuggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Suggest suggest = searchResponse.getSuggest();
        if (suggest == null) {
            return null;
        }
        CompletionSuggestion completionSuggestion = (CompletionSuggestion)suggest.getSuggestion("suggest_" + fieldName);
        ArrayList<String> list = new ArrayList<String>();
        for (CompletionSuggestion.Entry entry : completionSuggestion.getEntries()) {
            for (CompletionSuggestion.Entry.Option option : entry) {
                String suggestText = option.getText().string();
                list.add(suggestText);
            }
        }
        return list;
    }

    @Override
    public List<String> phraseSuggest(String fieldName, String fieldValue, PhraseSuggestParam param, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.phraseSuggest(fieldName, fieldValue, param, clazz, indexname);
    }

    @Override
    public List<String> phraseSuggest(String fieldName, String fieldValue, PhraseSuggestParam param, Class<T> clazz, String ... indexs) throws Exception {
        if (param == null) {
            param = new PhraseSuggestParam(5, 0.0f, null, "always");
        }
        String[] indexname = indexs;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        PhraseSuggestionBuilder phraseSuggestionBuilder = new PhraseSuggestionBuilder(fieldName);
        ((PhraseSuggestionBuilder)((PhraseSuggestionBuilder)phraseSuggestionBuilder.text(fieldValue)).confidence(param.getConfidence()).size(Constant.COMPLETION_SUGGESTION_SIZE)).maxErrors((float)param.getMaxErrors()).addCandidateGenerator((PhraseSuggestionBuilder.CandidateGenerator)new DirectCandidateGeneratorBuilder(fieldName).suggestMode(param.getSuggestMode()));
        if (param.getAnalyzer() != null) {
            phraseSuggestionBuilder.analyzer(param.getAnalyzer());
        }
        suggestBuilder.addSuggestion("suggest_" + fieldName, (SuggestionBuilder)phraseSuggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder);
        SearchRequest searchRequest = new SearchRequest(indexname);
        searchRequest.source(searchSourceBuilder);
        this.logger.info(searchSourceBuilder.toString());
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Suggest suggest = searchResponse.getSuggest();
        if (suggest == null) {
            return null;
        }
        PhraseSuggestion phraseSuggestion = (PhraseSuggestion)suggest.getSuggestion("suggest_" + fieldName);
        ArrayList<String> list = new ArrayList<String>();
        for (PhraseSuggestion.Entry entry : phraseSuggestion.getEntries()) {
            for (PhraseSuggestion.Entry.Option option : entry) {
                String suggestText = option.getText().string();
                list.add(suggestText);
            }
        }
        return list;
    }

    private int getTotalPages(long totalHits, int pageSize) {
        return pageSize == 0 ? 1 : (int)Math.ceil((double)totalHits / (double)pageSize);
    }

    public static class PhraseSuggestParam {
        private int maxErrors;
        private float confidence;
        private String analyzer;
        private String suggestMode;

        public PhraseSuggestParam(int maxErrors, float confidence, String analyzer, String suggestMode) {
            this.maxErrors = maxErrors;
            this.confidence = confidence;
            this.analyzer = analyzer;
            this.suggestMode = suggestMode;
        }

        public int getMaxErrors() {
            return this.maxErrors;
        }

        public void setMaxErrors(int maxErrors) {
            this.maxErrors = maxErrors;
        }

        public float getConfidence() {
            return this.confidence;
        }

        public void setConfidence(float confidence) {
            this.confidence = confidence;
        }

        public String getAnalyzer() {
            return this.analyzer;
        }

        public void setAnalyzer(String analyzer) {
            this.analyzer = analyzer;
        }

        public String getSuggestMode() {
            return this.suggestMode;
        }

        public void setSuggestMode(String suggestMode) {
            this.suggestMode = suggestMode;
        }
    }
}

