/*
 * Decompiled with CFR 0.152.
 */
package org.zxp.esclientrhl.repository;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.metrics.Stats;
import org.zxp.esclientrhl.enums.AggsType;
import org.zxp.esclientrhl.enums.SqlFormat;
import org.zxp.esclientrhl.repository.Attach;
import org.zxp.esclientrhl.repository.Down;
import org.zxp.esclientrhl.repository.ElasticsearchTemplateImpl;
import org.zxp.esclientrhl.repository.PageList;
import org.zxp.esclientrhl.repository.PageSortHighLight;
import org.zxp.esclientrhl.repository.response.ScrollResponse;

public interface ElasticsearchTemplate<T, M> {
    public Response request(Request var1) throws Exception;

    public boolean save(T var1) throws Exception;

    public boolean save(T var1, String var2) throws Exception;

    public BulkResponse save(List<T> var1) throws Exception;

    public BulkResponse[] saveBatch(List<T> var1) throws Exception;

    public BulkResponse bulkUpdate(List<T> var1) throws Exception;

    public BulkResponse[] bulkUpdateBatch(List<T> var1) throws Exception;

    public boolean update(T var1) throws Exception;

    public BulkResponse batchUpdate(QueryBuilder var1, T var2, Class var3, int var4, boolean var5) throws Exception;

    public boolean updateCover(T var1) throws Exception;

    public boolean delete(T var1) throws Exception;

    public boolean delete(T var1, String var2) throws Exception;

    public BulkByScrollResponse deleteByCondition(QueryBuilder var1, Class<T> var2) throws Exception;

    public boolean deleteById(M var1, Class<T> var2) throws Exception;

    public SearchResponse search(SearchRequest var1) throws Exception;

    public List<T> search(QueryBuilder var1, Class<T> var2) throws Exception;

    public List<T> search(QueryBuilder var1, Class<T> var2, String ... var3) throws Exception;

    public List<T> searchMore(QueryBuilder var1, int var2, Class<T> var3) throws Exception;

    public List<T> searchMore(QueryBuilder var1, int var2, Class<T> var3, String ... var4) throws Exception;

    public List<T> searchUri(String var1, Class<T> var2) throws Exception;

    public String queryBySQL(String var1, SqlFormat var2) throws Exception;

    public long count(QueryBuilder var1, Class<T> var2) throws Exception;

    public long count(QueryBuilder var1, Class<T> var2, String ... var3) throws Exception;

    public PageList<T> search(QueryBuilder var1, PageSortHighLight var2, Class<T> var3) throws Exception;

    public PageList<T> search(QueryBuilder var1, PageSortHighLight var2, Class<T> var3, String ... var4) throws Exception;

    public PageList<T> search(QueryBuilder var1, Attach var2, Class<T> var3) throws Exception;

    public PageList<T> search(QueryBuilder var1, Attach var2, Class<T> var3, String ... var4) throws Exception;

    @Deprecated
    public List<T> scroll(QueryBuilder var1, Class<T> var2) throws Exception;

    @Deprecated
    public List<T> scroll(QueryBuilder var1, Class<T> var2, Long var3, String ... var4) throws Exception;

    public ScrollResponse<T> createScroll(QueryBuilder var1, Class<T> var2, Long var3, Integer var4) throws Exception;

    public ScrollResponse<T> createScroll(QueryBuilder var1, Class<T> var2, Long var3, Integer var4, String ... var5) throws Exception;

    public ScrollResponse<T> queryScroll(Class<T> var1, Long var2, String var3) throws Exception;

    public List<T> searchTemplate(Map<String, Object> var1, String var2, Class<T> var3) throws Exception;

    public List<T> searchTemplateBySource(Map<String, Object> var1, String var2, Class<T> var3) throws Exception;

    public Response saveTemplate(String var1, String var2) throws Exception;

    public List<String> completionSuggest(String var1, String var2, Class<T> var3) throws Exception;

    public List<String> completionSuggest(String var1, String var2, Class<T> var3, String ... var4) throws Exception;

    public List<String> phraseSuggest(String var1, String var2, ElasticsearchTemplateImpl.PhraseSuggestParam var3, Class<T> var4) throws Exception;

    public List<String> phraseSuggest(String var1, String var2, ElasticsearchTemplateImpl.PhraseSuggestParam var3, Class<T> var4, String ... var5) throws Exception;

    public T getById(M var1, Class<T> var2) throws Exception;

    public List<T> mgetById(M[] var1, Class<T> var2) throws Exception;

    public boolean exists(M var1, Class<T> var2) throws Exception;

    public Map aggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, String var5) throws Exception;

    public Map aggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, String var5, String ... var6) throws Exception;

    public double aggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4) throws Exception;

    public double aggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, String ... var5) throws Exception;

    public List<Down> aggswith2level(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, String[] var5) throws Exception;

    public List<Down> aggswith2level(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, String[] var5, String ... var6) throws Exception;

    public Stats statsAggs(String var1, QueryBuilder var2, Class<T> var3) throws Exception;

    public Stats statsAggs(String var1, QueryBuilder var2, Class<T> var3, String ... var4) throws Exception;

    public Map<String, Stats> statsAggs(String var1, QueryBuilder var2, Class<T> var3, String var4) throws Exception;

    public Map<String, Stats> statsAggs(String var1, QueryBuilder var2, Class<T> var3, String var4, String ... var5) throws Exception;

    public Aggregations aggs(AggregationBuilder var1, QueryBuilder var2, Class<T> var3) throws Exception;

    public Aggregations aggs(AggregationBuilder var1, QueryBuilder var2, Class<T> var3, String ... var4) throws Exception;

    public long cardinality(String var1, QueryBuilder var2, Class<T> var3) throws Exception;

    public long cardinality(String var1, QueryBuilder var2, Class<T> var3, String ... var4) throws Exception;

    public Map percentilesAggs(String var1, QueryBuilder var2, Class<T> var3) throws Exception;

    public Map percentilesAggs(String var1, QueryBuilder var2, Class<T> var3, double[] var4, String ... var5) throws Exception;

    public Map percentileRanksAggs(String var1, QueryBuilder var2, Class<T> var3, double[] var4) throws Exception;

    public Map percentileRanksAggs(String var1, QueryBuilder var2, Class<T> var3, double[] var4, String ... var5) throws Exception;

    public Map filterAggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, FiltersAggregator.KeyedFilter[] var5) throws Exception;

    public Map filterAggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, FiltersAggregator.KeyedFilter[] var5, String ... var6) throws Exception;

    public Map histogramAggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, String var5, double var6) throws Exception;

    public Map histogramAggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, String var5, double var6, String ... var8) throws Exception;

    public Map dateHistogramAggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, String var5, DateHistogramInterval var6) throws Exception;

    public Map dateHistogramAggs(String var1, AggsType var2, QueryBuilder var3, Class<T> var4, String var5, DateHistogramInterval var6, String ... var7) throws Exception;
}

