/*
 * Decompiled with CFR 0.152.
 */
package org.zxp.esclientrhl.auto.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.zxp.esclientrhl.auto.util.EnableESTools;

public class GetBasePackage {
    private static Map<Class, List<String>> entityPathsMap = null;
    private Class<? extends Annotation> annotation;

    public GetBasePackage(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    public Stream<String> getBasePackage(AnnotationMetadata annotationMetadata) {
        Map annotationAttributes = annotationMetadata.getAnnotationAttributes(this.annotation.getName());
        AnnotationAttributes attributes = new AnnotationAttributes(annotationAttributes);
        EnableESTools.gainAnnoInfo(attributes);
        String[] value = EnableESTools.getValue();
        String[] basePackages = EnableESTools.getBasePackages();
        String[] entityPaths = EnableESTools.getEntityPath();
        if (value.length == 0 && basePackages.length == 0) {
            String className = annotationMetadata.getClassName();
            return Stream.of(ClassUtils.getPackageName((String)className));
        }
        return Stream.of(Arrays.asList(value), Arrays.asList(basePackages), Arrays.asList(entityPaths)).flatMap(list -> list.stream());
    }

    public Stream<String> getEntityPackage(AnnotationMetadata annotationMetadata) {
        if (entityPathsMap.containsKey(this.annotation)) {
            return Stream.of(entityPathsMap.get(this.annotation)).flatMap(list -> list.stream());
        }
        Map annotationAttributes = annotationMetadata.getAnnotationAttributes(this.annotation.getName());
        AnnotationAttributes attributes = new AnnotationAttributes(annotationAttributes);
        String[] entityPaths = attributes.getStringArray("entityPath");
        if (entityPaths.length == 0) {
            String className = annotationMetadata.getClassName();
            entityPathsMap.put(this.annotation, Arrays.asList(ClassUtils.getPackageName((String)className)));
            return Stream.of(ClassUtils.getPackageName((String)className));
        }
        entityPathsMap.put(this.annotation, Arrays.asList(entityPaths));
        return Stream.of(Arrays.asList(entityPaths)).flatMap(list -> list.stream());
    }

    public static Map<Class, List<String>> getEntityPathsMap() {
        return entityPathsMap;
    }

    static {
        entityPathsMap = new HashMap<Class, List<String>>();
    }
}

