/*
 * Decompiled with CFR 0.152.
 */
package org.zxp.esclientrhl.auto.intfproxy;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.QueryBuilder;
import org.springframework.context.ApplicationContext;
import org.zxp.esclientrhl.auto.intfproxy.ESCRepository;
import org.zxp.esclientrhl.enums.AggsType;
import org.zxp.esclientrhl.repository.ElasticsearchTemplate;
import org.zxp.esclientrhl.repository.PageList;
import org.zxp.esclientrhl.repository.PageSortHighLight;

public class SimpleESCRepository<T, M>
implements ESCRepository<T, M> {
    private Class<T> domainClass;
    private Class<M> idClass;
    private ApplicationContext applicationContext;
    private ElasticsearchTemplate elasticsearchTemplate = null;

    public SimpleESCRepository(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private ElasticsearchTemplate getElasticsearchTemplate() {
        return (ElasticsearchTemplate)this.applicationContext.getBean(ElasticsearchTemplate.class);
    }

    @Override
    public Response request(Request request) throws Exception {
        return this.getElasticsearchTemplate().request(request);
    }

    @Override
    public boolean save(T o) throws Exception {
        return this.getElasticsearchTemplate().save(o);
    }

    @Override
    public BulkResponse save(List<T> list) throws Exception {
        return this.getElasticsearchTemplate().save(list);
    }

    @Override
    public boolean update(T t) throws Exception {
        return this.getElasticsearchTemplate().update(t);
    }

    @Override
    public boolean updateCover(T t) throws Exception {
        return this.getElasticsearchTemplate().updateCover(t);
    }

    @Override
    public boolean delete(T t) throws Exception {
        return this.getElasticsearchTemplate().delete(t);
    }

    @Override
    public boolean deleteById(M id) throws Exception {
        return this.getElasticsearchTemplate().deleteById(id, this.domainClass);
    }

    @Override
    public T getById(M id) throws Exception {
        return this.getElasticsearchTemplate().getById(id, this.domainClass);
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) throws Exception {
        return this.getElasticsearchTemplate().search(searchRequest);
    }

    @Override
    public List<T> search(QueryBuilder queryBuilder) throws Exception {
        return this.getElasticsearchTemplate().search(queryBuilder, this.domainClass);
    }

    @Override
    public long count(QueryBuilder queryBuilder) throws Exception {
        return this.getElasticsearchTemplate().count(queryBuilder, this.domainClass);
    }

    @Override
    public PageList<T> search(QueryBuilder queryBuilder, PageSortHighLight pageSortHighLight) throws Exception {
        return this.getElasticsearchTemplate().search(queryBuilder, pageSortHighLight, this.domainClass);
    }

    @Override
    public List<T> searchMore(QueryBuilder queryBuilder, int limitSize) throws Exception {
        return this.getElasticsearchTemplate().searchMore(queryBuilder, limitSize, this.domainClass);
    }

    @Override
    public List<String> completionSuggest(String fieldName, String fieldValue) throws Exception {
        return this.getElasticsearchTemplate().completionSuggest(fieldName, fieldValue, this.domainClass);
    }

    @Override
    public Map aggs(String metricName, AggsType aggsType, QueryBuilder queryBuilder, String bucketName) throws Exception {
        return this.getElasticsearchTemplate().aggs(metricName, aggsType, queryBuilder, this.domainClass, bucketName);
    }

    public Class<T> getDomainClass() {
        return this.domainClass;
    }

    public void setDomainClass(Class<T> domainClass) {
        this.domainClass = domainClass;
    }

    public Class<M> getIdClass() {
        return this.idClass;
    }

    public void setIdClass(Class<M> idClass) {
        this.idClass = idClass;
    }
}

