/*
 * Decompiled with CFR 0.152.
 */
package org.zxp.esclientrhl.auto.intfproxy;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.zxp.esclientrhl.auto.intfproxy.ESCRepository;
import org.zxp.esclientrhl.auto.intfproxy.SimpleESCRepository;
import org.zxp.esclientrhl.auto.util.EnableESTools;
import org.zxp.esclientrhl.auto.util.GetBasePackage;

public class RepositoryFactorySupport<T extends ESCRepository<S, ID>, S, ID>
implements ApplicationContextAware,
ResourceLoaderAware,
InitializingBean,
FactoryBean<T>,
BeanClassLoaderAware,
BeanFactoryAware,
ApplicationEventPublisherAware {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<? extends T> repositoryInterface;
    private ResourceLoader resourceLoader;
    private T repository;
    private ClassLoader classLoader;
    private BeanFactory beanFactory;
    private ApplicationEventPublisher publisher;
    private ApplicationContext applicationContext;

    public RepositoryFactorySupport(Class<? extends T> repositoryInterface) {
        this.repositoryInterface = repositoryInterface;
    }

    public void afterPropertiesSet() {
        try {
            this.repository = (ESCRepository)this.getRepository(this.repositoryInterface);
        }
        catch (Exception e) {
            this.logger.error("ESCRepository proxy create fail !", (Throwable)e);
        }
    }

    public <T> T getRepository(Class<T> repositoryInterface) throws Exception {
        SimpleESCRepository target = new SimpleESCRepository(this.applicationContext);
        this.getMetadata(target);
        ProxyFactory result = new ProxyFactory();
        result.setTarget(target);
        result.addAdvice((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                Object result = invocation.proceed();
                return result;
            }
        });
        result.setInterfaces(new Class[]{this.repositoryInterface, ESCRepository.class});
        Object repository = result.getProxy(this.classLoader);
        return (T)repository;
    }

    private void getMetadata(SimpleESCRepository target) throws Exception {
        Map<String, Class> idTypeMap;
        Type[] types = this.repositoryInterface.getGenericInterfaces();
        ParameterizedType parameterized = (ParameterizedType)types[0];
        String domainClassName = parameterized.getActualTypeArguments()[0].getTypeName();
        String idClassName = parameterized.getActualTypeArguments()[1].getTypeName();
        if (EnableESTools.isPrintregmsg()) {
            this.logger.info("domainClassName\uff1a" + domainClassName + " idClassName\uff1a" + idClassName);
        }
        List<String> entityList = this.getEntityList();
        for (int i = 0; i < entityList.size(); ++i) {
            if (entityList.get(i).lastIndexOf("." + domainClassName) == -1) continue;
            if (target.getDomainClass() == null) {
                target.setDomainClass(Class.forName(entityList.get(i)));
                break;
            }
            target.setDomainClass(null);
            throw new Exception("Entity Overmatched !");
        }
        if (!(idTypeMap = this.getIdTypeMap()).containsKey(idClassName)) {
            throw new Exception("Not Supported ID Type !");
        }
        target.setIdClass(idTypeMap.get(idClassName));
    }

    private Map<String, Class> getIdTypeMap() {
        HashMap<String, Class> idTypeMap = new HashMap<String, Class>();
        idTypeMap.put("String", String.class);
        idTypeMap.put("Integer", Integer.class);
        idTypeMap.put("Long", Long.class);
        idTypeMap.put("java.lang.String", String.class);
        idTypeMap.put("java.lang.Integer", Integer.class);
        idTypeMap.put("java.lang.Long", Long.class);
        return idTypeMap;
    }

    private List<String> getEntityList() {
        ArrayList<String> entityList = new ArrayList<String>();
        GetBasePackage.getEntityPathsMap().get(org.zxp.esclientrhl.annotation.EnableESTools.class).forEach(s -> {
            ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
            CachingMetadataReaderFactory metaReader = new CachingMetadataReaderFactory(this.resourceLoader);
            Resource[] resources = new Resource[]{};
            try {
                for (Resource r : resources = resolver.getResources("classpath*:" + s.replaceAll("\\.", "/") + "/**/*.class")) {
                    MetadataReader reader = metaReader.getMetadataReader(r);
                    entityList.add(reader.getClassMetadata().getClassName());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return entityList;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public T getObject() throws Exception {
        return this.repository;
    }

    public Class<?> getObjectType() {
        return this.repositoryInterface;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

