/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.model;

import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.springframework.boot.autoconfigure.klock.handler.KlockTimeoutException;
import org.springframework.boot.autoconfigure.klock.handler.lock.LockTimeoutHandler;
import org.springframework.boot.autoconfigure.klock.lock.Lock;
import org.springframework.boot.autoconfigure.klock.model.LockInfo;

public enum LockTimeoutStrategy implements LockTimeoutHandler
{
    NO_OPERATION{

        @Override
        public void handle(LockInfo lockInfo, Lock lock, JoinPoint joinPoint) {
        }
    }
    ,
    FAIL_FAST{

        @Override
        public void handle(LockInfo lockInfo, Lock lock, JoinPoint joinPoint) {
            String errorMsg = String.format("Failed to acquire Lock(%s) with timeout(%ds)", lockInfo.getName(), lockInfo.getWaitTime());
            throw new KlockTimeoutException(errorMsg);
        }
    }
    ,
    KEEP_ACQUIRE{
        private static final long DEFAULT_INTERVAL = 100L;
        private static final long DEFAULT_MAX_INTERVAL = 180000L;

        @Override
        public void handle(LockInfo lockInfo, Lock lock, JoinPoint joinPoint) {
            long interval = 100L;
            while (!lock.acquire()) {
                if (interval > 180000L) {
                    String errorMsg = String.format("Failed to acquire Lock(%s) after too many times, this may because dead lock occurs.", lockInfo.getName());
                    throw new KlockTimeoutException(errorMsg);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(interval);
                    interval <<= 1;
                }
                catch (InterruptedException e) {
                    throw new KlockTimeoutException("Failed to acquire Lock", e);
                }
            }
        }
    };

}

