/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.lock;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.klock.lock.Lock;
import org.springframework.boot.autoconfigure.klock.model.LockInfo;

public class FairLock
implements Lock {
    private RLock rLock;
    private final LockInfo lockInfo;
    private RedissonClient redissonClient;

    public FairLock(RedissonClient redissonClient, LockInfo info) {
        this.redissonClient = redissonClient;
        this.lockInfo = info;
    }

    @Override
    public boolean acquire() {
        try {
            this.rLock = this.redissonClient.getFairLock(this.lockInfo.getName());
            return this.rLock.tryLock(this.lockInfo.getWaitTime(), this.lockInfo.getLeaseTime(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean release() {
        if (this.rLock.isHeldByCurrentThread()) {
            try {
                return (Boolean)this.rLock.forceUnlockAsync().get();
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        return false;
    }
}

