/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.core;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.boot.autoconfigure.klock.annotation.Klock;
import org.springframework.boot.autoconfigure.klock.annotation.KlockKey;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BusinessKeyProvider {
    private ParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
    private ExpressionParser parser = new SpelExpressionParser();

    public String getKeyName(JoinPoint joinPoint, Klock klock) {
        ArrayList<String> keyList = new ArrayList<String>();
        Method method = this.getMethod(joinPoint);
        List<String> definitionKeys = this.getSpelDefinitionKey(klock.keys(), method, joinPoint.getArgs());
        keyList.addAll(definitionKeys);
        List<String> parameterKeys = this.getParameterKey(method.getParameters(), joinPoint.getArgs());
        keyList.addAll(parameterKeys);
        return StringUtils.collectionToDelimitedString(keyList, (String)"", (String)"-", (String)"");
    }

    private Method getMethod(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = joinPoint.getTarget().getClass().getDeclaredMethod(signature.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return method;
    }

    private List<String> getSpelDefinitionKey(String[] definitionKeys, Method method, Object[] parameterValues) {
        ArrayList<String> definitionKeyList = new ArrayList<String>();
        for (String definitionKey : definitionKeys) {
            if (ObjectUtils.isEmpty((Object)definitionKey)) continue;
            MethodBasedEvaluationContext context = new MethodBasedEvaluationContext(null, method, parameterValues, this.nameDiscoverer);
            Object objKey = this.parser.parseExpression(definitionKey).getValue((EvaluationContext)context);
            definitionKeyList.add(ObjectUtils.nullSafeToString((Object)objKey));
        }
        return definitionKeyList;
    }

    private List<String> getParameterKey(Parameter[] parameters, Object[] parameterValues) {
        ArrayList<String> parameterKey = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getAnnotation(KlockKey.class) == null) continue;
            KlockKey keyAnnotation = parameters[i].getAnnotation(KlockKey.class);
            if (keyAnnotation.value().isEmpty()) {
                Object parameterValue = parameterValues[i];
                parameterKey.add(ObjectUtils.nullSafeToString((Object)parameterValue));
                continue;
            }
            StandardEvaluationContext context = new StandardEvaluationContext(parameterValues[i]);
            Object key = this.parser.parseExpression(keyAnnotation.value()).getValue((EvaluationContext)context);
            parameterKey.add(ObjectUtils.nullSafeToString((Object)key));
        }
        return parameterKey;
    }
}

