/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.api;

import cn.jiguang.api.utils.ProtocolUtil;
import cn.jiguang.bx.c;
import cn.jiguang.bx.d;
import cn.jiguang.bx.f;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public abstract class JProtocol {
    private static final String TAG = "JProtocol";
    private static final int PACKET_SIZE = 7168;
    public static final int NO_SID = -1;
    public static final int NO_RESP_CODE = -1;
    public static final int NO_JUID = -1;
    public static final int DEFAULT_RID = 0;
    public static final int DEFAULT_SID = 0;
    public static final int DEFAULT_RESP_CODE = 0;
    private boolean isRequest;
    protected c head;
    protected ByteBuffer body;

    public JProtocol(boolean bl, Object object, ByteBuffer byteBuffer) {
        this.isRequest = bl;
        this.head = (c)object;
        if (null != byteBuffer) {
            this.body = byteBuffer;
            this.parseBody();
        } else {
            d.c(TAG, "No body to parse.");
        }
    }

    public JProtocol(boolean bl, ByteBuffer byteBuffer, byte[] byArray) {
        this.isRequest = bl;
        try {
            this.head = new c(bl, byArray);
        }
        catch (Exception exception) {
            d.c(TAG, "create JHead failed:" + exception.getMessage());
        }
        if (null != byteBuffer) {
            this.body = byteBuffer;
            this.parseBody();
        } else {
            d.c(TAG, "No body to parse.");
        }
    }

    public static byte[] parseHead(Object object) {
        if (object == null) {
            d.c(TAG, "object was null");
            return null;
        }
        if (object instanceof c) {
            return ((c)object).f();
        }
        d.c(TAG, "unknow Object");
        return null;
    }

    public JProtocol(boolean bl, int n2, int n3, long l2) {
        this.isRequest = bl;
        this.head = new c(bl, n2, n3, l2);
        this.body = ByteBuffer.allocate(7168);
    }

    public JProtocol(boolean bl, int n2, int n3, long l2, int n4, long l3) {
        this.isRequest = bl;
        this.head = new c(bl, 0, n2, n3, l2, n4, l3);
        this.body = ByteBuffer.allocate(7168);
    }

    public int getCommand() {
        return this.head.a();
    }

    public Long getRid() {
        return this.head.b();
    }

    public long getJuid() {
        return this.head.c();
    }

    public int getSid() {
        return this.head.d();
    }

    public int getVersion() {
        return this.head.e();
    }

    public c getHead() {
        return this.head;
    }

    public ByteBuffer getBody() {
        return this.body;
    }

    public abstract String getName();

    protected abstract void parseBody();

    protected abstract void writeBody();

    protected abstract boolean isNeedParseeErrorMsg();

    protected void writeBytes(byte[] byArray) {
        this.body.put(byArray);
    }

    protected void writeInt1(int n2) {
        this.body.put((byte)n2);
    }

    protected void writeInt2(int n2) {
        this.body.putShort((short)n2);
    }

    protected void writeInt4(int n2) {
        this.body.putInt(n2);
    }

    protected void writeLong8(long l2) {
        this.body.putLong(l2);
    }

    protected void writeTlv2(String string) {
        this.body.put(ProtocolUtil.tlv2ToByteArray(string));
    }

    public final byte[] writeBodyAndToBytes() {
        this.body.clear();
        this.writeBody();
        this.body.flip();
        return this.toBytes();
    }

    private final byte[] toBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = ProtocolUtil.getBytes(this.body);
        if (byArray == null) {
            d.c(TAG, "toBytes bodyBytes  is  null");
            return null;
        }
        this.head.a((this.isRequest ? 24 : 20) + byArray.length);
        try {
            byteArrayOutputStream.write(this.head.f());
            byteArrayOutputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        d.b(TAG, "Final - len:" + byArray2.length + ", bytes: " + f.a(byArray2));
        return byArray2;
    }

    public String toString() {
        return (this.isRequest ? "[Request]" : "[Response]") + " - " + this.head.toString();
    }
}

