/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.net;

import cn.jiguang.am.f;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLTrustManager
implements X509TrustManager {
    private X509TrustManager a;

    public SSLTrustManager(String string) {
        try {
            TrustManager[] trustManagerArray;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            ((InputStream)byteArrayInputStream).close();
            KeyStore.TrustedCertificateEntry trustedCertificateEntry = new KeyStore.TrustedCertificateEntry(x509Certificate);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setEntry("ca_root", trustedCertificateEntry, null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            for (TrustManager trustManager : trustManagerArray = trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                this.a = (X509TrustManager)trustManager;
                return;
            }
            throw new NoSuchAlgorithmException("No X509TrustManager found");
        }
        catch (Throwable throwable) {
            f.i("SSLTrustManager", "init trustManager failed, error:" + throwable);
            throw throwable;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        f.c("SSLTrustManager", "checkClientTrusted");
        this.a.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        f.c("SSLTrustManager", "checkServerTrusted");
        this.a.checkServerTrusted(x509CertificateArray, string);
        if (x509CertificateArray == null || x509CertificateArray.length == 0 || x509CertificateArray[0] == null) {
            throw new CertificateException("Check Server x509Certificates is empty");
        }
        try {
            x509CertificateArray[0].checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            f.i("SSLTrustManager", "checkServerTrusted: CertificateExpiredException:" + certificateExpiredException.getLocalizedMessage());
            throw certificateExpiredException;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            f.i("SSLTrustManager", "checkServerTrusted: CertificateNotYetValidException:" + certificateNotYetValidException.getLocalizedMessage());
            throw certificateNotYetValidException;
        }
        catch (Throwable throwable) {
            f.i("SSLTrustManager", "checkServerTrusted failed, error" + throwable.getLocalizedMessage());
            throw new CertificateException("Check Server x509Certificates exception: " + throwable);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        f.c("SSLTrustManager", "getAcceptedIssuers");
        return this.a.getAcceptedIssuers();
    }
}

