/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.protocol;

import cn.iflow.sdk.types.protocol.ImmutableAgentInfo;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
public interface AgentInfo {
    public String taskId();

    public String instanceId();

    public int index();

    public long timestamp();

    public static ImmutableAgentInfo.Builder builder() {
        return ImmutableAgentInfo.builder();
    }

    public static Optional<AgentInfo> parse(String agentId) {
        if (agentId == null || agentId.trim().isEmpty()) {
            return Optional.empty();
        }
        Pattern pattern = Pattern.compile("^subagent-([^-]+)-([^-]+)-(\\d+)-(\\d+)$");
        Matcher matcher = pattern.matcher(agentId.trim());
        if (!matcher.matches()) {
            return Optional.empty();
        }
        try {
            String taskId = matcher.group(1);
            String instanceId = matcher.group(2);
            int index = Integer.parseInt(matcher.group(3));
            long timestamp = Long.parseLong(matcher.group(4));
            return Optional.of(AgentInfo.builder().taskId(taskId).instanceId(instanceId).index(index).timestamp(timestamp).build());
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static AgentInfo of(String taskId, String instanceId, int index, long timestamp) {
        return AgentInfo.builder().taskId(taskId).instanceId(instanceId).index(index).timestamp(timestamp).build();
    }

    default public String toAgentId() {
        return String.format("subagent-%s-%s-%d-%d", this.taskId(), this.instanceId(), this.index(), this.timestamp());
    }
}

