/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.messages;

import cn.iflow.sdk.types.enums.MessageType;
import cn.iflow.sdk.types.messages.Message;
import java.util.Optional;
import lombok.Generated;

public class ErrorMessage
implements Message {
    private final String errorCode;
    private final String errorMessage;
    private final String details;
    private final String agentId;
    private final long timestamp;

    public ErrorMessage(String errorCode, String errorMessage, String details, String agentId, long timestamp) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.details = details;
        this.agentId = agentId;
        this.timestamp = timestamp;
    }

    public ErrorMessage(String errorCode, String errorMessage, String details, String agentId) {
        this(errorCode, errorMessage, details, agentId, System.currentTimeMillis());
    }

    public ErrorMessage(String errorCode, String errorMessage, String details) {
        this(errorCode, errorMessage, details, null, System.currentTimeMillis());
    }

    public ErrorMessage(String errorCode, String errorMessage) {
        this(errorCode, errorMessage, null, null, System.currentTimeMillis());
    }

    @Override
    public MessageType getType() {
        return MessageType.ERROR;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Optional<String> getAgentId() {
        return Optional.ofNullable(this.agentId);
    }

    public Optional<String> getDetails() {
        return Optional.ofNullable(this.details);
    }

    @Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        Optional<String> this$details = this.getDetails();
        Optional<String> other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        Optional<String> this$agentId = this.getAgentId();
        Optional<String> other$agentId = other.getAgentId();
        return !(this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ErrorMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        Optional<String> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        Optional<String> $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ErrorMessage(errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ", details=" + this.getDetails() + ", agentId=" + this.getAgentId() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

