/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.content;

import cn.iflow.sdk.types.content.AudioContent;
import cn.iflow.sdk.types.content.Content;
import cn.iflow.sdk.types.content.DiffContent;
import cn.iflow.sdk.types.content.ImageContent;
import cn.iflow.sdk.types.content.ResourceContent;
import cn.iflow.sdk.types.content.ResourceLinkContent;
import cn.iflow.sdk.types.content.TextContent;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class ContentTypeAdapter
implements JsonSerializer<Content>,
JsonDeserializer<Content> {
    public JsonElement serialize(Content src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", src.getType());
        JsonElement serialized = context.serialize((Object)src, src.getClass());
        for (String key : serialized.getAsJsonObject().keySet()) {
            jsonObject.add(key, serialized.getAsJsonObject().get(key));
        }
        return jsonObject;
    }

    public Content deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String type;
        JsonObject jsonObject = json.getAsJsonObject();
        switch (type = jsonObject.get("type").getAsString()) {
            case "text": {
                return (Content)context.deserialize(json, TextContent.class);
            }
            case "image": {
                return (Content)context.deserialize(json, ImageContent.class);
            }
            case "audio": {
                return (Content)context.deserialize(json, AudioContent.class);
            }
            case "resource_link": {
                return (Content)context.deserialize(json, ResourceLinkContent.class);
            }
            case "resource": {
                return (Content)context.deserialize(json, ResourceContent.class);
            }
            case "diff": {
                return (Content)context.deserialize(json, DiffContent.class);
            }
        }
        throw new JsonParseException("Unknown content type: " + type);
    }
}

