/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.config;

import cn.iflow.sdk.types.config.EnvVariable;
import cn.iflow.sdk.types.config.ImmutableMcpServerConfig;
import cn.iflow.sdk.types.enums.AuthProviderType;
import cn.iflow.sdk.types.enums.McpTransportType;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public interface McpServerConfig {
    @Nullable
    public String name();

    @Nullable
    public String description();

    public McpTransportType type();

    @Value.Default
    default public Integer timeout() {
        return 30000;
    }

    @Nullable
    public Boolean trust();

    @Nullable
    public String command();

    @Nullable
    public List<String> args();

    @Nullable
    public List<EnvVariable> env();

    @Nullable
    public String cwd();

    @Nullable
    public String url();

    @Nullable
    public String httpUrl();

    @Nullable
    public Map<String, String> headers();

    @Nullable
    public String tcp();

    @Nullable
    public List<String> includeTools();

    @Nullable
    public List<String> excludeTools();

    @Nullable
    public String extensionName();

    @Nullable
    public Map<String, Object> oauth();

    @Nullable
    public AuthProviderType authProviderType();

    public static ImmutableMcpServerConfig.Builder builder() {
        return ImmutableMcpServerConfig.builder();
    }

    public static McpServerConfig of(String name, String command) {
        return McpServerConfig.builder().name(name).command(command).type(McpTransportType.STDIO).build();
    }

    public static McpServerConfig of(String name, String command, List<String> args) {
        return McpServerConfig.builder().name(name).command(command).type(McpTransportType.STDIO).addAllArgs(args).build();
    }

    public static McpServerConfig forSSE(String name, String url) {
        return McpServerConfig.builder().name(name).type(McpTransportType.SSE).url(url).build();
    }

    public static McpServerConfig forStreamableHttp(String name, String url) {
        return McpServerConfig.builder().name(name).type(McpTransportType.STREAMABLE_HTTP).url(url).build();
    }

    public static McpServerConfig forHTTP(String name, String httpUrl) {
        return McpServerConfig.builder().name(name).type(McpTransportType.HTTP).httpUrl(httpUrl).build();
    }

    public static McpServerConfig forWebSocket(String name, String tcp) {
        return McpServerConfig.builder().name(name).type(McpTransportType.WEBSOCKET).tcp(tcp).build();
    }
}

