/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.config;

import cn.iflow.sdk.types.config.EnvVariable;
import cn.iflow.sdk.types.config.McpServerConfig;
import cn.iflow.sdk.types.enums.AuthProviderType;
import cn.iflow.sdk.types.enums.McpTransportType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="McpServerConfig", generator="Immutables")
@Immutable
public final class ImmutableMcpServerConfig
implements McpServerConfig {
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    private final McpTransportType type;
    private final Integer timeout;
    @Nullable
    private final Boolean trust;
    @Nullable
    private final String command;
    @Nullable
    private final List<String> args;
    @Nullable
    private final List<EnvVariable> env;
    @Nullable
    private final String cwd;
    @Nullable
    private final String url;
    @Nullable
    private final String httpUrl;
    @Nullable
    private final Map<String, String> headers;
    @Nullable
    private final String tcp;
    @Nullable
    private final List<String> includeTools;
    @Nullable
    private final List<String> excludeTools;
    @Nullable
    private final String extensionName;
    @Nullable
    private final Map<String, Object> oauth;
    @Nullable
    private final AuthProviderType authProviderType;

    private ImmutableMcpServerConfig(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.trust = builder.trust;
        this.command = builder.command;
        this.args = builder.args == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(true, builder.args);
        this.env = builder.env == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(true, builder.env);
        this.cwd = builder.cwd;
        this.url = builder.url;
        this.httpUrl = builder.httpUrl;
        this.headers = builder.headers == null ? null : ImmutableMcpServerConfig.createUnmodifiableMap(false, false, builder.headers);
        this.tcp = builder.tcp;
        this.includeTools = builder.includeTools == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(true, builder.includeTools);
        this.excludeTools = builder.excludeTools == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(true, builder.excludeTools);
        this.extensionName = builder.extensionName;
        this.oauth = builder.oauth == null ? null : ImmutableMcpServerConfig.createUnmodifiableMap(false, false, builder.oauth);
        this.authProviderType = builder.authProviderType;
        this.timeout = builder.timeout != null ? builder.timeout : Objects.requireNonNull(McpServerConfig.super.timeout(), "timeout");
    }

    private ImmutableMcpServerConfig(@Nullable String name, @Nullable String description, McpTransportType type, Integer timeout, @Nullable Boolean trust, @Nullable String command, @Nullable List<String> args, @Nullable List<EnvVariable> env, @Nullable String cwd, @Nullable String url, @Nullable String httpUrl, @Nullable Map<String, String> headers, @Nullable String tcp, @Nullable List<String> includeTools, @Nullable List<String> excludeTools, @Nullable String extensionName, @Nullable Map<String, Object> oauth, @Nullable AuthProviderType authProviderType) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.timeout = timeout;
        this.trust = trust;
        this.command = command;
        this.args = args;
        this.env = env;
        this.cwd = cwd;
        this.url = url;
        this.httpUrl = httpUrl;
        this.headers = headers;
        this.tcp = tcp;
        this.includeTools = includeTools;
        this.excludeTools = excludeTools;
        this.extensionName = extensionName;
        this.oauth = oauth;
        this.authProviderType = authProviderType;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    public McpTransportType type() {
        return this.type;
    }

    @Override
    public Integer timeout() {
        return this.timeout;
    }

    @Override
    @Nullable
    public Boolean trust() {
        return this.trust;
    }

    @Override
    @Nullable
    public String command() {
        return this.command;
    }

    @Override
    @Nullable
    public List<String> args() {
        return this.args;
    }

    @Override
    @Nullable
    public List<EnvVariable> env() {
        return this.env;
    }

    @Override
    @Nullable
    public String cwd() {
        return this.cwd;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public String httpUrl() {
        return this.httpUrl;
    }

    @Override
    @Nullable
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    @Nullable
    public String tcp() {
        return this.tcp;
    }

    @Override
    @Nullable
    public List<String> includeTools() {
        return this.includeTools;
    }

    @Override
    @Nullable
    public List<String> excludeTools() {
        return this.excludeTools;
    }

    @Override
    @Nullable
    public String extensionName() {
        return this.extensionName;
    }

    @Override
    @Nullable
    public Map<String, Object> oauth() {
        return this.oauth;
    }

    @Override
    @Nullable
    public AuthProviderType authProviderType() {
        return this.authProviderType;
    }

    public final ImmutableMcpServerConfig withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableMcpServerConfig(value, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, value, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withType(McpTransportType value) {
        McpTransportType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, newValue, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withTimeout(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "timeout");
        if (this.timeout.equals(newValue)) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, newValue, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withTrust(@Nullable Boolean value) {
        if (Objects.equals(this.trust, value)) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, value, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withCommand(@Nullable String value) {
        if (Objects.equals(this.command, value)) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, value, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withArgs(String ... elements) {
        if (elements == null) {
            return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, null, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(false, ImmutableMcpServerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, newValue, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withArgs(@Nullable Iterable<String> elements) {
        if (this.args == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(false, ImmutableMcpServerConfig.createSafeList(elements, true, false));
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, newValue, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withEnv(EnvVariable ... elements) {
        if (elements == null) {
            return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, null, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
        }
        List<EnvVariable> newValue = Arrays.asList(elements) == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(false, ImmutableMcpServerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, newValue, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withEnv(@Nullable Iterable<? extends EnvVariable> elements) {
        if (this.env == elements) {
            return this;
        }
        List<EnvVariable> newValue = elements == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(false, ImmutableMcpServerConfig.createSafeList(elements, true, false));
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, newValue, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withCwd(@Nullable String value) {
        if (Objects.equals(this.cwd, value)) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, value, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, value, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withHttpUrl(@Nullable String value) {
        if (Objects.equals(this.httpUrl, value)) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, value, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withHeaders(@Nullable Map<String, ? extends String> entries) {
        if (this.headers == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableMcpServerConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, newValue, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withTcp(@Nullable String value) {
        if (Objects.equals(this.tcp, value)) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, value, this.includeTools, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withIncludeTools(String ... elements) {
        if (elements == null) {
            return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, null, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(false, ImmutableMcpServerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, newValue, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withIncludeTools(@Nullable Iterable<String> elements) {
        if (this.includeTools == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(false, ImmutableMcpServerConfig.createSafeList(elements, true, false));
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, newValue, this.excludeTools, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withExcludeTools(String ... elements) {
        if (elements == null) {
            return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, null, this.extensionName, this.oauth, this.authProviderType);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(false, ImmutableMcpServerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, newValue, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withExcludeTools(@Nullable Iterable<String> elements) {
        if (this.excludeTools == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableMcpServerConfig.createUnmodifiableList(false, ImmutableMcpServerConfig.createSafeList(elements, true, false));
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, newValue, this.extensionName, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withExtensionName(@Nullable String value) {
        if (Objects.equals(this.extensionName, value)) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, value, this.oauth, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withOauth(@Nullable Map<String, ? extends Object> entries) {
        if (this.oauth == entries) {
            return this;
        }
        Map<String, Object> newValue = entries == null ? null : ImmutableMcpServerConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, newValue, this.authProviderType);
    }

    public final ImmutableMcpServerConfig withAuthProviderType(@Nullable AuthProviderType value) {
        if (this.authProviderType == value) {
            return this;
        }
        return new ImmutableMcpServerConfig(this.name, this.description, this.type, this.timeout, this.trust, this.command, this.args, this.env, this.cwd, this.url, this.httpUrl, this.headers, this.tcp, this.includeTools, this.excludeTools, this.extensionName, this.oauth, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMcpServerConfig && this.equalTo(0, (ImmutableMcpServerConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableMcpServerConfig another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && this.type.equals((Object)another.type) && this.timeout.equals(another.timeout) && Objects.equals(this.trust, another.trust) && Objects.equals(this.command, another.command) && Objects.equals(this.args, another.args) && Objects.equals(this.env, another.env) && Objects.equals(this.cwd, another.cwd) && Objects.equals(this.url, another.url) && Objects.equals(this.httpUrl, another.httpUrl) && Objects.equals(this.headers, another.headers) && Objects.equals(this.tcp, another.tcp) && Objects.equals(this.includeTools, another.includeTools) && Objects.equals(this.excludeTools, another.excludeTools) && Objects.equals(this.extensionName, another.extensionName) && Objects.equals(this.oauth, another.oauth) && Objects.equals((Object)this.authProviderType, (Object)another.authProviderType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.timeout.hashCode();
        h += (h << 5) + Objects.hashCode(this.trust);
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + Objects.hashCode(this.args);
        h += (h << 5) + Objects.hashCode(this.env);
        h += (h << 5) + Objects.hashCode(this.cwd);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.httpUrl);
        h += (h << 5) + Objects.hashCode(this.headers);
        h += (h << 5) + Objects.hashCode(this.tcp);
        h += (h << 5) + Objects.hashCode(this.includeTools);
        h += (h << 5) + Objects.hashCode(this.excludeTools);
        h += (h << 5) + Objects.hashCode(this.extensionName);
        h += (h << 5) + Objects.hashCode(this.oauth);
        h += (h << 5) + Objects.hashCode((Object)this.authProviderType);
        return h;
    }

    public String toString() {
        return "McpServerConfig{name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", timeout=" + this.timeout + ", trust=" + this.trust + ", command=" + this.command + ", args=" + this.args + ", env=" + this.env + ", cwd=" + this.cwd + ", url=" + this.url + ", httpUrl=" + this.httpUrl + ", headers=" + this.headers + ", tcp=" + this.tcp + ", includeTools=" + this.includeTools + ", excludeTools=" + this.excludeTools + ", extensionName=" + this.extensionName + ", oauth=" + this.oauth + ", authProviderType=" + this.authProviderType + "}";
    }

    public static ImmutableMcpServerConfig copyOf(McpServerConfig instance) {
        if (instance instanceof ImmutableMcpServerConfig) {
            return (ImmutableMcpServerConfig)instance;
        }
        return ImmutableMcpServerConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="McpServerConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private McpTransportType type;
        @Nullable
        private Integer timeout;
        @Nullable
        private Boolean trust;
        @Nullable
        private String command;
        private List<String> args = null;
        private List<EnvVariable> env = null;
        @Nullable
        private String cwd;
        @Nullable
        private String url;
        @Nullable
        private String httpUrl;
        private Map<String, String> headers = null;
        @Nullable
        private String tcp;
        private List<String> includeTools = null;
        private List<String> excludeTools = null;
        @Nullable
        private String extensionName;
        private Map<String, Object> oauth = null;
        @Nullable
        private AuthProviderType authProviderType;

        private Builder() {
        }

        public final Builder from(McpServerConfig instance) {
            AuthProviderType authProviderTypeValue;
            Map<String, Object> oauthValue;
            String extensionNameValue;
            List<String> excludeToolsValue;
            List<String> includeToolsValue;
            String tcpValue;
            Map<String, String> headersValue;
            String httpUrlValue;
            String urlValue;
            String cwdValue;
            List<EnvVariable> envValue;
            List<String> argsValue;
            String commandValue;
            String descriptionValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((descriptionValue = instance.description()) != null) {
                this.description(descriptionValue);
            }
            this.type(instance.type());
            this.timeout(instance.timeout());
            Boolean trustValue = instance.trust();
            if (trustValue != null) {
                this.trust(trustValue);
            }
            if ((commandValue = instance.command()) != null) {
                this.command(commandValue);
            }
            if ((argsValue = instance.args()) != null) {
                this.addAllArgs(argsValue);
            }
            if ((envValue = instance.env()) != null) {
                this.addAllEnv(envValue);
            }
            if ((cwdValue = instance.cwd()) != null) {
                this.cwd(cwdValue);
            }
            if ((urlValue = instance.url()) != null) {
                this.url(urlValue);
            }
            if ((httpUrlValue = instance.httpUrl()) != null) {
                this.httpUrl(httpUrlValue);
            }
            if ((headersValue = instance.headers()) != null) {
                this.putAllHeaders(headersValue);
            }
            if ((tcpValue = instance.tcp()) != null) {
                this.tcp(tcpValue);
            }
            if ((includeToolsValue = instance.includeTools()) != null) {
                this.addAllIncludeTools(includeToolsValue);
            }
            if ((excludeToolsValue = instance.excludeTools()) != null) {
                this.addAllExcludeTools(excludeToolsValue);
            }
            if ((extensionNameValue = instance.extensionName()) != null) {
                this.extensionName(extensionNameValue);
            }
            if ((oauthValue = instance.oauth()) != null) {
                this.putAllOauth(oauthValue);
            }
            if ((authProviderTypeValue = instance.authProviderType()) != null) {
                this.authProviderType(authProviderTypeValue);
            }
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder type(McpTransportType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder timeout(Integer timeout) {
            this.timeout = Objects.requireNonNull(timeout, "timeout");
            return this;
        }

        public final Builder trust(@Nullable Boolean trust) {
            this.trust = trust;
            return this;
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        public final Builder addArgs(String element) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            this.args.add(Objects.requireNonNull(element, "args element"));
            return this;
        }

        public final Builder addArgs(String ... elements) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            for (String element : elements) {
                this.args.add(Objects.requireNonNull(element, "args element"));
            }
            return this;
        }

        public final Builder args(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.args = null;
                return this;
            }
            this.args = new ArrayList<String>();
            return this.addAllArgs(elements);
        }

        public final Builder addAllArgs(Iterable<String> elements) {
            Objects.requireNonNull(elements, "args element");
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            for (String element : elements) {
                this.args.add(Objects.requireNonNull(element, "args element"));
            }
            return this;
        }

        public final Builder addEnv(EnvVariable element) {
            if (this.env == null) {
                this.env = new ArrayList<EnvVariable>();
            }
            this.env.add(Objects.requireNonNull(element, "env element"));
            return this;
        }

        public final Builder addEnv(EnvVariable ... elements) {
            if (this.env == null) {
                this.env = new ArrayList<EnvVariable>();
            }
            for (EnvVariable element : elements) {
                this.env.add(Objects.requireNonNull(element, "env element"));
            }
            return this;
        }

        public final Builder env(@Nullable Iterable<? extends EnvVariable> elements) {
            if (elements == null) {
                this.env = null;
                return this;
            }
            this.env = new ArrayList<EnvVariable>();
            return this.addAllEnv(elements);
        }

        public final Builder addAllEnv(Iterable<? extends EnvVariable> elements) {
            Objects.requireNonNull(elements, "env element");
            if (this.env == null) {
                this.env = new ArrayList<EnvVariable>();
            }
            for (EnvVariable envVariable : elements) {
                this.env.add(Objects.requireNonNull(envVariable, "env element"));
            }
            return this;
        }

        public final Builder cwd(@Nullable String cwd) {
            this.cwd = cwd;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder httpUrl(@Nullable String httpUrl) {
            this.httpUrl = httpUrl;
            return this;
        }

        public final Builder putHeaders(String key, String value) {
            if (this.headers == null) {
                this.headers = new LinkedHashMap<String, String>();
            }
            this.headers.put(Objects.requireNonNull(key, "headers key"), value == null ? Objects.requireNonNull(value, "headers value for key: " + key) : value);
            return this;
        }

        public final Builder putHeaders(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.headers == null) {
                this.headers = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.headers.put(Objects.requireNonNull(k, "headers key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "headers value for key: " + k) : v);
            return this;
        }

        public final Builder headers(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.headers = null;
                return this;
            }
            this.headers = new LinkedHashMap<String, String>();
            return this.putAllHeaders(entries);
        }

        public final Builder putAllHeaders(Map<String, ? extends String> entries) {
            if (this.headers == null) {
                this.headers = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.headers.put(Objects.requireNonNull(k, "headers key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "headers value for key: " + k) : v);
            }
            return this;
        }

        public final Builder tcp(@Nullable String tcp) {
            this.tcp = tcp;
            return this;
        }

        public final Builder addIncludeTools(String element) {
            if (this.includeTools == null) {
                this.includeTools = new ArrayList<String>();
            }
            this.includeTools.add(Objects.requireNonNull(element, "includeTools element"));
            return this;
        }

        public final Builder addIncludeTools(String ... elements) {
            if (this.includeTools == null) {
                this.includeTools = new ArrayList<String>();
            }
            for (String element : elements) {
                this.includeTools.add(Objects.requireNonNull(element, "includeTools element"));
            }
            return this;
        }

        public final Builder includeTools(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.includeTools = null;
                return this;
            }
            this.includeTools = new ArrayList<String>();
            return this.addAllIncludeTools(elements);
        }

        public final Builder addAllIncludeTools(Iterable<String> elements) {
            Objects.requireNonNull(elements, "includeTools element");
            if (this.includeTools == null) {
                this.includeTools = new ArrayList<String>();
            }
            for (String element : elements) {
                this.includeTools.add(Objects.requireNonNull(element, "includeTools element"));
            }
            return this;
        }

        public final Builder addExcludeTools(String element) {
            if (this.excludeTools == null) {
                this.excludeTools = new ArrayList<String>();
            }
            this.excludeTools.add(Objects.requireNonNull(element, "excludeTools element"));
            return this;
        }

        public final Builder addExcludeTools(String ... elements) {
            if (this.excludeTools == null) {
                this.excludeTools = new ArrayList<String>();
            }
            for (String element : elements) {
                this.excludeTools.add(Objects.requireNonNull(element, "excludeTools element"));
            }
            return this;
        }

        public final Builder excludeTools(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.excludeTools = null;
                return this;
            }
            this.excludeTools = new ArrayList<String>();
            return this.addAllExcludeTools(elements);
        }

        public final Builder addAllExcludeTools(Iterable<String> elements) {
            Objects.requireNonNull(elements, "excludeTools element");
            if (this.excludeTools == null) {
                this.excludeTools = new ArrayList<String>();
            }
            for (String element : elements) {
                this.excludeTools.add(Objects.requireNonNull(element, "excludeTools element"));
            }
            return this;
        }

        public final Builder extensionName(@Nullable String extensionName) {
            this.extensionName = extensionName;
            return this;
        }

        public final Builder putOauth(String key, Object value) {
            if (this.oauth == null) {
                this.oauth = new LinkedHashMap<String, Object>();
            }
            this.oauth.put(Objects.requireNonNull(key, "oauth key"), value == null ? Objects.requireNonNull(value, "oauth value for key: " + key) : value);
            return this;
        }

        public final Builder putOauth(Map.Entry<String, ? extends Object> entry) {
            Object v;
            if (this.oauth == null) {
                this.oauth = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            this.oauth.put(Objects.requireNonNull(k, "oauth key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "oauth value for key: " + k) : v);
            return this;
        }

        public final Builder oauth(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.oauth = null;
                return this;
            }
            this.oauth = new LinkedHashMap<String, Object>();
            return this.putAllOauth(entries);
        }

        public final Builder putAllOauth(Map<String, ? extends Object> entries) {
            if (this.oauth == null) {
                this.oauth = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                Object v;
                String k = e.getKey();
                this.oauth.put(Objects.requireNonNull(k, "oauth key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "oauth value for key: " + k) : v);
            }
            return this;
        }

        public final Builder authProviderType(@Nullable AuthProviderType authProviderType) {
            this.authProviderType = authProviderType;
            return this;
        }

        public ImmutableMcpServerConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMcpServerConfig(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build McpServerConfig, some of required attributes are not set " + attributes;
        }
    }
}

