/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.config;

import cn.iflow.sdk.types.config.HookCommand;
import cn.iflow.sdk.types.config.HookEventConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="HookEventConfig", generator="Immutables")
@Immutable
public final class ImmutableHookEventConfig
implements HookEventConfig {
    private final String matcher;
    private final List<HookCommand> hooks;

    private ImmutableHookEventConfig(String matcher, List<HookCommand> hooks) {
        this.matcher = matcher;
        this.hooks = hooks;
    }

    @Override
    public String matcher() {
        return this.matcher;
    }

    @Override
    public List<HookCommand> hooks() {
        return this.hooks;
    }

    public final ImmutableHookEventConfig withMatcher(String value) {
        String newValue = Objects.requireNonNull(value, "matcher");
        if (this.matcher.equals(newValue)) {
            return this;
        }
        return new ImmutableHookEventConfig(newValue, this.hooks);
    }

    public final ImmutableHookEventConfig withHooks(HookCommand ... elements) {
        List<HookCommand> newValue = ImmutableHookEventConfig.createUnmodifiableList(false, ImmutableHookEventConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHookEventConfig(this.matcher, newValue);
    }

    public final ImmutableHookEventConfig withHooks(Iterable<? extends HookCommand> elements) {
        if (this.hooks == elements) {
            return this;
        }
        List<HookCommand> newValue = ImmutableHookEventConfig.createUnmodifiableList(false, ImmutableHookEventConfig.createSafeList(elements, true, false));
        return new ImmutableHookEventConfig(this.matcher, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHookEventConfig && this.equalTo(0, (ImmutableHookEventConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableHookEventConfig another) {
        return this.matcher.equals(another.matcher) && this.hooks.equals(another.hooks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.matcher.hashCode();
        h += (h << 5) + this.hooks.hashCode();
        return h;
    }

    public String toString() {
        return "HookEventConfig{matcher=" + this.matcher + ", hooks=" + this.hooks + "}";
    }

    public static ImmutableHookEventConfig copyOf(HookEventConfig instance) {
        if (instance instanceof ImmutableHookEventConfig) {
            return (ImmutableHookEventConfig)instance;
        }
        return ImmutableHookEventConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="HookEventConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MATCHER = 1L;
        private long initBits = 1L;
        @Nullable
        private String matcher;
        private List<HookCommand> hooks = new ArrayList<HookCommand>();

        private Builder() {
        }

        public final Builder from(HookEventConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.matcher(instance.matcher());
            this.addAllHooks(instance.hooks());
            return this;
        }

        public final Builder matcher(String matcher) {
            this.matcher = Objects.requireNonNull(matcher, "matcher");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addHooks(HookCommand element) {
            this.hooks.add(Objects.requireNonNull(element, "hooks element"));
            return this;
        }

        public final Builder addHooks(HookCommand ... elements) {
            for (HookCommand element : elements) {
                this.hooks.add(Objects.requireNonNull(element, "hooks element"));
            }
            return this;
        }

        public final Builder hooks(Iterable<? extends HookCommand> elements) {
            this.hooks.clear();
            return this.addAllHooks(elements);
        }

        public final Builder addAllHooks(Iterable<? extends HookCommand> elements) {
            for (HookCommand hookCommand : elements) {
                this.hooks.add(Objects.requireNonNull(hookCommand, "hooks element"));
            }
            return this;
        }

        public ImmutableHookEventConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHookEventConfig(this.matcher, ImmutableHookEventConfig.createUnmodifiableList(true, this.hooks));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("matcher");
            }
            return "Cannot build HookEventConfig, some of required attributes are not set " + attributes;
        }
    }
}

