/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.config;

import cn.iflow.sdk.types.config.HookCommand;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="HookCommand", generator="Immutables")
@Immutable
public final class ImmutableHookCommand
implements HookCommand {
    private final String type;
    private final String command;
    private final Integer timeout;

    private ImmutableHookCommand(Builder builder) {
        this.command = builder.command;
        this.timeout = builder.timeout;
        this.type = builder.type != null ? builder.type : Objects.requireNonNull(HookCommand.super.type(), "type");
    }

    private ImmutableHookCommand(String type, String command, Integer timeout) {
        this.type = type;
        this.command = command;
        this.timeout = timeout;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String command() {
        return this.command;
    }

    @Override
    public Integer timeout() {
        return this.timeout;
    }

    public final ImmutableHookCommand withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableHookCommand(newValue, this.command, this.timeout);
    }

    public final ImmutableHookCommand withCommand(String value) {
        String newValue = Objects.requireNonNull(value, "command");
        if (this.command.equals(newValue)) {
            return this;
        }
        return new ImmutableHookCommand(this.type, newValue, this.timeout);
    }

    public final ImmutableHookCommand withTimeout(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "timeout");
        if (this.timeout.equals(newValue)) {
            return this;
        }
        return new ImmutableHookCommand(this.type, this.command, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHookCommand && this.equalTo(0, (ImmutableHookCommand)another);
    }

    private boolean equalTo(int synthetic, ImmutableHookCommand another) {
        return this.type.equals(another.type) && this.command.equals(another.command) && this.timeout.equals(another.timeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + this.timeout.hashCode();
        return h;
    }

    public String toString() {
        return "HookCommand{type=" + this.type + ", command=" + this.command + ", timeout=" + this.timeout + "}";
    }

    public static ImmutableHookCommand copyOf(HookCommand instance) {
        if (instance instanceof ImmutableHookCommand) {
            return (ImmutableHookCommand)instance;
        }
        return ImmutableHookCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HookCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMAND = 1L;
        private static final long INIT_BIT_TIMEOUT = 2L;
        private long initBits = 3L;
        @Nullable
        private String type;
        @Nullable
        private String command;
        @Nullable
        private Integer timeout;

        private Builder() {
        }

        public final Builder from(HookCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.command(instance.command());
            this.timeout(instance.timeout());
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder timeout(Integer timeout) {
            this.timeout = Objects.requireNonNull(timeout, "timeout");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableHookCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHookCommand(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("command");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("timeout");
            }
            return "Cannot build HookCommand, some of required attributes are not set " + attributes;
        }
    }
}

