/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.process;

import cn.iflow.sdk.exceptions.ProcessException;
import cn.iflow.sdk.types.config.IFlowOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IFlowProcessManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IFlowProcessManager.class);
    private final IFlowOptions options;
    private final AtomicBoolean processStarted = new AtomicBoolean(false);
    private final AtomicReference<Process> process = new AtomicReference();
    private final AtomicReference<Integer> detectedPort = new AtomicReference();

    public IFlowProcessManager(IFlowOptions options) {
        this.options = options;
    }

    public CompletableFuture<Integer> ensureProcessRunning() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (!this.options.isAutoStartProcess()) {
                    Integer existingPort = this.detectExistingProcess();
                    if (existingPort != null) {
                        log.info("Found existing iFlow process on port: " + existingPort);
                        this.detectedPort.set(existingPort);
                        return existingPort;
                    }
                    throw new ProcessException("iFlow process not found and auto-start is disabled");
                }
                if (this.processStarted.get() && this.detectedPort.get() != null) {
                    return this.detectedPort.get();
                }
                Integer existingPort = this.detectExistingProcess();
                if (existingPort != null) {
                    log.info("Found existing iFlow process on port: " + existingPort);
                    this.detectedPort.set(existingPort);
                    return existingPort;
                }
                log.info("Starting new iFlow process...");
                return this.startNewProcess();
            }
            catch (Exception e) {
                if (e instanceof ProcessException) {
                    throw (ProcessException)e;
                }
                throw new ProcessException("Failed to ensure iFlow process is running", e);
            }
        });
    }

    public CompletableFuture<Void> stopProcess() {
        return CompletableFuture.supplyAsync(() -> {
            Process proc = this.process.get();
            if (proc != null && this.processStarted.get()) {
                try {
                    log.info("Stopping iFlow process...");
                    proc.destroy();
                    boolean exited = proc.waitFor(5L, TimeUnit.SECONDS);
                    if (!exited) {
                        log.warn("Process did not exit gracefully, forcing termination");
                        proc.destroyForcibly();
                        proc.waitFor(2L, TimeUnit.SECONDS);
                    }
                    log.info("iFlow process stopped");
                    this.processStarted.set(false);
                    this.process.set(null);
                    this.detectedPort.set(null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(new ProcessException("Interrupted while stopping process", e));
                }
                catch (Exception e) {
                    throw new RuntimeException(new ProcessException("Failed to stop iFlow process", e));
                }
            }
            return null;
        });
    }

    public Integer getPort() {
        return this.detectedPort.get();
    }

    public boolean isProcessRunning() {
        Process proc = this.process.get();
        return proc != null && proc.isAlive();
    }

    @Override
    public void close() throws Exception {
        this.stopProcess().join();
    }

    private Integer detectExistingProcess() {
        try {
            for (int port : new int[]{8090, 8091, 8092, 3000, 3001}) {
                if (!this.isPortInUse(port) || !this.isIFlowRunningOnPort(port)) continue;
                return port;
            }
            return this.detectProcessByCommand();
        }
        catch (Exception e) {
            log.debug("Error detecting existing process: " + e.getMessage());
            return null;
        }
    }

    private int startNewProcess() throws ProcessException {
        try {
            int port = this.findAvailablePort();
            List<String> command = this.buildStartCommand(port);
            log.info("Starting iFlow with command: " + String.join((CharSequence)" ", command));
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.directory(this.options.getWorkingDirectory().toFile());
            Process proc = processBuilder.start();
            this.process.set(proc);
            boolean started = this.waitForProcessStart(proc, port);
            if (!started) {
                proc.destroyForcibly();
                throw new ProcessException("iFlow process failed to start within timeout");
            }
            this.processStarted.set(true);
            this.detectedPort.set(port);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    this.stopProcess().join();
                }
                catch (Exception e) {
                    log.warn("Error stopping process during shutdown: " + e.getMessage());
                }
            }));
            log.info("iFlow process started successfully on port: " + port);
            return port;
        }
        catch (IOException e) {
            throw new ProcessException("Failed to start iFlow process", e);
        }
    }

    private List<String> buildStartCommand(int port) {
        ArrayList<String> command = new ArrayList<String>();
        String executable = this.options.getIflowExecutable();
        if (executable == null || executable.isEmpty()) {
            executable = "iflow";
        }
        command.add(executable);
        command.add("--experimental-acp");
        command.add("--port");
        command.add(String.valueOf(port));
        return command;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForProcessStart(Process proc, int port) {
        startTime = System.currentTimeMillis();
        timeout = this.options.getProcessStartTimeout().toMillis();
        try {
            reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            ** try [egrp 1[TRYBLOCK] [2 : 36->67)] { 
lbl6:
            // 1 sources

            ** GOTO lbl-1000
lbl7:
            // 1 sources

            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            IFlowProcessManager.log.warn("Error reading process output: " + e.getMessage());
        }
        return false;
lbl-1000:
        // 2 sources

        {
            while (System.currentTimeMillis() - startTime < timeout) {
                if (!proc.isAlive()) {
                    IFlowProcessManager.log.warn("iFlow process exited unexpectedly");
                    var9_7 = false;
                    return var9_7;
                }
                if (this.isPortInUse(port)) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        var10_12 = false;
                        reader.close();
                        return var10_12;
                    }
                    e = true;
                    return e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    var10_13 = false;
                    reader.close();
                    return var10_13;
                }
            }
            return false;
        }
    }

    private int findAvailablePort() throws ProcessException {
        if (this.options.getProcessStartPort() > 0) {
            if (this.isPortInUse(this.options.getProcessStartPort())) {
                throw new ProcessException("Specified port " + this.options.getProcessStartPort() + " is already in use");
            }
            return this.options.getProcessStartPort();
        }
        for (int port : new int[]{8090, 8091, 8092, 3000, 3001, 3002}) {
            if (this.isPortInUse(port)) continue;
            return port;
        }
        for (int i = 0; i < 10; ++i) {
            int port = 8090 + (int)(Math.random() * 100.0);
            if (this.isPortInUse(port)) continue;
            return port;
        }
        throw new ProcessException("Could not find available port for iFlow");
    }

    private boolean isPortInUse(int port) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress("localhost", port), 1000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private boolean isIFlowRunningOnPort(int port) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer detectProcessByCommand() {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            String[] command = os.contains("win") ? new String[]{"wmic", "process", "get", "commandline", "/format:list"} : new String[]{"ps", "aux"};
            Process proc = Runtime.getRuntime().exec(command);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line;
                Pattern portPattern = Pattern.compile("--port[\\s=](\\d+)");
                while ((line = reader.readLine()) != null) {
                    Matcher matcher;
                    if (!line.contains("iflow") || !line.contains("--experimental-acp") || !(matcher = portPattern.matcher(line)).find()) continue;
                    Integer n = Integer.parseInt(matcher.group(1));
                    return n;
                }
            }
            proc.waitFor();
            return null;
        }
        catch (Exception e) {
            log.debug("Error detecting process by command: " + e.getMessage());
        }
        return null;
    }
}

