/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.examples;

import cn.iflow.sdk.core.IFlowClient;
import cn.iflow.sdk.types.messages.AssistantMessage;
import cn.iflow.sdk.types.messages.TaskFinishMessage;
import java.util.concurrent.atomic.AtomicBoolean;

public class SimpleExample {
    public static void main(String[] args) {
        try (IFlowClient client = IFlowClient.create();){
            System.out.println("\u6b63\u5728\u8fde\u63a5\u5230 iFlow...");
            client.connect().block();
            System.out.println("\u8fde\u63a5\u6210\u529f\uff01\n");
            String question = "1+1\u7b49\u4e8e\u51e0\uff1f";
            System.out.println("\u95ee\u9898: " + question);
            client.sendMessage(question).block();
            System.out.println("\u56de\u7b54: ");
            AtomicBoolean finished = new AtomicBoolean(false);
            client.receiveMessages().doOnNext(message -> {
                if (message instanceof AssistantMessage) {
                    AssistantMessage assistantMsg = (AssistantMessage)message;
                    if (assistantMsg.getChunk() != null && assistantMsg.getChunk().getText() != null) {
                        System.out.print(assistantMsg.getChunk().getText());
                    }
                } else if (message instanceof TaskFinishMessage) {
                    finished.set(true);
                }
            }).takeWhile(message -> !finished.get()).blockLast();
            System.out.println("\n\n\u5b8c\u6210\uff01");
        }
        catch (Exception e) {
            System.err.println("\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

