/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.examples;

import cn.iflow.sdk.core.IFlowClient;
import cn.iflow.sdk.types.config.IFlowOptions;
import cn.iflow.sdk.types.messages.AssistantMessage;
import cn.iflow.sdk.types.messages.ErrorMessage;
import cn.iflow.sdk.types.messages.Message;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoAutoStart {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DemoAutoStart.class);

    public static void main(String[] args) {
        System.out.println("\n\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557\n\u2551         iFlow SDK \u81ea\u52a8\u542f\u52a8\u529f\u80fd\u6f14\u793a                     \u2551\n\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        System.out.println("\ud83d\udccc \u529f\u80fd\u7279\u70b9:");
        System.out.println("   \u2022 \u81ea\u52a8\u68c0\u6d4b iFlow \u662f\u5426\u5b89\u88c5");
        System.out.println("   \u2022 \u81ea\u52a8\u542f\u52a8 iFlow \u8fdb\u7a0b");
        System.out.println("   \u2022 \u667a\u80fd\u67e5\u627e\u53ef\u7528\u7aef\u53e3");
        System.out.println("   \u2022 \u9000\u51fa\u65f6\u81ea\u52a8\u6e05\u7406\u8fdb\u7a0b");
        System.out.println("\n" + "=".repeat(60) + "\n");
        try {
            DemoAutoStart.demo();
        }
        catch (Exception e) {
            System.err.println("\u6f14\u793a\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void demo() throws Exception {
        IFlowClient client;
        IFlowOptions options;
        System.out.println("\ud83d\udccb \u6f14\u793a 1: \u57fa\u672c\u4f7f\u7528\uff08\u5168\u81ea\u52a8\uff09");
        System.out.println("-".repeat(40));
        try {
            try (IFlowClient client2 = IFlowClient.create();){
                client2.connect().block();
                System.out.println("\u2705 \u5df2\u8fde\u63a5\u5230 iFlow");
                System.out.println("   URL: ws://localhost:8090/acp");
                client2.sendMessage("1+1\u7b49\u4e8e\u51e0\uff1f").block();
                System.out.println("\ud83d\udce4 \u53d1\u9001: 1+1\u7b49\u4e8e\u51e0\uff1f");
                System.out.print("\ud83d\udce5 \u54cd\u5e94: ");
                DemoAutoStart.handleSimpleResponse(client2);
            }
            System.out.println("\ud83d\udd04 \u5ba2\u6237\u7aef\u5173\u95ed\uff0ciFlow \u8fdb\u7a0b\u5df2\u81ea\u52a8\u6e05\u7406\n");
        }
        catch (Exception e) {
            System.out.println("\u274c \u9519\u8bef: " + e.getMessage() + "\n");
        }
        System.out.println("=".repeat(60));
        System.out.println("\n\ud83d\udccb \u6f14\u793a 2: \u81ea\u5b9a\u4e49\u7aef\u53e3\u914d\u7f6e");
        System.out.println("-".repeat(40));
        try {
            options = IFlowOptions.builder().autoStartProcess(true).processStartPort(10000).build();
            client = IFlowClient.create(options);
            try {
                client.connect().block();
                System.out.println("\u2705 \u5df2\u8fde\u63a5\u5230\u81ea\u5b9a\u4e49\u7aef\u53e3");
                System.out.println("   URL: ws://localhost:10000/acp");
                client.sendMessage("\u4f60\u597d").block();
                System.out.println("\ud83d\udce4 \u53d1\u9001: \u4f60\u597d");
                Message message = (Message)client.receiveMessages().take(1L).blockFirst();
                if (message != null) {
                    System.out.println("\ud83d\udce5 \u54cd\u5e94: " + ((AssistantMessage)message).getChunk().getText());
                }
                Thread.sleep(1000L);
                System.out.println("\u2705 \u6d4b\u8bd5\u6210\u529f");
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
            System.out.println("\ud83d\udd04 \u8fdb\u7a0b\u5df2\u6e05\u7406\n");
        }
        catch (Exception e) {
            System.out.println("\u274c \u9519\u8bef: " + e.getMessage() + "\n");
        }
        System.out.println("=".repeat(60));
        System.out.println("\n\ud83d\udccb \u6f14\u793a 3: \u8fde\u63a5\u5230\u5df2\u8fd0\u884c\u7684 iFlow\uff08\u7981\u7528\u81ea\u52a8\u542f\u52a8\uff09");
        System.out.println("-".repeat(40));
        options = IFlowOptions.builder().autoStartProcess(false).url("ws://localhost:8090/acp").build();
        try {
            client = IFlowClient.create(options);
            try {
                client.connect().block();
                System.out.println("\u2705 \u8fde\u63a5\u5230\u5df2\u5b58\u5728\u7684 iFlow \u5b9e\u4f8b");
                System.out.println("   URL: ws://localhost:8090/acp");
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u26a0\ufe0f \u8fde\u63a5\u5931\u8d25\uff08\u5982\u679c\u7aef\u53e3 8090 \u6ca1\u6709 iFlow \u8fd0\u884c\uff09");
            System.out.println("   \u8fd9\u662f\u9884\u671f\u7684\u884c\u4e3a - \u7981\u7528\u4e86\u81ea\u52a8\u542f\u52a8");
        }
        System.out.println("\n" + "=".repeat(60));
        System.out.println("\n\u2728 \u6f14\u793a\u5b8c\u6210\uff01");
        DemoAutoStart.printSummary();
    }

    private static void handleSimpleResponse(IFlowClient client) {
        AtomicBoolean finished = new AtomicBoolean(false);
        client.receiveMessages().takeUntil(msg -> finished.get()).doOnNext(message -> {
            switch (message.getType()) {
                case ASSISTANT_MESSAGE: {
                    AssistantMessage assistantMsg = (AssistantMessage)message;
                    if (assistantMsg.getChunk().getText() == null) break;
                    System.out.print(assistantMsg.getChunk().getText());
                    break;
                }
                case TASK_FINISH: {
                    System.out.println("\n\u2705 \u54cd\u5e94\u5b8c\u6210");
                    finished.set(true);
                    break;
                }
                case ERROR: {
                    ErrorMessage error = (ErrorMessage)message;
                    System.out.println("\n\u274c \u9519\u8bef: " + error.getErrorMessage());
                    finished.set(true);
                }
            }
        }).blockLast();
    }

    private static void printSummary() {
        System.out.println("\n\ud83d\udcdd \u603b\u7ed3:");
        System.out.println("   1. SDK \u9ed8\u8ba4\u4f1a\u81ea\u52a8\u7ba1\u7406 iFlow \u8fdb\u7a0b");
        System.out.println("   2. \u53ef\u4ee5\u81ea\u5b9a\u4e49\u7aef\u53e3\u8303\u56f4");
        System.out.println("   3. \u53ef\u4ee5\u7981\u7528\u81ea\u52a8\u542f\u52a8\uff0c\u8fde\u63a5\u5230\u73b0\u6709\u5b9e\u4f8b");
        System.out.println("   4. \u4f7f\u7528 try-with-resources \u8bed\u6cd5\u81ea\u52a8\u6e05\u7406\u8d44\u6e90");
    }
}

