/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.core;

import cn.iflow.sdk.core.IFlowClient;
import cn.iflow.sdk.exceptions.ConnectionException;
import cn.iflow.sdk.exceptions.ProcessException;
import cn.iflow.sdk.exceptions.ProtocolException;
import cn.iflow.sdk.file.FileSystemHandler;
import cn.iflow.sdk.process.IFlowProcessManager;
import cn.iflow.sdk.protocol.ACPProtocol;
import cn.iflow.sdk.transport.WebSocketTransport;
import cn.iflow.sdk.types.config.CommandConfig;
import cn.iflow.sdk.types.config.CreateAgentConfig;
import cn.iflow.sdk.types.config.HookEventConfig;
import cn.iflow.sdk.types.config.IFlowOptions;
import cn.iflow.sdk.types.config.McpServerConfig;
import cn.iflow.sdk.types.content.AudioContent;
import cn.iflow.sdk.types.content.Content;
import cn.iflow.sdk.types.content.ImageContent;
import cn.iflow.sdk.types.content.ResourceLinkContent;
import cn.iflow.sdk.types.content.TextContent;
import cn.iflow.sdk.types.enums.HookEventType;
import cn.iflow.sdk.types.enums.StopReason;
import cn.iflow.sdk.types.enums.ToolCallStatus;
import cn.iflow.sdk.types.messages.AssistantMessage;
import cn.iflow.sdk.types.messages.DiffToolCallContent;
import cn.iflow.sdk.types.messages.ErrorMessage;
import cn.iflow.sdk.types.messages.MarkdownToolCallContent;
import cn.iflow.sdk.types.messages.Message;
import cn.iflow.sdk.types.messages.PermissionRequestMessage;
import cn.iflow.sdk.types.messages.PlanMessage;
import cn.iflow.sdk.types.messages.TaskFinishMessage;
import cn.iflow.sdk.types.messages.ToolCallContent;
import cn.iflow.sdk.types.messages.ToolCallMessage;
import cn.iflow.sdk.types.messages.ToolResultMessage;
import cn.iflow.sdk.types.messages.UserMessage;
import cn.iflow.sdk.types.protocol.AgentInfo;
import cn.iflow.sdk.types.protocol.requests.FileReadParams;
import cn.iflow.sdk.types.protocol.requests.FileWriteParams;
import cn.iflow.sdk.types.protocol.requests.PermissionOption;
import cn.iflow.sdk.types.protocol.requests.PermissionRequestParams;
import cn.iflow.sdk.types.protocol.responses.FileReadResult;
import cn.iflow.sdk.types.protocol.responses.FileWriteResult;
import cn.iflow.sdk.types.protocol.responses.PermissionRequestResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class IFlowClientImpl
implements IFlowClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IFlowClientImpl.class);
    private final IFlowOptions options;
    private WebSocketTransport transport;
    private ACPProtocol protocol;
    private FileSystemHandler fileHandler;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private String sessionId;
    private IFlowProcessManager processManager;
    private final AtomicBoolean processStarted = new AtomicBoolean(false);
    private final Sinks.Many<Message> messageSink = Sinks.many().multicast().onBackpressureBuffer();
    private final Flux<Message> messageFlux = this.messageSink.asFlux().share();

    public IFlowClientImpl(IFlowOptions options) {
        this.options = options != null ? options : IFlowOptions.getDefault();
    }

    @Override
    public Mono<Void> connect() {
        if (this.connected.get()) {
            log.warn("Already connected");
            return Mono.empty();
        }
        return Mono.defer(() -> {
            if (this.options.isAutoStartProcess()) {
                String newUrl = this.handleAutoStartProcess();
                this.options.setUrl(newUrl);
            }
            if (this.options.isFileAccess()) {
                this.fileHandler = new FileSystemHandler(this.options.getFileAllowedDirs(), this.options.isFileReadOnly(), this.options.getFileMaxSize());
                log.info("File system access enabled with {} mode", (Object)(this.options.isFileReadOnly() ? "read-only" : "read-write"));
            }
            this.transport = new WebSocketTransport(this.options);
            this.protocol = new ACPProtocol(this.transport, this::handlePermissionRequest, this::handleFileRead, this::handleFileWrite);
            List<McpServerConfig> mcpServers = this.options.getMcpServers();
            Map<HookEventType, List<HookEventConfig>> hooks = this.options.getHooks();
            List<CommandConfig> commands = this.options.getCommands();
            List<CreateAgentConfig> agents = this.options.getAgents();
            return this.protocol.initialize(mcpServers, hooks, commands, agents).flatMap(initResult -> this.protocol.authenticate(this.options.getAuthMethodId(), this.options.getAuthMethodInfo())).then(this.protocol.createSession(this.options.getCwd(), mcpServers, hooks, commands, agents, this.options.getSessionSettings())).doOnSuccess(createdSessionId -> {
                this.sessionId = createdSessionId;
                log.info("Created session: {}", (Object)this.sessionId);
                this.connected.set(true);
                log.info("Connected to iFlow");
                this.startMessageHandling();
            }).then().onErrorMap(throwable -> {
                this.cleanup();
                return new ConnectionException("Failed to connect: " + throwable.getMessage(), (Throwable)throwable);
            });
        });
    }

    private String handleAutoStartProcess() {
        String url = this.options.getUrl();
        if (url.startsWith("ws://localhost:") || url.startsWith("ws://127.0.0.1:")) {
            try {
                this.processManager = new IFlowProcessManager(this.options);
                Integer port = this.processManager.ensureProcessRunning().join();
                if (port != null) {
                    String baseUrl = url.substring(0, url.lastIndexOf(":"));
                    String newUrl = baseUrl + ":" + port + "/acp";
                    log.info("iFlow process running on port {}, using URL: {}", (Object)port, (Object)newUrl);
                    this.processStarted.set(true);
                    return newUrl;
                }
                log.warn("Failed to start or detect iFlow process");
            }
            catch (ProcessException e) {
                log.warn("Failed to manage iFlow process", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.warn("Unexpected error in process management", (Throwable)e);
                throw e;
            }
        }
        return url;
    }

    @Override
    public Mono<Void> loadSession(String sessionId) {
        if (!this.connected.get() || this.protocol == null) {
            return Mono.error((Throwable)new ConnectionException("Not connected. Call connect() first."));
        }
        return this.protocol.loadSession(sessionId, this.options.getCwd(), this.options.getMcpServers()).doOnSuccess(result -> {
            this.sessionId = sessionId;
            log.info("Loaded session: " + sessionId);
        }).onErrorMap(throwable -> {
            ProtocolException pe;
            if (throwable.getCause() instanceof ProtocolException && (pe = (ProtocolException)throwable.getCause()).getMessage().contains("not supported")) {
                log.warn("session/load is not supported by current iFlow version.");
            }
            return throwable;
        }).then();
    }

    @Override
    public Mono<Void> disconnect() {
        return Mono.fromRunnable(this::cleanup);
    }

    private void cleanup() {
        this.connected.set(false);
        this.messageSink.tryEmitComplete();
        if (this.transport != null) {
            try {
                this.transport.close();
            }
            catch (Exception e) {
                log.warn("Error closing transport: " + e.getMessage());
            }
        }
        if (this.processStarted.get() && this.processManager != null) {
            log.info("Stopping iFlow process...");
            try {
                this.processManager.stopProcess().join();
                log.info("iFlow process stopped successfully");
            }
            catch (Exception e) {
                log.warn("Error stopping iFlow process: " + e.getMessage());
            }
            this.processManager = null;
            this.processStarted.set(false);
        }
        this.transport = null;
        this.protocol = null;
        log.info("Disconnected from iFlow");
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public Mono<Void> sendMessage(String text) {
        return this.sendMessage(text, null);
    }

    @Override
    public Mono<Void> sendMessage(String text, List<Path> files) {
        return Mono.defer(() -> {
            if (!this.connected.get() || this.protocol == null || this.sessionId == null) {
                return Mono.error((Throwable)new ConnectionException("Not connected. Call connect() first."));
            }
            return Mono.empty();
        }).then(Mono.fromCallable(() -> {
            ArrayList<Content> prompt = new ArrayList<Content>();
            prompt.add(new TextContent(text));
            if (files != null) {
                for (Path file : files) {
                    this.addFileToPrompt(prompt, file);
                }
            }
            return prompt;
        }).flatMap(prompt -> {
            log.debug("Sent prompt with {} content blocks", (Object)prompt.size());
            return this.protocol.sendPrompt(this.sessionId, (List<Content>)prompt);
        }).then().onErrorMap(throwable -> new ProtocolException("Failed to send message: " + throwable.getMessage(), (Throwable)throwable)));
    }

    private void addFileToPrompt(List<Content> prompt, Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            log.warn("File not found, skipping: " + file);
            return;
        }
        String fileName = file.getFileName().toString();
        String suffix = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
        try {
            if (this.isImageFile(suffix)) {
                byte[] imageData = Files.readAllBytes(file);
                String base64Data = Base64.getEncoder().encodeToString(imageData);
                String mimeType = this.getImageMimeType(suffix);
                ImageContent imageContent = new ImageContent(base64Data, mimeType);
                prompt.add(imageContent);
                log.debug("Added image file: " + fileName);
            } else if (this.isAudioFile(suffix)) {
                byte[] audioData = Files.readAllBytes(file);
                String base64Data = Base64.getEncoder().encodeToString(audioData);
                String mimeType = this.getAudioMimeType(suffix);
                AudioContent audioContent = new AudioContent(base64Data, mimeType);
                prompt.add(audioContent);
                log.debug("Added audio file: {}", (Object)fileName);
            } else {
                String title = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
                ResourceLinkContent resourceContent = new ResourceLinkContent(fileName, file.toAbsolutePath().toUri().toString(), "application/octet-stream", Files.size(file), title, "File: " + fileName);
                prompt.add(resourceContent);
                log.debug("Added resource link: " + fileName);
            }
        }
        catch (IOException e) {
            log.error("Failed to read file {}: {}", (Object)file, (Object)e.getMessage());
        }
    }

    private boolean isImageFile(String suffix) {
        return Arrays.asList("png", "jpg", "jpeg", "gif", "bmp", "webp", "svg").contains(suffix);
    }

    private boolean isAudioFile(String suffix) {
        return Arrays.asList("mp3", "wav", "m4a", "ogg", "flac").contains(suffix);
    }

    private String getImageMimeType(String suffix) {
        switch (suffix) {
            case "png": {
                return "image/png";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "gif": {
                return "image/gif";
            }
            case "bmp": {
                return "image/bmp";
            }
            case "webp": {
                return "image/webp";
            }
            case "svg": {
                return "image/svg+xml";
            }
        }
        return "image/unknown";
    }

    private String getAudioMimeType(String suffix) {
        switch (suffix) {
            case "mp3": {
                return "audio/mpeg";
            }
            case "wav": {
                return "audio/wav";
            }
            case "m4a": {
                return "audio/mp4";
            }
            case "ogg": {
                return "audio/ogg";
            }
            case "flac": {
                return "audio/flac";
            }
        }
        return "audio/unknown";
    }

    @Override
    public Mono<Void> interrupt() {
        if (!this.connected.get() || this.protocol == null || this.sessionId == null) {
            return Mono.error((Throwable)new ConnectionException("Not connected"));
        }
        return this.protocol.cancelSession(this.sessionId).doOnSuccess(result -> log.info("Sent interrupt signal")).then();
    }

    @Override
    public Flux<Message> receiveMessages() {
        return Flux.defer(() -> {
            if (!this.connected.get()) {
                return Flux.error((Throwable)new ConnectionException("Not connected"));
            }
            return this.messageFlux;
        });
    }

    @Override
    public IFlowOptions getOptions() {
        return this.options;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void close() {
        try {
            this.disconnect().block();
        }
        catch (Exception e) {
            log.warn("Error during close: " + e.getMessage());
        }
    }

    private void startMessageHandling() {
        if (this.protocol == null) {
            return;
        }
        this.protocol.receiveMessages().mapNotNull(this::processMessageData).filter(Objects::nonNull).doOnNext(arg_0 -> this.messageSink.tryEmitNext(arg_0)).doOnError(error -> {
            log.error("Error in message handler: {}", (Object)error.getMessage());
            ErrorMessage errorMsg = new ErrorMessage("-1", error.getMessage(), null, null, System.currentTimeMillis());
            this.messageSink.tryEmitNext((Object)errorMsg);
        }).doOnComplete(() -> this.messageSink.tryEmitComplete()).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }

    private Message processMessageData(Map<String, Object> data) {
        String msgType;
        switch (msgType = (String)data.get("type")) {
            case "session_update": {
                return this.handleSessionUpdateMsg(data);
            }
            case "response": {
                return this.handleResponseMsg(data);
            }
            case "permission_request": {
                return this.handlePermissionRequestMsg(data);
            }
            case "error": {
                return new ErrorMessage((String)data.getOrDefault("code", "-1"), (String)data.getOrDefault("message", "Unknown error"), (String)data.get("data"), null, System.currentTimeMillis());
            }
        }
        return null;
    }

    private Message handlePermissionRequestMsg(Map<String, Object> data) {
        return PermissionRequestMessage.builder().agentId((String)data.get("agentId")).permissionRequestParams((PermissionRequestParams)data.get("params")).build();
    }

    private Message handleSessionUpdateMsg(Map<String, Object> data) {
        Map<String, Object> update;
        String updateType = (String)data.get("update_type");
        Object updateObj = data.get("update");
        if (updateObj instanceof Map) {
            Map<String, Object> tempUpdate;
            update = tempUpdate = (Map<String, Object>)updateObj;
        } else {
            log.warn("Update field is not a Map: {}", (Object)(updateObj != null ? updateObj.getClass().getName() : "null"));
            update = Collections.emptyMap();
        }
        String agentId = (String)data.get("agentId");
        switch (updateType) {
            case "agent_message_chunk": {
                return this.handleAgentMessageChunk(update, agentId);
            }
            case "agent_thought_chunk": {
                return this.handleAgentThoughtChunk(update, agentId);
            }
            case "tool_call": {
                return this.handleToolCall(update, agentId);
            }
            case "tool_call_update": {
                return this.handleToolCallUpdate(update, agentId);
            }
            case "plan": {
                return this.handlePlanUpdate(update, agentId);
            }
            case "user_message_chunk": {
                return this.handleUserMessageChunk(update, agentId);
            }
        }
        log.warn("Unknown session update type: {}", (Object)updateType);
        return null;
    }

    private Message handleAgentMessageChunk(Map<String, Object> update, String agentId) {
        String text;
        Object contentObj = update.get("content");
        if (!(contentObj instanceof Map)) {
            log.warn("Content is not a Map in agent message chunk: {}", (Object)(contentObj != null ? contentObj.getClass().getName() : "null"));
            return null;
        }
        Map content = (Map)contentObj;
        if ("text".equals(content.get("type")) && (text = (String)content.get("text")) != null && !text.isEmpty()) {
            AssistantMessage.AssistantMessageChunk chunk = new AssistantMessage.AssistantMessageChunk(text, null);
            return new AssistantMessage(chunk, agentId, System.currentTimeMillis());
        }
        return null;
    }

    private Message handleAgentThoughtChunk(Map<String, Object> update, String agentId) {
        String thought;
        Object contentObj = update.get("content");
        if (!(contentObj instanceof Map)) {
            log.warn("Content is not a Map in agent thought chunk: {}", (Object)(contentObj != null ? contentObj.getClass().getName() : "null"));
            return null;
        }
        Map content = (Map)contentObj;
        if ("text".equals(content.get("type")) && (thought = (String)content.get("text")) != null && !thought.isEmpty()) {
            AssistantMessage.AssistantMessageChunk chunk = new AssistantMessage.AssistantMessageChunk("", thought);
            return new AssistantMessage(chunk, agentId, System.currentTimeMillis());
        }
        return null;
    }

    private Message handleToolCall(Map<String, Object> update, String agentId) {
        String toolCallId = (String)update.getOrDefault("toolCallId", "");
        String title = (String)update.getOrDefault("title", "Tool");
        String status = (String)update.getOrDefault("status", "in_progress");
        String toolName = (String)update.get("toolName");
        Map args = update.getOrDefault("args", new HashMap());
        List<ToolCallContent> contentList = this.parseToolCallContent(update);
        return new ToolCallMessage(toolCallId, title, toolName, contentList, ToolCallStatus.valueOf(status.toUpperCase().replace("-", "_")), args, agentId, System.currentTimeMillis() / 1000L);
    }

    private List<ToolCallContent> parseToolCallContent(Map<String, Object> update) {
        ArrayList<ToolCallContent> contentList = new ArrayList<ToolCallContent>();
        Object contentObj = update.get("content");
        if (contentObj == null) {
            return contentList;
        }
        if (!(contentObj instanceof List)) {
            log.warn("Unexpected content type: {}, expected List", (Object)contentObj.getClass().getName());
            return contentList;
        }
        List contentMaps = (List)contentObj;
        if (contentMaps.isEmpty()) {
            return contentList;
        }
        for (Object item : contentMaps) {
            if (!(item instanceof Map)) {
                log.warn("Skipping non-Map element in content list: {}", (Object)(item != null ? item.getClass().getName() : "null"));
                continue;
            }
            Map contentMap = (Map)item;
            ToolCallContent content = this.createToolCallContent(contentMap);
            if (content == null) continue;
            contentList.add(content);
        }
        return contentList;
    }

    private ToolCallContent createToolCallContent(Map<String, Object> contentMap) {
        String type = (String)contentMap.get("type");
        if ("content".equals(type)) {
            MarkdownToolCallContent content = new MarkdownToolCallContent();
            Object nestedContent = contentMap.get("content");
            if (nestedContent instanceof Map) {
                Map map = (Map)nestedContent;
            }
            return content;
        }
        if ("diff".equals(type)) {
            DiffToolCallContent diffContent = new DiffToolCallContent();
            diffContent.setNewText((String)contentMap.get("newText"));
            diffContent.setOldText((String)contentMap.get("oldText"));
            diffContent.setPath((String)contentMap.get("path"));
            return diffContent;
        }
        return null;
    }

    private Message handleToolCallUpdate(Map<String, Object> update, String agentId) {
        List contentList;
        String toolId = (String)update.get("toolCallId");
        String toolName = (String)update.get("toolName");
        String statusStr = (String)update.get("status");
        ToolCallStatus status = statusStr != null ? ToolCallStatus.valueOf(statusStr.toUpperCase()) : ToolCallStatus.COMPLETED;
        AgentInfo agentInfo = null;
        if (agentId != null) {
            agentInfo = AgentInfo.parse(agentId).orElse(null);
        }
        ToolCallContent content = null;
        Map args = null;
        Object contentObj = update.get("content");
        if (contentObj instanceof List && !(contentList = (List)contentObj).isEmpty()) {
            Object argsObj;
            Object firstElement = contentList.get(0);
            if (!(firstElement instanceof Map)) {
                log.warn("First element in content list is not a Map: {}", (Object)(firstElement != null ? firstElement.getClass().getName() : "null"));
                return new ToolResultMessage(toolId, status, toolName, null, null, null, agentId, agentInfo, null, System.currentTimeMillis() / 1000L);
            }
            Map contentData = (Map)firstElement;
            String contentType = contentData.getOrDefault("type", "markdown");
            if (!"markdown".equals(contentType) && !"diff".equals(contentType)) {
                contentType = "markdown";
            }
            if ((argsObj = contentData.get("args")) instanceof Map) {
                args = (Map)argsObj;
            }
            if ("markdown".equals(contentType)) {
                HashMap textDataObj = contentData.getOrDefault("content", new HashMap());
                if (textDataObj instanceof Map) {
                    Map textData = textDataObj;
                    String markdownText = textData.getOrDefault("text", "");
                    content = new MarkdownToolCallContent(markdownText);
                }
            } else {
                DiffToolCallContent diffContent = new DiffToolCallContent();
                diffContent.setType(contentType);
                diffContent.setPath((String)contentData.get("path"));
                diffContent.setOldText((String)contentData.get("oldText"));
                diffContent.setNewText((String)contentData.get("newText"));
                diffContent.setFileDiff((String)contentData.get("fileDiff"));
                String markdownText = contentData.getOrDefault("content", "");
                diffContent.setMarkdown(markdownText);
                content = diffContent;
            }
        }
        return new ToolResultMessage(toolId, status, toolName, content, null, null, agentId, agentInfo, args, System.currentTimeMillis() / 1000L);
    }

    private Message handlePlanUpdate(Map<String, Object> update, String agentId) {
        List entriesData;
        Object entriesObj = update.get("entries");
        if (entriesObj instanceof List && !(entriesData = (List)entriesObj).isEmpty()) {
            ArrayList<PlanMessage.PlanEntry> entries = new ArrayList<PlanMessage.PlanEntry>();
            for (Object item : entriesData) {
                if (!(item instanceof Map)) {
                    log.warn("Skipping non-Map element in entries list: {}", (Object)(item != null ? item.getClass().getName() : "null"));
                    continue;
                }
                Map entryData = (Map)item;
                String id = UUID.randomUUID().toString();
                String content = entryData.getOrDefault("content", "");
                String status = entryData.getOrDefault("status", "pending");
                String priority = entryData.getOrDefault("priority", "medium");
                entries.add(new PlanMessage.PlanEntry(id, content, status, priority));
            }
            return new PlanMessage(entries, agentId, System.currentTimeMillis());
        }
        return null;
    }

    private Message handleUserMessageChunk(Map<String, Object> update, String agentId) {
        String text;
        Object contentObj = update.get("content");
        if (!(contentObj instanceof Map)) {
            log.warn("Content is not a Map in user message chunk: {}", (Object)(contentObj != null ? contentObj.getClass().getName() : "null"));
            return null;
        }
        Map content = (Map)contentObj;
        if ("text".equals(content.get("type")) && (text = (String)content.get("text")) != null && !text.isEmpty()) {
            UserMessage.UserMessageChunk chunk = new UserMessage.UserMessageChunk(text);
            return new UserMessage(chunk, agentId, System.currentTimeMillis());
        }
        return null;
    }

    private Message handleResponseMsg(Map<String, Object> data) {
        Map result;
        Object resultObj = data.get("result");
        if (resultObj instanceof Map && (result = (Map)resultObj).containsKey("stopReason")) {
            String reasonStr = (String)result.get("stopReason");
            StopReason stopReason = this.mapStopReason(reasonStr);
            return new TaskFinishMessage(stopReason, null, System.currentTimeMillis());
        }
        return null;
    }

    private StopReason mapStopReason(String reasonStr) {
        if (reasonStr == null) {
            return StopReason.END_TURN;
        }
        switch (reasonStr) {
            case "end_turn": {
                return StopReason.END_TURN;
            }
            case "max_tokens": {
                return StopReason.MAX_TOKENS;
            }
            case "refusal": {
                return StopReason.REFUSAL;
            }
            case "cancelled": {
                return StopReason.CANCELLED;
            }
        }
        return StopReason.END_TURN;
    }

    private Mono<PermissionRequestResult> handlePermissionRequest(PermissionRequestParams params) {
        return Mono.defer(() -> {
            boolean autoApprove;
            switch (this.options.getPermissionMode()) {
                case AUTO: {
                    autoApprove = true;
                    break;
                }
                case MANUAL: {
                    autoApprove = false;
                    break;
                }
                default: {
                    String toolType = params.getToolCall() != null ? params.getToolCall().getKind() : "";
                    autoApprove = "read".equals(toolType) || "fetch".equals(toolType) || "list".equals(toolType);
                }
            }
            PermissionRequestResult.Outcome outcome = new PermissionRequestResult.Outcome();
            if (autoApprove) {
                String selectedOption = "allow_once";
                if (params.getOptions() != null) {
                    for (PermissionOption option : params.getOptions()) {
                        if ("allow_once".equals(option.getKind())) {
                            selectedOption = option.getOptionId();
                            break;
                        }
                        if (!"allow_always".equals(option.getKind())) continue;
                        selectedOption = option.getOptionId();
                    }
                }
                outcome.setOutcome("selected");
                outcome.setOptionId(selectedOption);
            } else {
                Function<PermissionRequestParams, Mono<PermissionRequestResult>> permissionCallback = this.options.getPermissionCallback();
                if (permissionCallback != null) {
                    return Mono.defer(() -> (Mono)permissionCallback.apply(params));
                }
                outcome.setOutcome("cancelled");
            }
            return Mono.just(((PermissionRequestResult.PermissionRequestResultBuilder)PermissionRequestResult.builder().outcome(outcome)).build());
        });
    }

    private Mono<FileReadResult> handleFileRead(FileReadParams params) {
        return Mono.fromCallable(() -> {
            if (this.fileHandler == null) {
                throw new RuntimeException("File system access not configured");
            }
            String content = this.fileHandler.readFile(params.getPath(), params.getLine(), params.getLimit());
            return ((FileReadResult.FileReadResultBuilder)FileReadResult.builder().content(content)).build();
        });
    }

    private Mono<FileWriteResult> handleFileWrite(FileWriteParams params) {
        return Mono.fromCallable(() -> {
            if (this.fileHandler == null) {
                throw new RuntimeException("File system access not configured");
            }
            this.fileHandler.writeFile(params.getPath(), params.getContent());
            return ((FileWriteResult.FileWriteResultBuilder)FileWriteResult.builder().success(true)).build();
        });
    }
}

