/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.jwt.JWTException;
import cn.hutool.jwt.JWTHeader;
import cn.hutool.jwt.JWTPayload;
import cn.hutool.jwt.JWTValidator;
import cn.hutool.jwt.RegisteredPayload;
import cn.hutool.jwt.signers.AlgorithmUtil;
import cn.hutool.jwt.signers.JWTSigner;
import cn.hutool.jwt.signers.JWTSignerUtil;
import cn.hutool.jwt.signers.NoneJWTSigner;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JWT
implements RegisteredPayload<JWT> {
    private final JWTHeader header = new JWTHeader();
    private final JWTPayload payload = new JWTPayload();
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private JWTSigner signer;
    private List<String> tokens;

    public static JWT create() {
        return new JWT();
    }

    public static JWT of(String token) {
        return new JWT(token);
    }

    public JWT() {
    }

    public JWT(String token) {
        this();
        this.parse(token);
    }

    public JWT parse(String token) {
        Assert.notBlank((CharSequence)token, (String)"Token String must be not blank!", (Object[])new Object[0]);
        List<String> tokens = JWT.splitToken(token);
        this.tokens = tokens;
        this.header.parse(tokens.get(0), this.charset);
        this.payload.parse(tokens.get(1), this.charset);
        return this;
    }

    public JWT setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public JWT setKey(byte[] key) {
        return this.setSigner(StrUtil.nullToDefault((CharSequence)this.getAlgorithm(), (String)"HS256"), key);
    }

    public JWT setSigner(String algorithmId, byte[] key) {
        return this.setSigner(JWTSignerUtil.createSigner(algorithmId, key));
    }

    public JWT setSigner(String algorithmId, Key key) {
        return this.setSigner(JWTSignerUtil.createSigner(algorithmId, key));
    }

    public JWT setSigner(String algorithmId, KeyPair keyPair) {
        return this.setSigner(JWTSignerUtil.createSigner(algorithmId, keyPair));
    }

    public JWT setSigner(JWTSigner signer) {
        this.signer = signer;
        String algorithm = (String)this.header.getClaim(JWTHeader.ALGORITHM);
        if (StrUtil.isBlank((CharSequence)algorithm)) {
            this.header.setAlgorithm(AlgorithmUtil.getId(signer.getAlgorithm()));
        }
        return this;
    }

    public JWTSigner getSigner() {
        return this.signer;
    }

    public JSONObject getHeaders() {
        return this.header.getClaimsJson();
    }

    public JWTHeader getHeader() {
        return this.header;
    }

    public Object getHeader(String name) {
        return this.header.getClaim(name);
    }

    public String getAlgorithm() {
        return (String)this.header.getClaim(JWTHeader.ALGORITHM);
    }

    public JWT setHeader(String name, Object value) {
        this.header.setClaim(name, value);
        return this;
    }

    public JWT addHeaders(Map<String, ?> headers) {
        this.header.addHeaders(headers);
        return this;
    }

    public JSONObject getPayloads() {
        return this.payload.getClaimsJson();
    }

    public JWTPayload getPayload() {
        return this.payload;
    }

    public Object getPayload(String name) {
        return this.getPayload().getClaim(name);
    }

    @Override
    public JWT setPayload(String name, Object value) {
        this.payload.setClaim(name, value);
        return this;
    }

    public JWT addPayloads(Map<String, ?> payloads) {
        this.payload.addPayloads(payloads);
        return this;
    }

    public String sign() {
        return this.sign(true);
    }

    public String sign(boolean addTypeIfNot) {
        return this.sign(this.signer, addTypeIfNot);
    }

    public String sign(JWTSigner signer) {
        return this.sign(signer, true);
    }

    public String sign(JWTSigner signer, boolean addTypeIfNot) {
        String algorithm;
        String type;
        Assert.notNull((Object)signer, () -> new JWTException("No Signer provided!"));
        if (addTypeIfNot && StrUtil.isBlank((CharSequence)(type = (String)this.header.getClaim(JWTHeader.TYPE)))) {
            this.header.setClaim(JWTHeader.TYPE, "JWT");
        }
        if (StrUtil.isBlank((CharSequence)(algorithm = this.getAlgorithm()))) {
            this.header.setClaim(JWTHeader.ALGORITHM, AlgorithmUtil.getId(signer.getAlgorithm()));
        }
        String headerBase64 = Base64.encodeUrlSafe((CharSequence)this.header.toString(), (Charset)this.charset);
        String payloadBase64 = Base64.encodeUrlSafe((CharSequence)this.payload.toString(), (Charset)this.charset);
        String sign = signer.sign(headerBase64, payloadBase64);
        return StrUtil.format((CharSequence)"{}.{}.{}", (Object[])new Object[]{headerBase64, payloadBase64, sign});
    }

    public boolean verify() {
        return this.verify(this.signer);
    }

    public boolean validate(long leeway) {
        if (!this.verify()) {
            return false;
        }
        try {
            JWTValidator.of(this).validateDate((Date)DateUtil.date(), leeway);
        }
        catch (ValidateException e) {
            return false;
        }
        return true;
    }

    public boolean verify(JWTSigner signer) {
        if (null == signer) {
            signer = NoneJWTSigner.NONE;
        }
        if (NoneJWTSigner.isNone(this.getAlgorithm()) && !(signer instanceof NoneJWTSigner)) {
            throw new JWTException("Alg is 'none' but use: {} !", signer.getClass());
        }
        if (signer instanceof NoneJWTSigner && !NoneJWTSigner.isNone(this.getAlgorithm())) {
            throw new JWTException("Alg is not 'none' but use NoneJWTSigner!");
        }
        List<String> tokens = this.tokens;
        if (CollUtil.isEmpty(tokens)) {
            throw new JWTException("No token to verify!");
        }
        return signer.verify(tokens.get(0), tokens.get(1), tokens.get(2));
    }

    private static List<String> splitToken(String token) {
        List tokens = StrUtil.split((CharSequence)token, (char)'.');
        if (3 != tokens.size()) {
            throw new JWTException("The token was expected 3 parts, but got {}.", tokens.size());
        }
        return tokens;
    }
}

