/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.webservice;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.webservice.SoapClient;
import cn.hutool.http.webservice.SoapProtocol;
import cn.hutool.http.webservice.SoapRuntimeException;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class JakartaSoapUtil {
    public static SoapClient createClient(String url) {
        return SoapClient.create(url);
    }

    public static SoapClient createClient(String url, SoapProtocol protocol) {
        return SoapClient.create(url, protocol);
    }

    public static SoapClient createClient(String url, SoapProtocol protocol, String namespaceURI) {
        return SoapClient.create(url, protocol, namespaceURI);
    }

    public static String toString(SOAPMessage message, boolean pretty) {
        return JakartaSoapUtil.toString(message, pretty, CharsetUtil.CHARSET_UTF_8);
    }

    public static String toString(SOAPMessage message, boolean pretty, Charset charset) {
        String messageToString;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)out);
        }
        catch (SOAPException | IOException e) {
            throw new SoapRuntimeException(e);
        }
        try {
            messageToString = out.toString(charset.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException((Throwable)e);
        }
        return pretty ? XmlUtil.format((String)messageToString) : messageToString;
    }
}

