/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.webservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.webservice.JakartaSoapUtil;
import cn.hutool.http.webservice.SoapProtocol;
import cn.hutool.http.webservice.SoapRuntimeException;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBodyElement;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class JakartaSoapClient
extends HttpBase<JakartaSoapClient> {
    private static final String CONTENT_TYPE_SOAP11_TEXT_XML = "text/xml;charset=";
    private static final String CONTENT_TYPE_SOAP12_SOAP_XML = "application/soap+xml;charset=";
    private String url;
    private int connectionTimeout = HttpGlobalConfig.getTimeout();
    private int readTimeout = HttpGlobalConfig.getTimeout();
    private MessageFactory factory;
    private SOAPMessage message;
    private SOAPBodyElement methodEle;
    private final String namespaceURI;
    private final SoapProtocol protocol;

    public static JakartaSoapClient create(String url) {
        return new JakartaSoapClient(url);
    }

    public static JakartaSoapClient create(String url, SoapProtocol protocol) {
        return new JakartaSoapClient(url, protocol);
    }

    public static JakartaSoapClient create(String url, SoapProtocol protocol, String namespaceURI) {
        return new JakartaSoapClient(url, protocol, namespaceURI);
    }

    public JakartaSoapClient(String url) {
        this(url, SoapProtocol.SOAP_1_1);
    }

    public JakartaSoapClient(String url, SoapProtocol protocol) {
        this(url, protocol, null);
    }

    public JakartaSoapClient(String url, SoapProtocol protocol, String namespaceURI) {
        this.url = url;
        this.namespaceURI = namespaceURI;
        this.protocol = protocol;
        this.init(protocol);
    }

    public JakartaSoapClient init(SoapProtocol protocol) {
        try {
            this.factory = MessageFactory.newInstance((String)protocol.getValue());
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return this;
    }

    public JakartaSoapClient reset() {
        try {
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        this.methodEle = null;
        return this;
    }

    public JakartaSoapClient setCharset(Charset charset) {
        return this.charset(charset);
    }

    @Override
    public JakartaSoapClient charset(Charset charset) {
        super.charset(charset);
        try {
            this.message.setProperty("jakarta.xml.soap.character-set-encoding", (Object)this.charset());
            this.message.setProperty("jakarta.xml.soap.write-xml-declaration", (Object)"true");
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return this;
    }

    public JakartaSoapClient setUrl(String url) {
        this.url = url;
        return this;
    }

    public SOAPHeaderElement addSOAPHeader(QName name, String actorURI, String roleUri, Boolean mustUnderstand, Boolean relay) {
        SOAPHeaderElement ele = this.addSOAPHeader(name);
        try {
            if (StrUtil.isNotBlank((CharSequence)roleUri)) {
                ele.setRole(roleUri);
            }
            if (null != relay) {
                ele.setRelay(relay.booleanValue());
            }
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        if (StrUtil.isNotBlank((CharSequence)actorURI)) {
            ele.setActor(actorURI);
        }
        if (null != mustUnderstand) {
            ele.setMustUnderstand(mustUnderstand.booleanValue());
        }
        return ele;
    }

    public SOAPHeaderElement addSOAPHeader(String localName) {
        return this.addSOAPHeader(new QName(localName));
    }

    public SOAPHeaderElement addSOAPHeader(String localName, String value) {
        SOAPHeaderElement soapHeaderElement = this.addSOAPHeader(localName);
        soapHeaderElement.setTextContent(value);
        return soapHeaderElement;
    }

    public SOAPHeaderElement addSOAPHeader(QName name) {
        SOAPHeaderElement ele;
        try {
            ele = this.message.getSOAPHeader().addHeaderElement(name);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return ele;
    }

    public JakartaSoapClient setMethod(Name name, Map<String, Object> params, boolean useMethodPrefix) {
        return this.setMethod(new QName(name.getURI(), name.getLocalName(), name.getPrefix()), params, useMethodPrefix);
    }

    public JakartaSoapClient setMethod(QName name, Map<String, Object> params, boolean useMethodPrefix) {
        this.setMethod(name);
        String prefix = useMethodPrefix ? name.getPrefix() : null;
        SOAPBodyElement methodEle = this.methodEle;
        for (Map.Entry entry : MapUtil.wrap(params)) {
            JakartaSoapClient.setParam((SOAPElement)methodEle, (String)entry.getKey(), entry.getValue(), prefix);
        }
        return this;
    }

    public JakartaSoapClient setMethod(String methodName) {
        return this.setMethod(methodName, (String)ObjectUtil.defaultIfNull((Object)this.namespaceURI, (Object)""));
    }

    public JakartaSoapClient setMethod(String methodName, String namespaceURI) {
        List methodNameList = StrUtil.split((CharSequence)methodName, (char)':');
        QName qName = 2 == methodNameList.size() ? new QName(namespaceURI, (String)methodNameList.get(1), (String)methodNameList.get(0)) : new QName(namespaceURI, methodName);
        return this.setMethod(qName);
    }

    public JakartaSoapClient setMethod(QName name) {
        try {
            this.methodEle = this.message.getSOAPBody().addBodyElement(name);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return this;
    }

    public JakartaSoapClient setParam(String name, Object value) {
        return this.setParam(name, value, true);
    }

    public JakartaSoapClient setParam(String name, Object value, boolean useMethodPrefix) {
        JakartaSoapClient.setParam((SOAPElement)this.methodEle, name, value, useMethodPrefix ? this.methodEle.getPrefix() : null);
        return this;
    }

    public JakartaSoapClient setParams(Map<String, Object> params) {
        return this.setParams(params, true);
    }

    public JakartaSoapClient setParams(Map<String, Object> params, boolean useMethodPrefix) {
        for (Map.Entry entry : MapUtil.wrap(params)) {
            this.setParam((String)entry.getKey(), entry.getValue(), useMethodPrefix);
        }
        return this;
    }

    public SOAPBodyElement getMethodEle() {
        return this.methodEle;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    public String getMsgStr(boolean pretty) {
        return JakartaSoapUtil.toString(this.message, pretty, this.charset);
    }

    public JakartaSoapClient write(OutputStream out) {
        try {
            this.message.writeTo(out);
        }
        catch (SOAPException | IOException e) {
            throw new SoapRuntimeException(e);
        }
        return this;
    }

    public JakartaSoapClient timeout(int milliseconds) {
        this.setConnectionTimeout(milliseconds);
        this.setReadTimeout(milliseconds);
        return this;
    }

    public JakartaSoapClient setConnectionTimeout(int milliseconds) {
        this.connectionTimeout = milliseconds;
        return this;
    }

    public JakartaSoapClient setReadTimeout(int milliseconds) {
        this.readTimeout = milliseconds;
        return this;
    }

    public SOAPMessage sendForMessage() {
        HttpResponse res = this.sendForResponse();
        MimeHeaders headers = new MimeHeaders();
        for (Map.Entry<String, List<String>> entry : res.headers().entrySet()) {
            if (!StrUtil.isNotEmpty((CharSequence)entry.getKey())) continue;
            headers.setHeader(entry.getKey(), (String)CollUtil.get((Collection)entry.getValue(), (int)0));
        }
        try {
            SOAPMessage sOAPMessage = this.factory.createMessage(headers, res.bodyStream());
            return sOAPMessage;
        }
        catch (SOAPException | IOException e) {
            throw new SoapRuntimeException(e);
        }
        finally {
            IoUtil.close((Closeable)res);
        }
    }

    public String send() {
        return this.send(false);
    }

    public String send(boolean pretty) {
        String body = this.sendForResponse().body();
        return pretty ? XmlUtil.format((String)body) : body;
    }

    public HttpResponse sendForResponse() {
        return ((HttpRequest)HttpRequest.post(this.url).setFollowRedirects(true).setConnectionTimeout(this.connectionTimeout).setReadTimeout(this.readTimeout).contentType(this.getXmlContentType()).header(this.headers())).body(this.getMsgStr(false)).executeAsync();
    }

    private String getXmlContentType() {
        switch (this.protocol) {
            case SOAP_1_1: {
                return CONTENT_TYPE_SOAP11_TEXT_XML.concat(this.charset.toString());
            }
            case SOAP_1_2: {
                return CONTENT_TYPE_SOAP12_SOAP_XML.concat(this.charset.toString());
            }
        }
        throw new SoapRuntimeException("Unsupported protocol: {}", new Object[]{this.protocol});
    }

    private static SOAPElement setParam(SOAPElement ele, String name, Object value, String prefix) {
        SOAPElement childEle;
        try {
            childEle = StrUtil.isNotBlank((CharSequence)prefix) ? ele.addChildElement(name, prefix) : ele.addChildElement(name);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        if (null != value) {
            if (value instanceof SOAPElement) {
                try {
                    ele.addChildElement((SOAPElement)value);
                }
                catch (SOAPException e) {
                    throw new SoapRuntimeException(e);
                }
            } else if (value instanceof Map) {
                Iterator iterator = ((Map)value).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry obj;
                    Map.Entry entry = obj = iterator.next();
                    JakartaSoapClient.setParam(childEle, entry.getKey().toString(), entry.getValue(), prefix);
                }
            } else {
                childEle.setValue(value.toString());
            }
        }
        return childEle;
    }
}

