/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.pinyin.engine.jpinyin;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.extra.pinyin.PinyinEngine;
import cn.hutool.extra.pinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;

public class JPinyinEngine
implements PinyinEngine {
    PinyinFormat format;

    public JPinyinEngine() {
        this(null);
    }

    public JPinyinEngine(PinyinFormat format) {
        this.init(format);
    }

    public void init(PinyinFormat format) {
        if (null == format) {
            format = PinyinFormat.WITHOUT_TONE;
        }
        this.format = format;
    }

    @Override
    public String getPinyin(char c) {
        Object[] results = PinyinHelper.convertToPinyinArray((char)c, (PinyinFormat)this.format);
        return ArrayUtil.isEmpty((Object[])results) ? String.valueOf(c) : results[0];
    }

    @Override
    public String getPinyin(char c, boolean tone) {
        if (tone) {
            Object[] results = PinyinHelper.convertToPinyinArray((char)c, (PinyinFormat)PinyinFormat.WITH_TONE_MARK);
            return ArrayUtil.isEmpty((Object[])results) ? String.valueOf(c) : results[0];
        }
        return this.getPinyin(c);
    }

    @Override
    public String getPinyin(String str, String separator) {
        try {
            return PinyinHelper.convertToPinyinString((String)str, (String)separator, (PinyinFormat)this.format);
        }
        catch (com.github.stuxuhai.jpinyin.PinyinException e) {
            throw new PinyinException(e);
        }
    }

    @Override
    public String getPinyin(String str, String separator, boolean tone) {
        if (tone) {
            try {
                return PinyinHelper.convertToPinyinString((String)str, (String)separator, (PinyinFormat)PinyinFormat.WITH_TONE_MARK);
            }
            catch (com.github.stuxuhai.jpinyin.PinyinException e) {
                throw new PinyinException(e);
            }
        }
        return this.getPinyin(str, separator);
    }
}

