/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.pinyin.engine.pinyin4j;

import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinEngine;
import cn.hutool.extra.pinyin.PinyinException;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class Pinyin4jEngine
implements PinyinEngine {
    HanyuPinyinOutputFormat format;

    public Pinyin4jEngine() {
        this(null);
    }

    public Pinyin4jEngine(HanyuPinyinOutputFormat format) {
        this.init(format);
    }

    public void init(HanyuPinyinOutputFormat format) {
        if (null == format) {
            format = new HanyuPinyinOutputFormat();
            format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            format.setVCharType(HanyuPinyinVCharType.WITH_V);
        }
        this.format = format;
    }

    @Override
    public String getPinyin(char c) {
        Object result;
        try {
            Object[] results = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)this.format);
            result = ArrayUtil.isEmpty((Object[])results) ? String.valueOf(c) : results[0];
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            result = String.valueOf(c);
        }
        return result;
    }

    @Override
    public String getPinyin(char c, boolean tone) {
        Object result;
        if (tone) {
            try {
                HanyuPinyinOutputFormat formatTemp = new HanyuPinyinOutputFormat();
                formatTemp.setCaseType(HanyuPinyinCaseType.LOWERCASE);
                formatTemp.setToneType(HanyuPinyinToneType.WITH_TONE_MARK);
                formatTemp.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
                Object[] results = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)formatTemp);
                result = ArrayUtil.isEmpty((Object[])results) ? String.valueOf(c) : results[0];
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                result = String.valueOf(c);
            }
        } else {
            result = this.getPinyin(c);
        }
        return result;
    }

    @Override
    public String getPinyin(String str, String separator) {
        StrBuilder result = StrUtil.strBuilder();
        boolean isFirst = true;
        int strLen = str.length();
        try {
            for (int i = 0; i < strLen; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    result.append((CharSequence)separator);
                }
                Object[] pinyinStringArray = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(i), (HanyuPinyinOutputFormat)this.format);
                if (ArrayUtil.isEmpty((Object[])pinyinStringArray)) {
                    result.append(str.charAt(i));
                    continue;
                }
                result.append((CharSequence)pinyinStringArray[0]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new PinyinException(e);
        }
        return result.toString();
    }

    @Override
    public String getPinyin(String str, String separator, boolean tone) {
        if (tone) {
            StrBuilder result = StrUtil.strBuilder();
            boolean isFirst = true;
            int strLen = str.length();
            try {
                for (int i = 0; i < strLen; ++i) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        result.append((CharSequence)separator);
                    }
                    HanyuPinyinOutputFormat formatTemp = new HanyuPinyinOutputFormat();
                    formatTemp.setCaseType(HanyuPinyinCaseType.LOWERCASE);
                    formatTemp.setToneType(HanyuPinyinToneType.WITH_TONE_MARK);
                    formatTemp.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
                    Object[] pinyinStringArray = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(i), (HanyuPinyinOutputFormat)formatTemp);
                    if (ArrayUtil.isEmpty((Object[])pinyinStringArray)) {
                        result.append(str.charAt(i));
                        continue;
                    }
                    result.append((CharSequence)pinyinStringArray[0]);
                }
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                throw new PinyinException(e);
            }
            return result.toString();
        }
        return this.getPinyin(str, separator);
    }
}

