/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.dialect.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.dialect.DialectName;
import cn.hutool.db.dialect.impl.AnsiSqlDialect;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.Wrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;

public class HanaDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 1L;

    public HanaDialect() {
        this.wrapper = new Wrapper(Character.valueOf('\"'));
    }

    @Override
    public String dialectName() {
        return DialectName.HANA.name();
    }

    @Override
    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" LIMIT ").append(page.getPageSize()).append(" OFFSET ").append(page.getStartPosition());
    }

    @Override
    public PreparedStatement psForUpsert(Connection conn, Entity entity, String ... keys) throws SQLException {
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.create(this.wrapper);
        ArrayList columns = new ArrayList();
        ArrayList<Object> values = new ArrayList<Object>();
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank((CharSequence)field)) {
                columns.add(this.wrapper != null ? this.wrapper.wrap((String)field) : field);
                values.add(value);
            }
        });
        String tableName = entity.getTableName();
        if (this.wrapper != null) {
            tableName = this.wrapper.wrap(tableName);
        }
        builder.append("UPSERT ").append(tableName).append(" (");
        builder.append(String.join((CharSequence)", ", columns));
        builder.append(") VALUES (");
        builder.append(String.join((CharSequence)", ", Collections.nCopies(columns.size(), "?")));
        builder.append(") WITH PRIMARY KEY");
        return StatementUtil.prepareStatement(conn, builder.toString(), values);
    }
}

