/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.dialect.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.dialect.DialectName;
import cn.hutool.db.dialect.impl.AnsiSqlDialect;
import cn.hutool.db.sql.SqlBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class DmDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 3415348435502927423L;

    @Override
    public String dialectName() {
        return DialectName.DM.name();
    }

    @Override
    public PreparedStatement psForUpsert(Connection conn, Entity entity, String ... keys) throws SQLException {
        Assert.notEmpty((Object[])keys, (String)"Keys must be not empty for DM MERGE SQL.", (Object[])new Object[0]);
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.create(this.wrapper);
        List<String> keyList = Arrays.asList(keys);
        StringBuilder keyFieldsPart = new StringBuilder();
        StringBuilder updateFieldsPart = new StringBuilder();
        StringBuilder insertFieldsPart = new StringBuilder();
        StringBuilder insertPlaceHolder = new StringBuilder();
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank((CharSequence)field) && keyList.contains(field)) {
                if (keyFieldsPart.length() > 0) {
                    keyFieldsPart.append(" and ");
                }
                keyFieldsPart.append(field + "= ?");
                builder.addParams(value);
            }
        });
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank((CharSequence)field) && !keyList.contains(field)) {
                if (updateFieldsPart.length() > 0) {
                    updateFieldsPart.append(", ");
                }
                updateFieldsPart.append((String)field).append("= ?");
                builder.addParams(value);
            }
        });
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank((CharSequence)field)) {
                if (insertFieldsPart.length() > 0) {
                    insertFieldsPart.append(", ");
                    insertPlaceHolder.append(", ");
                }
                insertFieldsPart.append(null != this.wrapper ? this.wrapper.wrap((String)field) : field);
                insertPlaceHolder.append("?");
                builder.addParams(value);
            }
        });
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        builder.append("MERGE INTO ").append(tableName).append(" USING DUAL ON ").append(keyFieldsPart).append(" WHEN MATCHED THEN UPDATE SET ").append(updateFieldsPart).append(" WHEN NOT MATCHED THEN INSERT (").append(insertFieldsPart).append(") VALUES (").append(insertPlaceHolder).append(")");
        return StatementUtil.prepareStatement(conn, builder);
    }
}

