/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.pooled;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.ds.pooled.ConnectionWraper;
import cn.hutool.db.ds.pooled.DbConfig;
import cn.hutool.db.ds.pooled.PooledDataSource;
import cn.hutool.setting.dialect.Props;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class PooledConnection
extends ConnectionWraper {
    private final PooledDataSource ds;
    private boolean isClosed;

    public PooledConnection(PooledDataSource ds) throws SQLException {
        Properties connProps;
        String password;
        this.ds = ds;
        DbConfig config = ds.getConfig();
        String driver = config.getDriver();
        if (StrUtil.isNotBlank((CharSequence)driver)) {
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                throw new DbRuntimeException(e);
            }
        }
        Props info = new Props();
        String user = config.getUser();
        if (user != null) {
            info.setProperty("user", user);
        }
        if ((password = config.getPass()) != null) {
            info.setProperty("password", password);
        }
        if (MapUtil.isNotEmpty((Map)(connProps = config.getConnProps()))) {
            info.putAll((Map)connProps);
        }
        this.raw = DriverManager.getConnection(config.getUrl(), (Properties)info);
    }

    public PooledConnection(PooledDataSource ds, Connection conn) {
        this.ds = ds;
        this.raw = conn;
    }

    @Override
    public void close() {
        this.ds.free(this);
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed || this.raw.isClosed();
    }

    protected PooledConnection open() {
        this.isClosed = false;
        return this;
    }

    protected PooledConnection release() {
        DbUtil.close(this.raw);
        return this;
    }
}

