/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.unit;

import cn.hutool.core.io.unit.DataSize;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.StrUtil;

public enum DataUnit {
    BYTES("B", DataSize.ofBytes(1L)),
    KILOBYTES("KB", DataSize.ofKilobytes(1L)),
    MEGABYTES("MB", DataSize.ofMegabytes(1L)),
    GIGABYTES("GB", DataSize.ofGigabytes(1L)),
    TERABYTES("TB", DataSize.ofTerabytes(1L));

    public static final String[] UNIT_NAMES;
    private final String suffix;
    private final DataSize size;

    private DataUnit(String suffix, DataSize size) {
        this.suffix = suffix;
        this.size = size;
    }

    public String getSuffix() {
        return this.suffix;
    }

    DataSize size() {
        return this.size;
    }

    public static DataUnit fromSuffix(String suffix) {
        if (StrUtil.length(suffix) == 3 && CharUtil.equals(suffix.charAt(1), 'i', true)) {
            suffix = new String(new char[]{suffix.charAt(0), suffix.charAt(2)});
        }
        for (DataUnit candidate : DataUnit.values()) {
            if (!StrUtil.startWithIgnoreCase(candidate.suffix, suffix)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Unknown data unit suffix '" + suffix + "'");
    }

    static {
        UNIT_NAMES = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
    }
}

