/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.ref.Ref;
import cn.hutool.core.util.ObjUtil;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class ReferenceUtil {
    public static <T> Reference<T> create(ReferenceType type, T referent) {
        return ReferenceUtil.create(type, referent, null);
    }

    public static <T> Reference<T> create(ReferenceType type, T referent, ReferenceQueue<T> queue) {
        switch (type) {
            case SOFT: {
                return new SoftReference<T>(referent, queue);
            }
            case WEAK: {
                return new WeakReference<T>(referent, queue);
            }
            case PHANTOM: {
                return new PhantomReference<T>(referent, queue);
            }
        }
        return null;
    }

    public static <T> T get(Reference<T> obj) {
        return (T)ObjUtil.apply(obj, Reference::get);
    }

    public static <T> T get(Ref<T> obj) {
        return (T)ObjUtil.apply(obj, Ref::get);
    }

    public static enum ReferenceType {
        SOFT,
        WEAK,
        PHANTOM;

    }
}

