/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.compress;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipReader
implements Closeable {
    private static final int MAX_SIZE_DIFF = 100;
    private ZipFile zipFile;
    private ZipInputStream in;

    public static ZipReader of(File zipFile, Charset charset) {
        return new ZipReader(zipFile, charset);
    }

    public static ZipReader of(InputStream in, Charset charset) {
        return new ZipReader(in, charset);
    }

    public ZipReader(File zipFile, Charset charset) {
        this.zipFile = ZipUtil.toZipFile(zipFile, charset);
    }

    public ZipReader(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public ZipReader(InputStream in, Charset charset) {
        this.in = new ZipInputStream(in, charset);
    }

    public ZipReader(ZipInputStream zin) {
        this.in = zin;
    }

    public InputStream get(String path) {
        if (null != this.zipFile) {
            ZipFile zipFile = this.zipFile;
            ZipEntry entry = zipFile.getEntry(path);
            if (null != entry) {
                return ZipUtil.getStream(zipFile, entry);
            }
        } else {
            try {
                ZipEntry zipEntry;
                this.in.reset();
                while (null != (zipEntry = this.in.getNextEntry())) {
                    if (!zipEntry.getName().equals(path)) continue;
                    return this.in;
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return null;
    }

    public File readTo(File outFile) throws IORuntimeException {
        return this.readTo(outFile, null);
    }

    public File readTo(File outFile, Filter<ZipEntry> entryFilter) throws IORuntimeException {
        this.read(zipEntry -> {
            if (null == entryFilter || entryFilter.accept((ZipEntry)zipEntry)) {
                String path = zipEntry.getName();
                if (FileUtil.isWindows()) {
                    path = StrUtil.replace((CharSequence)path, (CharSequence)"*", "_");
                }
                File outItemFile = FileUtil.file(outFile, path);
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                } else {
                    InputStream in = null != this.zipFile ? ZipUtil.getStream(this.zipFile, zipEntry) : this.in;
                    FileUtil.writeFromStream(in, outItemFile, false);
                }
            }
        });
        return outFile;
    }

    public ZipReader read(Consumer<ZipEntry> consumer) throws IORuntimeException {
        if (null != this.zipFile) {
            this.readFromZipFile(consumer);
        } else {
            this.readFromStream(consumer);
        }
        return this;
    }

    @Override
    public void close() throws IORuntimeException {
        if (null != this.zipFile) {
            IoUtil.close(this.zipFile);
        } else {
            IoUtil.close(this.in);
        }
    }

    private void readFromZipFile(Consumer<ZipEntry> consumer) {
        Enumeration<? extends ZipEntry> em = this.zipFile.entries();
        while (em.hasMoreElements()) {
            consumer.accept(ZipReader.checkZipBomb(em.nextElement()));
        }
    }

    private void readFromStream(Consumer<ZipEntry> consumer) throws IORuntimeException {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                consumer.accept(zipEntry);
                ZipReader.checkZipBomb(zipEntry);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static ZipEntry checkZipBomb(ZipEntry entry) {
        if (null == entry) {
            return null;
        }
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getSize();
        if (compressedSize < 0L || uncompressedSize < 0L || compressedSize * 100L < uncompressedSize) {
            throw new UtilException("Zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", compressedSize, uncompressedSize, entry.getName());
        }
        return entry;
    }
}

