/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.data.loader;

import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import cn.dev33.satoken.oauth2.exception.SaOAuth2ClientModelException;
import cn.dev33.satoken.secure.SaSecureUtil;

public interface SaOAuth2DataLoader {
    default public SaClientModel getClientModel(String clientId) {
        return SaOAuth2Manager.getServerConfig().getClients().get(clientId);
    }

    default public SaClientModel getClientModelNotNull(String clientId) {
        SaClientModel clientModel = this.getClientModel(clientId);
        if (clientModel == null) {
            throw new SaOAuth2ClientModelException("\u65e0\u6548 client_id: " + clientId).setClientId(clientId).setCode(30105);
        }
        return clientModel;
    }

    default public String getOpenid(String clientId, Object loginId) {
        return SaSecureUtil.md5((String)(SaOAuth2Manager.getServerConfig().getOpenidDigestPrefix() + "_" + clientId + "_" + loginId));
    }
}

