/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

public enum KSQLState {
    SYSTEM_ERROR("60000"),
    UNKNOWN_STATE(""),
    UNEXPECTED_ERROR("99999"),
    NO_DATA("02000"),
    INVALID_PARAMETER_TYPE("07006"),
    UNDEFINED_TABLE("42P01"),
    OBJECT_IN_USE("55006"),
    CONNECTION_REJECTED("08004"),
    CONNECTION_FAILURE_DURING_TRANSACTION("08007"),
    CONNECTION_FAILURE("08006"),
    UNDEFINED_OBJECT("42704"),
    PROTOCOL_VIOLATION("08P01"),
    DATA_ERROR("22000"),
    COMMUNICATION_ERROR("08S01"),
    IN_FAILED_SQL_TRANSACTION("25P02"),
    NOT_IMPLEMENTED("0A000"),
    STRING_DATA_RIGHT_TRUNCATION("22001"),
    DIVISION_BY_ZERO("22012"),
    BAD_DATETIME_FORMAT("22007"),
    INVALID_SQL_STATEMENT_NAME("26000"),
    DATETIME_OVERFLOW("22008"),
    MOST_SPECIFIC_TYPE_DOES_NOT_MATCH("2200G"),
    NO_ACTIVE_SQL_TRANSACTION("25P01"),
    INVALID_PARAMETER_VALUE("22023"),
    INVALID_CURSOR_STATE("24000"),
    TRANSACTION_STATE_INVALID("25000"),
    ACTIVE_SQL_TRANSACTION("25001"),
    CONNECTION_UNABLE_TO_CONNECT("08001"),
    NUMERIC_VALUE_OUT_OF_RANGE("22003"),
    DEADLOCK_DETECTED("40P01"),
    INVALID_AUTHORIZATION_SPECIFICATION("28000"),
    STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL("2F003"),
    INVALID_SAVEPOINT_SPECIFICATION("3B000"),
    SYNTAX_ERROR("42601"),
    DATA_TYPE_MISMATCH("42821"),
    UNDEFINED_COLUMN("42703"),
    WRONG_OBJECT_TYPE("42809"),
    NUMERIC_CONSTANT_OUT_OF_RANGE("42820"),
    UNDEFINED_FUNCTION("42883"),
    INVALID_NAME("42602"),
    DATATYPE_MISMATCH("42804"),
    OBJECT_NOT_IN_STATE("55000"),
    CANNOT_COERCE("42846"),
    CONNECTION_DOES_NOT_EXIST("08003"),
    OUT_OF_MEMORY("53200"),
    QUERY_CANCELED("57014"),
    TOO_MANY_RESULTS("0100E"),
    IO_ERROR("58030");

    private final String stateT;

    public static boolean isConnectionError(String pstqlState) {
        return CONNECTION_UNABLE_TO_CONNECT.getState().equals(pstqlState) || CONNECTION_DOES_NOT_EXIST.getState().equals(pstqlState) || CONNECTION_REJECTED.getState().equals(pstqlState) || CONNECTION_FAILURE.getState().equals(pstqlState) || CONNECTION_FAILURE_DURING_TRANSACTION.getState().equals(pstqlState);
    }

    public String getState() {
        return this.stateT;
    }

    private KSQLState(String state) {
        this.stateT = state;
    }
}

