/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Level;

public class BouncyCastleUtils {
    public static void initBouncyCastleProvider() throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String providerName = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        try {
            Provider provider = Security.getProvider("BC");
            if (provider == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Class<?> bouncyCastleProvider = Class.forName(providerName);
                provider = (Provider)bouncyCastleProvider.newInstance();
                Security.addProvider(provider);
            }
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Could not found bouncyCastle provider, please load bcprov-jdk15on jar package manually!", new Object[0]), KSQLState.CONNECTION_REJECTED);
        }
    }
}

