/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ssl;

import com.kingbase8.ssl.LibKCIFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;

public class PKCS12KeyManager
implements X509KeyManager {
    private final CallbackHandler callbackHandler;
    private KSQLException _error = null;
    private final String _keyfile;
    private final KeyStore _keyStore;
    boolean keystoreLoadedT = false;

    public PKCS12KeyManager(String pkcsFile, CallbackHandler cbh) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._keyStore = KeyStore.getInstance("pkcs12");
            this._keyfile = pkcsFile;
            this.callbackHandler = cbh;
        }
        catch (KeyStoreException _keyStoree) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unable to find pkcs12 keystore.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)_keyStoree);
        }
    }

    public void throwKeyManagerException() throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._error != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw this._error;
        }
    }

    @Override
    public String[] getClientAliases(String _keyType, Principal[] pcs) {
        String[] stringArray;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String aliasT = this.chooseClientAlias(new String[]{_keyType}, pcs, null);
        if (aliasT == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = aliasT;
        }
        return stringArray;
    }

    @Override
    public String chooseClientAlias(String[] str, Principal[] pcs, Socket socket) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (pcs == null || pcs.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "user";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        X509Certificate[] certchainT = this.getCertificateChain("user");
        if (certchainT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        X500Principal ourissuerT = certchainT[certchainT.length - 1].getIssuerX500Principal();
        boolean isFoundT = false;
        for (Principal principal : pcs) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!ourissuerT.equals(principal)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            isFoundT = true;
        }
        return isFoundT ? "user" : null;
    }

    @Override
    public String[] getServerAliases(String str, Principal[] pcs) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new String[0];
    }

    @Override
    public String chooseServerAlias(String str, Principal[] pcs, Socket socket) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String aliasT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.loadKeyStore_();
            Certificate[] certsT = this._keyStore.getCertificateChain(aliasT);
            X509Certificate[] x509CertificatesT = new X509Certificate[certsT.length];
            int i = 0;
            for (Certificate cert : certsT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                x509CertificatesT[i++] = (X509Certificate)cert;
            }
            return x509CertificatesT;
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._error = new KSQLException(GT.tr("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)exception);
            return null;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            this.loadKeyStore_();
            PasswordCallback pwdcallbackT = new PasswordCallback(GT.tr("Enter SSL password: ", new Object[0]), false);
            this.callbackHandler.handle(new Callback[]{pwdcallbackT});
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KeyStore.PasswordProtection protParamT = new KeyStore.PasswordProtection(pwdcallbackT.getPassword());
            KeyStore.PrivateKeyEntry pkEntryT = (KeyStore.PrivateKeyEntry)this._keyStore.getEntry("user", protParamT);
            PrivateKey myPrivateKeyT = pkEntryT.getPrivateKey();
            return myPrivateKeyT;
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._error = new KSQLException(GT.tr("Could not read SSL key file {0}.", this._keyfile), KSQLState.CONNECTION_FAILURE, (Throwable)exception);
            return null;
        }
    }

    private synchronized void loadKeyStore_() throws IOException, CertificateException, NoSuchAlgorithmException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.keystoreLoadedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        PasswordCallback pwdcallbackT = new PasswordCallback(GT.tr("Enter SSL password: ", new Object[0]), false);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.callbackHandler.handle(new Callback[]{pwdcallbackT});
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.callbackHandler instanceof LibKCIFactory.ConsoleCallbackHandler && "Console is not available".equals(unsupportedCallbackException.getMessage())) {
                this._error = new KSQLException(GT.tr("Could not read password for SSL key file, console is not available.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)unsupportedCallbackException);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._error = new KSQLException(GT.tr("Could not read password for SSL key file by callbackhandler {0}.", this.callbackHandler.getClass().getName()), KSQLState.CONNECTION_FAILURE, (Throwable)unsupportedCallbackException);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._keyStore.load(new FileInputStream(new File(this._keyfile)), pwdcallbackT.getPassword());
        this.keystoreLoadedT = true;
    }
}

