/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

class BooleanTypeUtil {
    private BooleanTypeUtil() {
    }

    static boolean castToBoolean(Object in, String compatibleLevel) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Cast to boolean: \"{0}\"", String.valueOf(in));
        }
        if (in instanceof Boolean) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return (Boolean)in;
        }
        if (in instanceof String) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return BooleanTypeUtil.fromString((String)in, compatibleLevel);
        }
        if (in instanceof Character) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return BooleanTypeUtil.fromCharacter((Character)in);
        }
        if (in instanceof Number) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return BooleanTypeUtil.fromNumber((Number)in, compatibleLevel);
        }
        throw new KSQLException("Cannot cast to boolean", KSQLState.CANNOT_COERCE);
    }

    private static boolean fromString(String strvalue, String compatibleLevel) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String value = strvalue.trim();
        if ("1".equals(value) || "true".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        if ("0".equals(value) || "false".equalsIgnoreCase(value) || "f".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "n".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (CompatibleDB.oracle(compatibleLevel)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double a = 0.0;
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                a = Double.parseDouble(strvalue);
            }
            catch (NumberFormatException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw BooleanTypeUtil.cannotCoerceException(strvalue);
            }
            if (a != 0.0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return true;
            }
            if (a == 0.0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
        } else if (CompatibleDB.mysql(compatibleLevel)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double a = 0.0;
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                a = Double.parseDouble(strvalue);
            }
            catch (NumberFormatException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw BooleanTypeUtil.cannotCoerceException(strvalue);
            }
            if (a == 0.0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            if (a == 1.0 || a == -1.0) {
                return true;
            }
            if (a > 0.0) {
                return true;
            }
            if (a < 0.0) {
                return false;
            }
        } else {
            if (CompatibleDB.sqlserver(compatibleLevel)) {
                try {
                    String trimmedString = strvalue.trim();
                    return 1 == trimmedString.length() ? Boolean.valueOf('1' == trimmedString.charAt(0)) : Boolean.valueOf(trimmedString);
                }
                catch (NumberFormatException e) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw BooleanTypeUtil.cannotCoerceException(strvalue);
                }
            }
            if (CompatibleDB.notPg(compatibleLevel)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                double a = 0.0;
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    a = Double.parseDouble(strvalue);
                }
                catch (NumberFormatException e) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw BooleanTypeUtil.cannotCoerceException(strvalue);
                }
                if (a != 0.0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return true;
                }
                if (a == 0.0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return false;
                }
            }
        }
        throw BooleanTypeUtil.cannotCoerceException(strvalue);
    }

    private static boolean fromCharacter(Character charvalue) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ('1' == charvalue.charValue() || 't' == charvalue.charValue() || 'T' == charvalue.charValue() || 'y' == charvalue.charValue() || 'Y' == charvalue.charValue()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        if ('0' == charvalue.charValue() || 'f' == charvalue.charValue() || 'F' == charvalue.charValue() || 'n' == charvalue.charValue() || 'N' == charvalue.charValue()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(charvalue);
    }

    private static boolean fromNumber(Number numvalue, String compatibleLevel) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        double _value = numvalue.doubleValue();
        if (_value == 1.0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        if (_value == 0.0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (CompatibleDB.oracle(compatibleLevel) && _value != 0.0) {
            return true;
        }
        if (CompatibleDB.mysql(compatibleLevel)) {
            if (_value == -1.0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return true;
            }
            if (_value > 0.0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return true;
            }
            if (_value < 0.0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
        }
        if (CompatibleDB.notPg(compatibleLevel) && _value != 0.0) {
            return true;
        }
        throw BooleanTypeUtil.cannotCoerceException(numvalue);
    }

    private static KSQLException cannotCoerceException(Object _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Cannot cast to boolean: \"{0}\"", String.valueOf(_value));
        }
        return new KSQLException(GT.tr("Cannot cast to boolean: \"{0}\"", String.valueOf(_value)), KSQLState.CANNOT_COERCE);
    }
}

