/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.gss;

import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class GSSCallbackHandler
implements CallbackHandler {
    private final String pwd;
    private final String user;

    public GSSCallbackHandler(String user, String pwd) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pwd = pwd;
        this.user = user;
    }

    @Override
    public void handle(Callback[] _callbacks) throws IOException, UnsupportedCallbackException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (Callback _callback : _callbacks) {
            if (_callback instanceof TextOutputCallback) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TextOutputCallback textOutputCallback = (TextOutputCallback)_callback;
                switch (textOutputCallback.getMessageType()) {
                    case 0: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        System.out.println("INFO: " + textOutputCallback.getMessage());
                        break;
                    }
                    case 2: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        System.out.println("ERROR: " + textOutputCallback.getMessage());
                        break;
                    }
                    case 1: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        System.out.println("WARNING: " + textOutputCallback.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + textOutputCallback.getMessageType());
                    }
                }
                continue;
            }
            if (_callback instanceof NameCallback) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                NameCallback nc = (NameCallback)_callback;
                nc.setName(this.user);
                continue;
            }
            if (_callback instanceof PasswordCallback) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                PasswordCallback pc = (PasswordCallback)_callback;
                if (this.pwd == null) {
                    throw new IOException("No cached kerberos ticket found and no pwd supplied.");
                }
                pc.setPassword(this.pwd.toCharArray());
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new UnsupportedCallbackException(_callback, "Unrecognized Callback");
        }
    }
}

