/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ds.common;

import com.kingbase8.Driver;
import com.kingbase8.KBProperty;
import com.kingbase8.ds.common.KBObjectFactory;
import com.kingbase8.jdbc.AutoSave;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.util.ExpressionProperties;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import com.kingbase8.util.URLCoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;

public abstract class BaseDataSource
implements CommonDataSource,
Referenceable {
    private final String LOCALHOST = "localhost";
    private static final int ZERO = 0;
    private String dbName = "";
    private String[] serNames = new String[]{"localhost"};
    private String userName;
    private String pwd;
    private int[] portNumsT = new int[]{0};
    private Properties propes = new Properties();

    public Connection getConnection() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getConnection(this.userName, this.pwd);
    }

    public Connection getConnection(String userT, String passwordT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Connection _con = DriverManager.getConnection(this.getUrl(), userT, passwordT);
            if (KBLOGGER.isLoggable(Level.FINE)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.FINE, "Created a {0} for {1} at {2}", this.getDescription(), userT, this.getUrl());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _con;
        }
        catch (SQLException sqlException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Failed to create a {0} for {1} at {2}: {3}", this.getDescription(), userT, this.getUrl(), sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public PrintWriter getLogWriter() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Deprecated
    public String getServerName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.serNames[0];
    }

    public String[] getServerNames() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.serNames;
    }

    @Deprecated
    public void setServerName(String serName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setServerNames(new String[]{serName});
    }

    public void setServerNames(String[] serNames) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (serNames == null || serNames.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.serNames = new String[]{"localhost"};
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            serNames = Arrays.copyOf(serNames, serNames.length);
            for (int i = 0; i < serNames.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (serNames[i] != null && !serNames[i].equals("")) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                serNames[i] = "localhost";
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.serNames = serNames;
        }
    }

    public String getDatabaseName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.dbName;
    }

    public void setDatabaseName(String dbName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.dbName = dbName;
    }

    public abstract String getDescription();

    public String getUser() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.userName;
    }

    public void setUser(String user) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.userName = user;
    }

    public String getPassword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.pwd;
    }

    public void setPassword(String password) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pwd = password;
    }

    @Deprecated
    public int getPortNumber() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.portNumsT == null || this.portNumsT.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        return this.portNumsT[0];
    }

    public int[] getPortNumbers() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.portNumsT;
    }

    @Deprecated
    public void setPortNumber(int portNum) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setPortNumbers(new int[]{portNum});
    }

    public void setPortNumbers(int[] portNums) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (portNums == null || portNums.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            portNums = new int[]{0};
        }
        this.portNumsT = Arrays.copyOf(portNums, portNums.length);
    }

    public String getOptions() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.OPTIONS.get(this.propes);
    }

    public void setOptions(String options) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.OPTIONS.set(this.propes, options);
    }

    @Override
    public int getLoginTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.LOGIN_TIMEOUT.getIntNoCheck(this.propes);
    }

    @Override
    public void setLoginTimeout(int loginTimeoutStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.LOGIN_TIMEOUT.set(this.propes, loginTimeoutStream);
    }

    public int getConnectTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.CONNECT_TIMEOUT.getIntNoCheck(this.propes);
    }

    public void setConnectTimeout(int connectTimeoutStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.CONNECT_TIMEOUT.set(this.propes, connectTimeoutStream);
    }

    public int getProtocolVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!KBProperty.PROTOCOL_VERSION.isPresent(this.propes)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.PROTOCOL_VERSION.getIntNoCheck(this.propes);
    }

    public void setProtocolVersion(int protocolVersion) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (protocolVersion == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBProperty.PROTOCOL_VERSION.set(this.propes, null);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBProperty.PROTOCOL_VERSION.set(this.propes, protocolVersion);
        }
    }

    public int getReceiveBufferSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.RECEIVE_BUFFER_SIZE.getIntNoCheck(this.propes);
    }

    public void setReceiveBufferSize(int n_bytes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.RECEIVE_BUFFER_SIZE.set(this.propes, n_bytes);
    }

    public int getSendBufferSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SEND_BUFFER_SIZE.getIntNoCheck(this.propes);
    }

    public void setSendBufferSize(int n_bytes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SEND_BUFFER_SIZE.set(this.propes, n_bytes);
    }

    public void setPrepareThreshold(int _count) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.PREPARE_THRESHOLD.set(this.propes, _count);
    }

    public int getPrepareThreshold() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.PREPARE_THRESHOLD.getIntNoCheck(this.propes);
    }

    public int getPreparedStatementCacheQueries() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.PREPARED_STATEMENT_CACHE_QUERIES.getIntNoCheck(this.propes);
    }

    public void setPreparedStatementCacheQueries(int cacheSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.PREPARED_STATEMENT_CACHE_QUERIES.set(this.propes, cacheSize);
    }

    public int getPreparedStatementCacheSizeMiB() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getIntNoCheck(this.propes);
    }

    public void setPreparedStatementCacheSizeMiB(int cacheSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.set(this.propes, cacheSize);
    }

    public int getDatabaseMetadataCacheFields() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.DATABASE_METADATA_CACHE_FIELDS.getIntNoCheck(this.propes);
    }

    public void setDatabaseMetadataCacheFields(int cacheSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.DATABASE_METADATA_CACHE_FIELDS.set(this.propes, cacheSize);
    }

    public int getDatabaseMetadataCacheFieldsMiB() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getIntNoCheck(this.propes);
    }

    public void setDatabaseMetadataCacheFieldsMiB(int cacheSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.set(this.propes, cacheSize);
    }

    public void setDefaultRowFetchSize(int fetchSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.DEFAULT_ROW_FETCH_SIZE.set(this.propes, fetchSize);
    }

    public int getDefaultRowFetchSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.DEFAULT_ROW_FETCH_SIZE.getIntNoCheck(this.propes);
    }

    public void setUnknownLength(int unknownLength) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.UNKNOWN_LENGTH.set(this.propes, unknownLength);
    }

    public int getUnknownLength() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.UNKNOWN_LENGTH.getIntNoCheck(this.propes);
    }

    public void setSocketTimeout(int seconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SOCKET_TIMEOUT.set(this.propes, seconds);
    }

    public int getSocketTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SOCKET_TIMEOUT.getIntNoCheck(this.propes);
    }

    public void setCancelSignalTimeout(int seconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.CANCEL_SIGNAL_TIMEOUT.set(this.propes, seconds);
    }

    public void setSsl(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean TRUE = true;
        boolean FALSE = false;
        if (enabled) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBProperty.SSL.set(this.propes, true);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBProperty.SSL.set(this.propes, false);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    public int getCancelSignalTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.CANCEL_SIGNAL_TIMEOUT.getIntNoCheck(this.propes);
    }

    public boolean getSsl() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean aBoolean = KBProperty.SSL.getBoolean(this.propes);
        boolean bBoolean = "".equals(KBProperty.SSL.get(this.propes));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return aBoolean || bBoolean;
    }

    public void setSslfactory(String classname) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSL_FACTORY.set(this.propes, classname);
    }

    public String getSslfactory() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSL_FACTORY.get(this.propes);
    }

    public String getSslMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSL_MODE.get(this.propes);
    }

    public void setSslMode(String mode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSL_MODE.set(this.propes, mode);
    }

    public String getSslFactoryArg() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSL_FACTORY_ARG.get(this.propes);
    }

    public void setSslFactoryArg(String arg) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSL_FACTORY_ARG.set(this.propes, arg);
    }

    public String getSslHostnameVerifier() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSL_HOSTNAME_VERIFIER.get(this.propes);
    }

    public void setSslHostnameVerifier(String className) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSL_HOSTNAME_VERIFIER.set(this.propes, className);
    }

    public String getSslCert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSL_CERT.get(this.propes);
    }

    public void setSslCert(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSL_CERT.set(this.propes, file);
    }

    public String getSslKey() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSL_KEY.get(this.propes);
    }

    public void setSslKey(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSL_KEY.set(this.propes, file);
    }

    public String getSslRootCert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSL_ROOT_CERT.get(this.propes);
    }

    public void setSslRootCert(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSL_ROOT_CERT.set(this.propes, file);
    }

    public String getSslPassword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSL_PASSWORD.get(this.propes);
    }

    public void setSslPassword(String password) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSL_PASSWORD.set(this.propes, password);
    }

    public String getSslPasswordCallback() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSL_PASSWORD_CALLBACK.get(this.propes);
    }

    public void setSslPasswordCallback(String className) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSL_PASSWORD_CALLBACK.set(this.propes, className);
    }

    public void setApplicationName(String applicationName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.APPLICATION_NAME.set(this.propes, applicationName);
    }

    public String getApplicationName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.APPLICATION_NAME.get(this.propes);
    }

    public void setTargetServerType(String targetServerType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.TARGET_SERVER_TYPE.set(this.propes, targetServerType);
    }

    public String getTargetServerType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.TARGET_SERVER_TYPE.get(this.propes);
    }

    public void setLoadBalanceHosts(boolean loadBalanceHosts) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.LOAD_BALANCE_HOSTS.set(this.propes, loadBalanceHosts);
    }

    public boolean getLoadBalanceHosts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.LOAD_BALANCE_HOSTS.isPresent(this.propes);
    }

    public void setHostRecheckSeconds(int hostRecheckSeconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.HOST_RECHECK_SECONDS.set(this.propes, hostRecheckSeconds);
    }

    public int getHostRecheckSeconds() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.HOST_RECHECK_SECONDS.getIntNoCheck(this.propes);
    }

    public void setTcpKeepAlive(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.TCP_KEEP_ALIVE.set(this.propes, enabled);
    }

    public boolean getTcpKeepAlive() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.TCP_KEEP_ALIVE.getBoolean(this.propes);
    }

    public void setBinaryTransfer(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.BINARY_TRANSFER.set(this.propes, enabled);
    }

    public boolean getBinaryTransfer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.BINARY_TRANSFER.getBoolean(this.propes);
    }

    public void setBinaryTransferEnable(String oidList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.BINARY_TRANSFER_ENABLE.set(this.propes, oidList);
    }

    public String getBinaryTransferEnable() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.BINARY_TRANSFER_ENABLE.get(this.propes);
    }

    public void setBinaryTransferDisable(String oidList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.BINARY_TRANSFER_DISABLE.set(this.propes, oidList);
    }

    public String getBinaryTransferDisable() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.BINARY_TRANSFER_DISABLE.get(this.propes);
    }

    public String getStringType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.STRING_TYPE.get(this.propes);
    }

    public void setStringType(String stringType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.STRING_TYPE.set(this.propes, stringType);
    }

    public boolean isColumnSanitiserDisabled() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.propes);
    }

    public boolean getDisableColumnSanitiser() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.propes);
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.DISABLE_COLUMN_SANITISER.set(this.propes, disableColumnSanitiser);
    }

    public String getCurrentSchema() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.CURRENT_SCHEMA.get(this.propes);
    }

    public void setCurrentSchema(String currentSchema) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.CURRENT_SCHEMA.set(this.propes, currentSchema);
    }

    public boolean getReadOnly() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.READ_ONLY.getBoolean(this.propes);
    }

    public void setReadOnly(boolean readOnly) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.READ_ONLY.set(this.propes, readOnly);
    }

    public String getReadOnlyMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.READ_ONLY_MODE.get(this.propes);
    }

    public void setReadOnlyMode(String mode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.READ_ONLY_MODE.set(this.propes, mode);
    }

    public boolean getLogUnclosedConnections() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(this.propes);
    }

    public void setLogUnclosedConnections(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.LOG_UNCLOSED_CONNECTIONS.set(this.propes, enabled);
    }

    public boolean getLogServerErrorDetail() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(this.propes);
    }

    public void setLogServerErrorDetail(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.LOG_SERVER_ERROR_DETAIL.set(this.propes, enabled);
    }

    public String getAssumeMinServerVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.ASSUME_MIN_SERVER_VERSION.get(this.propes);
    }

    public void setAssumeMinServerVersion(String minVersion) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.ASSUME_MIN_SERVER_VERSION.set(this.propes, minVersion);
    }

    public String getJaasApplicationName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.JAAS_APPLICATION_NAME.get(this.propes);
    }

    public void setJaasApplicationName(String name) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.JAAS_APPLICATION_NAME.set(this.propes, name);
    }

    public boolean getJaasLogin() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.JAAS_LOGIN.getBoolean(this.propes);
    }

    public void setJaasLogin(boolean doLoginStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.JAAS_LOGIN.set(this.propes, doLoginStream);
    }

    public String getKerberosServerName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.KERBEROS_SERVER_NAME.get(this.propes);
    }

    public void setKerberosServerName(String serName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.KERBEROS_SERVER_NAME.set(this.propes, serName);
    }

    public boolean getUseSpNego() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.USE_SPNEGO.getBoolean(this.propes);
    }

    public void setUseSpNego(boolean use) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.USE_SPNEGO.set(this.propes, use);
    }

    public String getGssLib() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.GSS_LIB.get(this.propes);
    }

    public void setGssLib(String lib) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.GSS_LIB.set(this.propes, lib);
    }

    public String getSspiServiceClass() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SSPI_SERVICE_CLASS.get(this.propes);
    }

    public void setSspiServiceClass(String serviceClass) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SSPI_SERVICE_CLASS.set(this.propes, serviceClass);
    }

    public boolean getAllowEncodingChanges() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.ALLOW_ENCODING_CHANGES.getBoolean(this.propes);
    }

    public void setAllowEncodingChanges(boolean allow) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.ALLOW_ENCODING_CHANGES.set(this.propes, allow);
    }

    public String getSocketFactory() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SOCKET_FACTORY.get(this.propes);
    }

    public void setSocketFactory(String socketFactoryClassName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SOCKET_FACTORY.set(this.propes, socketFactoryClassName);
    }

    public String getSocketFactoryArg() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SOCKET_FACTORY_ARG.get(this.propes);
    }

    public void setSocketFactoryArg(String socketFactoryArg) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SOCKET_FACTORY_ARG.set(this.propes, socketFactoryArg);
    }

    public void setReplication(String replication) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.REPLICATION.set(this.propes, replication);
    }

    public String getEscapeSyntaxCallMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.ESCAPE_SYNTAX_CALL_MODE.get(this.propes);
    }

    public String getLoggerFile() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties sysProperties = System.getProperties();
        ExpressionProperties exprPropst = new ExpressionProperties(this.propes, sysProperties);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String logFile = KBProperty.KBLOGGER_FILE.get(exprPropst);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return logFile;
    }

    public void setEscapeSyntaxCallMode(String callMode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.ESCAPE_SYNTAX_CALL_MODE.set(this.propes, callMode);
    }

    public String getReplication() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.REPLICATION.get(this.propes);
    }

    public String getLoggerLevel() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.LOGGER_LEVEL.get(this.propes);
    }

    public void setLoggerLevel(String loggerLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.LOGGER_LEVEL.set(this.propes, loggerLevel);
    }

    public void setLoggerFile(String loggerFile) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.KBLOGGER_FILE.set(this.propes, loggerFile);
    }

    public String getUrl() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder urlStrBuilder = new StringBuilder(100);
        urlStrBuilder.append("jdbc:kingbase8://");
        for (int i = 0; i < this.serNames.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String str = ",";
                urlStrBuilder.append(",");
            }
            urlStrBuilder.append(this.serNames[i]);
            if (null == this.portNumsT || this.portNumsT.length < i || this.portNumsT[i] == 0) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String str2 = ":";
            urlStrBuilder.append(":").append(this.portNumsT[i]);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        urlStrBuilder.append("/").append(URLCoder.encode(this.dbName));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder query = new StringBuilder(100);
        for (KBProperty prop : KBProperty.values()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!prop.isPresent(this.propes)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (query.length() != 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                query.append("&");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            query.append(prop.getName());
            query.append("=");
            query.append(URLCoder.encode(prop.get(this.propes)));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length() > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            urlStrBuilder.append("?");
            urlStrBuilder.append((CharSequence)query);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return urlStrBuilder.toString();
    }

    public String getProperty(String name) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty pgProperty = KBProperty.forName(name);
        if (pgProperty != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getProperty(pgProperty);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String info = "Unsupported prop name: {0}";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KSQLState invalidParameterValue = KSQLState.INVALID_PARAMETER_VALUE;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Unsupported prop name: {0}", name), invalidParameterValue);
    }

    public String getURL() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getUrl();
    }

    public void setUrl(String _url) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties p = Driver.parseURL(_url, null);
        if (p == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("URL invalid " + _url);
        }
        for (KBProperty prop : KBProperty.values()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.propes.containsKey(prop.getName())) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setProperty(prop, prop.get(p));
        }
    }

    public void setURL(String _url) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setUrl(_url);
    }

    public void setProperty(String name, String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty pgProperty = KBProperty.forName(name);
        if (pgProperty == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unsupported prop name: {0}", name), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setProperty(pgProperty, _value);
    }

    public String getProperty(KBProperty prop) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return prop.get(this.propes);
    }

    public void setProperty(KBProperty prop, String _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_value == null) {
            return;
        }
        switch (prop) {
            case KB_HOST: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setServerNames(_value.split(","));
                break;
            }
            case KB_PORT: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String str = ",";
                String[] pst = _value.split(",");
                int length = pst.length;
                int[] portsT = new int[length];
                for (int index = 0; index < pst.length; ++index) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        portsT[index] = Integer.parseInt(pst[index]);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        portsT[index] = 0;
                    }
                }
                this.setPortNumbers(portsT);
                break;
            }
            case KB_DBNAME: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setDatabaseName(_value);
                break;
            }
            case USER: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setUser(_value);
                break;
            }
            case PASSWORD: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setPassword(_value);
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.propes.setProperty(prop.getName(), _value);
            }
        }
    }

    protected Reference createReference() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new Reference(this.getClass().getName(), KBObjectFactory.class.getName(), null);
    }

    @Override
    public Reference getReference() throws NamingException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Reference reference = this.createReference();
        StringBuilder serverString = new StringBuilder();
        for (int i = 0; i < this.serNames.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                serverString.append(",");
            }
            String serName = this.serNames[i];
            serverString.append(serName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        reference.add(new StringRefAddr("serName", serverString.toString()));
        StringBuilder portStrSB = new StringBuilder();
        for (int i = 0; i < this.portNumsT.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                portStrSB.append(",");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int p = this.portNumsT[i];
            portStrSB.append(Integer.toString(p));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        reference.add(new StringRefAddr("portNum", portStrSB.toString()));
        reference.add(new StringRefAddr("dbName", this.dbName));
        if (this.userName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reference.add(new StringRefAddr("user", this.userName));
        }
        if (this.pwd != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reference.add(new StringRefAddr("password", this.pwd));
        }
        for (KBProperty prop : KBProperty.values()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!prop.isPresent(this.propes)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reference.add(new StringRefAddr(prop.getName(), prop.get(this.propes)));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return reference;
    }

    private static String getReferenceProperty(Reference reference, String propertyName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        RefAddr addr = reference.get(propertyName);
        if (addr == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object content = addr.getContent();
        String prop = (String)content;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return prop;
    }

    public void setFromReference(Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.dbName = BaseDataSource.getReferenceProperty(reference, "dbName");
        String portNumString = BaseDataSource.getReferenceProperty(reference, "portNum");
        if (portNumString != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String[] pst = portNumString.split(",");
            int[] portsT = new int[pst.length];
            for (int j = 0; j < pst.length; ++j) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    portsT[j] = Integer.parseInt(pst[j]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    portsT[j] = 0;
                }
            }
            this.setPortNumbers(portsT);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setPortNumbers(null);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String serName = BaseDataSource.getReferenceProperty(reference, "serName");
        String[] serNames = null;
        if (serName != null) {
            serNames = serName.split(",");
        }
        this.setServerNames(serNames);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (KBProperty prop : KBProperty.values()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String referenceProperty = BaseDataSource.getReferenceProperty(reference, prop.getName());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setProperty(prop, referenceProperty);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    protected void writeBaseObject(ObjectOutputStream outStream) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        outStream.writeObject(this.serNames);
        outStream.writeObject(this.dbName);
        outStream.writeObject(this.userName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        outStream.writeObject(this.pwd);
        outStream.writeObject(this.portNumsT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        outStream.writeObject(this.propes);
    }

    protected void readBaseObject(ObjectInputStream inStream) throws IOException, ClassNotFoundException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.serNames = (String[])inStream.readObject();
        this.dbName = (String)inStream.readObject();
        this.userName = (String)inStream.readObject();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pwd = (String)inStream.readObject();
        this.portNumsT = (int[])inStream.readObject();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.propes = (Properties)inStream.readObject();
    }

    public void initializeFrom(BaseDataSource baseDataSource) throws IOException, ClassNotFoundException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        baseDataSource.writeBaseObject(objectOutputStream);
        objectOutputStream.close();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.readBaseObject(objectInputStream);
    }

    public PreferQueryMode getPreferQueryMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PreferQueryMode.of(KBProperty.PREFER_QUERY_MODE.get(this.propes));
    }

    public void setPreferQueryMode(PreferQueryMode preferenceerQueryMode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.PREFER_QUERY_MODE.set(this.propes, preferenceerQueryMode.value());
    }

    public AutoSave getAutosave() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return AutoSave.of(KBProperty.AUTOSAVE.get(this.propes));
    }

    public void setAutosave(AutoSave autoSave) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.AUTOSAVE.set(this.propes, autoSave.value());
    }

    public boolean getCleanupSavepoints() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.CLEANUP_SAVEPOINTS.getBoolean(this.propes);
    }

    public void setCleanupSavepoints(boolean cleanupSavepoints) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.CLEANUP_SAVEPOINTS.set(this.propes, cleanupSavepoints);
    }

    public boolean getReWriteBatchedInserts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.REWRITE_BATCHED_INSERTS.getBoolean(this.propes);
    }

    public void setReWriteBatchedInserts(boolean reWrite) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.REWRITE_BATCHED_INSERTS.set(this.propes, reWrite);
    }

    public boolean getHideUnprivilegedObjects() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.HIDE_UNPRIVILEGED_OBJECTS.getBoolean(this.propes);
    }

    public void setHideUnprivilegedObjects(boolean hideUnprivileged) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.HIDE_UNPRIVILEGED_OBJECTS.set(this.propes, hideUnprivileged);
    }

    @Override
    public Logger getParentLogger() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Logger.getLogger("com.kingbase8");
    }

    public String getSslfactoryarg() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslFactoryArg();
    }

    public boolean isSsl() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSsl();
    }

    public String getSslcert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslCert();
    }

    public void setSslfactoryarg(String arg) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslFactoryArg(arg);
    }

    public String getSslmode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslMode();
    }

    public void setSslcert(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslCert(file);
    }

    public String getSsl_hostnameverifier() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslHostnameVerifier();
    }

    public void setSslmode(String mode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslMode(mode);
    }

    public String getSsl_key() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslKey();
    }

    public void setSsl_hostnameverifier(String className) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslHostnameVerifier(className);
    }

    public String getSslrootcert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslRootCert();
    }

    public void setSsl_key(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslKey(file);
    }

    public String getSslpassword_callback() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslPasswordCallback();
    }

    public void setSslrootcert(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslRootCert(file);
    }

    public String getSslpassword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslPassword();
    }

    public void setSslpassword_callback(String className) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslPasswordCallback(className);
    }

    public int getRecvBufferSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getReceiveBufferSize();
    }

    public void setSslpassword(String sslpassword) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslPassword(sslpassword);
    }

    public boolean isAllowEncodingChanges() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getAllowEncodingChanges();
    }

    public void setRecvBufferSize(int n_bytes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setReceiveBufferSize(n_bytes);
    }

    public boolean isTcpKeepAlive() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getTcpKeepAlive();
    }

    public boolean isLogUnclosedConnections() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getLogUnclosedConnections();
    }

    public boolean isDisableColumnSanitiser() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getDisableColumnSanitiser();
    }

    public boolean isReadOnly() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getReadOnly();
    }

    public boolean isCleanupSavePoints() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getCleanupSavepoints();
    }

    public boolean isLoadBalanceHosts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getLoadBalanceHosts();
    }

    public boolean isReWriteBatchedInserts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getReWriteBatchedInserts();
    }

    public void setCleanupSavePoints(boolean cleanupSavepoints) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setCleanupSavepoints(cleanupSavepoints);
    }

    public void setUseDispatch(boolean useDispatch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.USEDISPATCH.set(this.propes, useDispatch);
    }

    public boolean getUseDispatch() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.USEDISPATCH.getBoolean(this.propes);
    }

    public void setHostLoadRate(int _hostLoadRate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.HOSTLOADRATE.set(this.propes, _hostLoadRate);
    }

    public int getHostLoadRate() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.HOSTLOADRATE.getIntNoCheck(this.propes);
    }

    public void setSlave_Add(String slaveAdd) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SLAVE_ADD.set(this.propes, slaveAdd);
    }

    public String getSlave_Add() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SLAVE_ADD.get(this.propes);
    }

    public void setSlave_Port(String slavePort) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.SLAVE_PORT.set(this.propes, slavePort);
    }

    public String getSlave_Port() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.SLAVE_PORT.get(this.propes);
    }

    public void setUseConnect_Pool(boolean useConnectPool) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.USECONNECT_POOL.set(this.propes, useConnectPool);
    }

    public boolean getUseConnect_Pool() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.USECONNECT_POOL.getBoolean(this.propes);
    }

    public void setConnect_Poolsize(int _connectPoolsize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.CONNECT_POOLSIZE.set(this.propes, _connectPoolsize);
    }

    public int getConnect_Poolsize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.CONNECT_POOLSIZE.getIntNoCheck(this.propes);
    }

    public void setMaster_Check(boolean masterCheck) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.MASTER_CHECK.set(this.propes, masterCheck);
    }

    public boolean getMaster_Check() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.MASTER_CHECK.getBoolean(this.propes);
    }

    public void setCluster_Monitor(boolean clusterMonitor) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.CLUSTER_MONITOR.set(this.propes, clusterMonitor);
    }

    public int getMonitorInterval() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty monitorinterval = KBProperty.MONITORINTERVAL;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return monitorinterval.getIntNoCheck(this.propes);
    }

    public boolean getCluster_Monitor() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.CLUSTER_MONITOR.getBoolean(this.propes);
    }

    public void setMonitorInterval(int monitorInterval) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty monitorinterval = KBProperty.MONITORINTERVAL;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        monitorinterval.set(this.propes, monitorInterval);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public void setMonitorSocketTimeout(int monitorSocketTimeout) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty monitorSocketTimeout1 = KBProperty.MONITOR_SOCKET_TIMEOUT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        monitorSocketTimeout1.set(this.propes, monitorSocketTimeout);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public void setWriteIsRetry(boolean writeIsRetry) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty writeIsRetry1 = KBProperty.WRITE_IS_RETRY;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        writeIsRetry1.set(this.propes, writeIsRetry);
    }

    public void setMonitorRetryTimes(int monitorRetryTimes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty monitorRetryTimes1 = KBProperty.MONITOR_RETRY_TIMES;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        monitorRetryTimes1.set(this.propes, monitorRetryTimes);
    }

    public void setRetryTimes(int retryTimes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty retrytimes = KBProperty.RETRYTIMES;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        retrytimes.set(this.propes, retryTimes);
    }

    public int getRetryTimes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.RETRYTIMES.getIntNoCheck(this.propes);
    }

    public void setRetryInterval(int retryInterval) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.RETRYINTERVAL.set(this.propes, retryInterval);
    }

    public int getRetryInterval() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.RETRYINTERVAL.getIntNoCheck(this.propes);
    }

    public void setReturnBigintAsNumeric(boolean returnBigintAsNumeric) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.RETURN_BIGINT_AS_NUMERIC.set(this.propes, returnBigintAsNumeric);
    }

    public boolean getReturnBigintAsNumeric() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.RETURN_BIGINT_AS_NUMERIC.getBoolean(this.propes);
    }

    public int getMonitorSocketTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty monitorSocketTimeout = KBProperty.MONITOR_SOCKET_TIMEOUT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return monitorSocketTimeout.getIntNoCheck(this.propes);
    }

    public boolean getWriteIsRetry() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty writeIsRetry = KBProperty.WRITE_IS_RETRY;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return writeIsRetry.getBoolean(this.propes);
    }

    public int getMonitorRetryTimes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty monitorRetryTimes1 = KBProperty.MONITOR_RETRY_TIMES;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return monitorRetryTimes1.getIntNoCheck(this.propes);
    }

    public void setConfigurePath(String configurePath) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.CONFIGUREPATH.set(this.propes, configurePath);
    }

    public String getConfigurePath() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.CONFIGUREPATH.get(this.propes);
    }

    public void setWhiteList(String whiteList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.WHITELIST.set(this.propes, whiteList);
    }

    public String getAllSendFunctionList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty allSendFunctionList = KBProperty.ALL_SEND_FUNCTION_LIST;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return allSendFunctionList.get(this.propes);
    }

    public String getWhiteList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.WHITELIST.get(this.propes);
    }

    public void setBlackList(String blackList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.BLACKLIST.set(this.propes, blackList);
    }

    public String getBlackList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.BLACKLIST.get(this.propes);
    }

    public void setMasterFunctionList(String masterFunctionList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty masterfunctionlist = KBProperty.MASTERFUNCTIONLIST;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        masterfunctionlist.set(this.propes, masterFunctionList);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public String getMasterFunctionList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty masterfunctionlist = KBProperty.MASTERFUNCTIONLIST;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return masterfunctionlist.get(this.propes);
    }

    public void setAllSendFunctionList(String allSendFunctionList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty allSendFunctionList1 = KBProperty.ALL_SEND_FUNCTION_LIST;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        allSendFunctionList1.set(this.propes, allSendFunctionList);
    }

    public void setBlackSqlList(String blackSqlList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.BLACKSQLLIST.set(this.propes, blackSqlList);
    }

    public String getBlackSqlList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.BLACKSQLLIST.get(this.propes);
    }

    public void setTransactionDispatchStrategy(int transactionDispatchStrategy) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.TRANSACTIONDISPATCHSTRATEGY.set(this.propes, transactionDispatchStrategy);
    }

    public int getTransactionDispatchStrategy() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.TRANSACTIONDISPATCHSTRATEGY.getIntNoCheck(this.propes);
    }

    public void setReadListStrategy(int readListStrategy) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.READ_LIST_STRATEGY.set(this.propes, readListStrategy);
    }

    public int getReadListStrategy() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.READ_LIST_STRATEGY.getIntNoCheck(this.propes);
    }

    public void setTempTable(String tempTable) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.TEMPTABLE.set(this.propes, tempTable);
    }

    public void setDifferentLsn(int differentLsn) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.DIFFERENT_LSN.set(this.propes, differentLsn);
    }

    public int getDifferentLsn() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.DIFFERENT_LSN.getIntNoCheck(this.propes);
    }

    public void setClientEncoding(String clientEncoding) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.CLIENT_ENCODING.set(this.propes, clientEncoding);
    }

    public String getTempTable() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.TEMPTABLE.get(this.propes);
    }

    public String getClientEncoding() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.CLIENT_ENCODING.get(this.propes);
    }

    public void setPasswordEncryption(String passwordEncryption) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.PASSWORD_ENCRYPTION.set(this.propes, passwordEncryption);
    }

    public String getPasswordEncryption() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.PASSWORD_ENCRYPTION.get(this.propes);
    }

    public void setUseFetchSizeInAutoCommit(boolean useFetchSizeInAutoCommit) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.USE_FETCH_SIZE_IN_AUTO_COMMIT.set(this.propes, useFetchSizeInAutoCommit);
    }

    public boolean getUseFetchSizeInAutoCommit() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.USE_FETCH_SIZE_IN_AUTO_COMMIT.getBoolean(this.propes);
    }

    public void setNodeList(String nodeList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.NODE_LIST.set(this.propes, nodeList);
    }

    public String getNodeList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.NODE_LIST.get(this.propes);
    }

    public void setLoadRate(String loadRate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.LOAD_RATE.set(this.propes, loadRate);
    }

    public String getLoadRate() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.LOAD_RATE.get(this.propes);
    }

    public void setClearCountInterval(int clearCountInterval) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.CLEAR_COUNT_INTERVAL.set(this.propes, clearCountInterval);
    }

    public int getClearCountInterval() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.CLEAR_COUNT_INTERVAL.getIntNoCheck(this.propes);
    }

    public void setNullConvertEmptyLob(boolean nullConvertEmptyLob) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.NULL_CONVERT_EMPTY_LOB.set(this.propes, nullConvertEmptyLob);
    }

    public boolean getNullConvertEmptyLob() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.NULL_CONVERT_EMPTY_LOB.getBoolean(this.propes);
    }

    public void setMasterKeyword(String masterKeyword) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.MASTER_KEYWORD.set(this.propes, masterKeyword);
    }

    public String getMasterKeyword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.MASTER_KEYWORD.get(this.propes);
    }

    public void setInitParams(String initParams) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.INIT_PARAMS.set(this.propes, initParams);
    }

    public String getInitParams() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.INIT_PARAMS.get(this.propes);
    }

    public void setOptimizeBatchedDML(boolean optimizeBatchedDML) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.OPTIMIZE_BATCHED_DML.set(this.propes, optimizeBatchedDML);
    }

    public boolean getOptimizeBatchedDML() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.OPTIMIZE_BATCHED_DML.getBoolean(this.propes);
    }

    public void setIgnoreSavepoint(boolean ignoreSavepoint) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.IGNORE_SAVEPOINT.set(this.propes, ignoreSavepoint);
    }

    public boolean getIgnoreSavepoint() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.IGNORE_SAVEPOINT.getBoolean(this.propes);
    }

    public void setStoreCase(String storeCase) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.STORE_CASE.set(this.propes, storeCase);
    }

    public String getStoreCase() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.STORE_CASE.get(this.propes);
    }

    public void setStructType(String structType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.STRUCT_TYPE.set(this.propes, structType);
    }

    public String getStructType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.STRUCT_TYPE.get(this.propes);
    }

    public void setZipLevel(int zipLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.ZIP_LEVEL.set(this.propes, zipLevel);
    }

    public int getZipLevel() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.ZIP_LEVEL.getIntNoCheck(this.propes);
    }

    public void setRowidType(String rowidType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.ROWID_TYPE.set(this.propes, rowidType);
    }

    public String getRowidType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.ROWID_TYPE.get(this.propes);
    }

    public void setFastFailover(boolean fastFailover) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.FAST_FAILOVER.set(this.propes, fastFailover);
    }

    public boolean getFastFailover() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.FAST_FAILOVER.getBoolean(this.propes);
    }

    public void setStableSlave(boolean StableSlave) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.STABLE_SLAVE.set(this.propes, StableSlave);
    }

    public boolean getStableSlave() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.STABLE_SLAVE.getBoolean(this.propes);
    }

    public void setLoadBalanceStrategy(int loadBalanceStrategy) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.LOADBALANCE_STRATEGY.set(this.propes, loadBalanceStrategy);
    }

    public int getLoadBalanceStrategy() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.LOADBALANCE_STRATEGY.getIntNoCheck(this.propes);
    }

    public void setUkpwdcert(String ukpwdcert) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.UKPWD_CERT.set(this.propes, ukpwdcert);
    }

    public String getUkpwdcert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.UKPWD_CERT.get(this.propes);
    }

    public void setUkpwdkey(String ukpwdkey) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.UKPWD_KEY.set(this.propes, ukpwdkey);
    }

    public String getUkpwdkey() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.UKPWD_KEY.get(this.propes);
    }

    public void setUkpwdrootcert(String ukpwdrootcert) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.UKPWD_ROOT_CERT.set(this.propes, ukpwdrootcert);
    }

    public String getUkpwdrootcert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.UKPWD_ROOT_CERT.get(this.propes);
    }

    public void setUkpwdpassword(String ukpwdpassword) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.UKPWD_PASSWORD.set(this.propes, ukpwdpassword);
    }

    public String getUkpwdpassword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.UKPWD_PASSWORD.get(this.propes);
    }

    public void setUkpwdpasswordcallback(String ukpwdpasswordcallback) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.UKPWD_PASSWORD_CALLBACK.set(this.propes, ukpwdpasswordcallback);
    }

    public String getUkpwdpasswordcallback() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.UKPWD_PASSWORD_CALLBACK.get(this.propes);
    }

    public String getFastTypeInfo() {
        return KBProperty.FAST_TYPEINFO.get(this.propes);
    }

    public void setFastTypeInfo(String fastTypeInfo) {
        KBProperty.FAST_TYPEINFO.set(this.propes, fastTypeInfo);
    }

    public String getTimestampType() {
        return KBProperty.TIMESTAMP_TYPE.get(this.propes);
    }

    public void setTimestampType(String timestampType) {
        KBProperty.TIMESTAMP_TYPE.set(this.propes, timestampType);
    }

    public String getUsbkeypin() {
        return KBProperty.USBKEY_PIN.get(this.propes);
    }

    public void setUsbkeypin(String usbkeypin) {
        KBProperty.USBKEY_PIN.set(this.propes, usbkeypin);
    }

    public int getCompressLevel() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.COMPRESS_LEVEL.getIntNoCheck(this.propes);
    }

    public void setCompressLevel(int compressLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.COMPRESS_LEVEL.set(this.propes, compressLevel);
    }

    public int getCompressMin() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.COMPRESS_MIN.getIntNoCheck(this.propes);
    }

    public void setCompressMin(int compressMin) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.COMPRESS_MIN.set(this.propes, compressMin);
    }

    public int getCompressMax() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.COMPRESS_MAX.getIntNoCheck(this.propes);
    }

    public void setCompressMax(int compressMax) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBProperty.COMPRESS_MAX.set(this.propes, compressMax);
    }

    static {
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Class.forName("com.kingbase8.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("BaseDataSource is unable to load com.kingbase8.Driver. Please check if you have proper Kingbase8 JDBC Driver jar on the classpath", classNotFoundException);
        }
    }
}

