/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.copy;

import com.kingbase8.KBConnection;
import com.kingbase8.copy.CopyIn;
import com.kingbase8.util.GT;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;

public class KBCopyOutputStream
extends OutputStream
implements CopyIn {
    private CopyIn operation;
    private final byte[] copyBuffer;
    private final byte[] singleByteBuffer = new byte[1];
    private int atPosition = 0;

    public KBCopyOutputStream(KBConnection _connection, String _sql) throws SQLException {
        this(_connection, _sql, 65536);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBCopyOutputStream(KBConnection _connection, String _sql, int _bufferSize) throws SQLException {
        this(_connection.getCopyAPI().copyIn(_sql), _bufferSize);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBCopyOutputStream(CopyIn operation) {
        this(operation, 65536);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBCopyOutputStream(CopyIn operation, int _bufferSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.operation = operation;
        this.copyBuffer = new byte[_bufferSize];
    }

    @Override
    public void write(int b) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (b < 0 || b > 255) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException(GT.tr("Cannot write to copy a byte of _value {0}", b));
        }
        this.singleByteBuffer[0] = (byte)b;
        this.write(this.singleByteBuffer, 0, 1);
    }

    @Override
    public void write(byte[] _buf) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.write(_buf, 0, _buf.length);
    }

    @Override
    public void write(byte[] buffer, int off, int siz) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.writeToCopy(buffer, off, siz);
        }
        catch (SQLException sqlException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            IOException ioException = new IOException("Write to copy failed.");
            ioException.initCause(sqlException);
            throw ioException;
        }
    }

    private void checkIsClosed_() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.operation == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException(GT.tr("This copy stream is closed.", new Object[0]));
        }
    }

    @Override
    public void close() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.operation == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        if (this.operation.isActive()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.endCopy();
            }
            catch (SQLException sqlException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                IOException ioException = new IOException("Ending write to copy failed.");
                ioException.initCause(sqlException);
                throw ioException;
            }
        }
        this.operation = null;
    }

    @Override
    public void writeToCopy(byte[] _buf, int off, int size) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.atPosition > 0 && size > this.copyBuffer.length - this.atPosition) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.operation.writeToCopy(this.copyBuffer, 0, this.atPosition);
            this.atPosition = 0;
        }
        if (size > this.copyBuffer.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.operation.writeToCopy(_buf, off, size);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            System.arraycopy(_buf, off, this.copyBuffer, this.atPosition, size);
            this.atPosition += size;
        }
    }

    @Override
    public void flush() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.operation.writeToCopy(this.copyBuffer, 0, this.atPosition);
            this.atPosition = 0;
            this.operation.flushCopy();
        }
        catch (SQLException sqlException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            IOException ioException = new IOException("Unable to flush stream");
            ioException.initCause(sqlException);
            throw ioException;
        }
    }

    @Override
    public int getFormat() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getFormat();
    }

    @Override
    public int getFieldFormat(int _field) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getFieldFormat(_field);
    }

    @Override
    public void cancelCopy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.operation.cancelCopy();
    }

    @Override
    public int getFieldCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getFieldCount();
    }

    @Override
    public boolean isActive() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation != null && this.operation.isActive();
    }

    @Override
    public void flushCopy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.operation.flushCopy();
    }

    @Override
    public long endCopy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.atPosition > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.operation.writeToCopy(this.copyBuffer, 0, this.atPosition);
        }
        this.operation.endCopy();
        return this.getHandledRowCount();
    }

    @Override
    public long getHandledRowCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getHandledRowCount();
    }

    @Override
    public long getSkippedErrorRowCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getSkippedErrorRowCount();
    }
}

