/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.copy;

import com.kingbase8.KBConnection;
import com.kingbase8.copy.CopyOut;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.logging.Level;

public class KBCopyInputStream
extends InputStream
implements CopyOut {
    private CopyOut operation;
    private byte[] _buf;
    private int at;
    private int leng;

    public KBCopyInputStream(KBConnection _connection, String _sql) throws SQLException {
        this(_connection.getCopyAPI().copyOut(_sql));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBCopyInputStream(CopyOut operation) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.operation = operation;
    }

    private boolean gotBuf() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.at >= this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._buf = this.operation.readFromCopy();
            }
            catch (SQLException _sqle) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new IOException(GT.tr("Copying from database failed: {0}", _sqle));
            }
            if (this._buf == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.at = -1;
                return false;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.at = 0;
            this.leng = this._buf.length;
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._buf != null;
    }

    private void checkIsClosed() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.operation == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException(GT.tr("This copy stream is closed.", new Object[0]));
        }
    }

    @Override
    public int available() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return this._buf != null ? this.leng - this.at : 0;
    }

    @Override
    public int read() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return this.gotBuf() ? this._buf[this.at++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] _buf) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.read(_buf, 0, _buf.length);
    }

    @Override
    public int read(byte[] _buf, int off, int siz) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        int got = 0;
        boolean didReadSomething = false;
        while (got < siz && (didReadSomething = this.gotBuf())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _buf[off + got++] = this._buf[this.at++];
        }
        return got == 0 && !didReadSomething ? -1 : got;
    }

    @Override
    public byte[] readFromCopy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] _result = this._buf;
        try {
            if (this.gotBuf()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.at > 0 || this.leng < this._buf.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[] ba = new byte[this.leng - this.at];
                    for (int i = this.at; i < this.leng; ++i) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ba[i - this.at] = this._buf[i];
                    }
                    _result = ba;
                }
                this.at = this.leng;
            }
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Read from copy failed.", new Object[0]), KSQLState.CONNECTION_FAILURE);
        }
        return _result;
    }

    @Override
    public byte[] readFromCopy(boolean block) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.readFromCopy();
    }

    @Override
    public void close() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.operation == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        if (this.operation.isActive()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                this.operation.cancelCopy();
            }
            catch (SQLException se) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                IOException ioe = new IOException("Failed to close copy reader.");
                ioe.initCause(se);
                throw ioe;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.operation = null;
    }

    @Override
    public void cancelCopy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.operation.cancelCopy();
    }

    @Override
    public int getFormat() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getFormat();
    }

    @Override
    public int getFieldFormat(int _field) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getFieldFormat(_field);
    }

    @Override
    public int getFieldCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getFieldCount();
    }

    @Override
    public boolean isActive() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation != null && this.operation.isActive();
    }

    @Override
    public long getHandledRowCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getHandledRowCount();
    }

    @Override
    public long getSkippedErrorRowCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.operation.getSkippedErrorRowCount();
    }
}

