/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner.transformer;

import android.view.View;
import cn.bingoogolapple.bgabanner.transformer.BGAPageTransformer;
import com.nineoldandroids.view.ViewHelper;

public class RotatePageTransformer
extends BGAPageTransformer {
    private float mMaxRotation = 15.0f;

    public RotatePageTransformer() {
    }

    public RotatePageTransformer(float maxRotation) {
        this.setMaxRotation(maxRotation);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        ViewHelper.setPivotX((View)view, (float)((float)view.getMeasuredWidth() * 0.5f));
        ViewHelper.setPivotY((View)view, (float)view.getMeasuredHeight());
        ViewHelper.setRotation((View)view, (float)0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        float rotation = this.mMaxRotation * position;
        ViewHelper.setPivotX((View)view, (float)((float)view.getMeasuredWidth() * 0.5f));
        ViewHelper.setPivotY((View)view, (float)view.getMeasuredHeight());
        ViewHelper.setRotation((View)view, (float)rotation);
    }

    @Override
    public void handleRightPage(View view, float position) {
        this.handleLeftPage(view, position);
    }

    public void setMaxRotation(float maxRotation) {
        if (maxRotation >= 0.0f && maxRotation <= 40.0f) {
            this.mMaxRotation = maxRotation;
        }
    }
}

