/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner.transformer;

import android.view.View;
import cn.bingoogolapple.bgabanner.transformer.BGAPageTransformer;
import com.nineoldandroids.view.ViewHelper;

public class DepthPageTransformer
extends BGAPageTransformer {
    private float mMinScale = 0.8f;

    public DepthPageTransformer() {
    }

    public DepthPageTransformer(float minScale) {
        this.setMinScale(minScale);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        ViewHelper.setAlpha((View)view, (float)0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        ViewHelper.setAlpha((View)view, (float)1.0f);
        ViewHelper.setTranslationX((View)view, (float)0.0f);
        ViewHelper.setScaleX((View)view, (float)1.0f);
        ViewHelper.setScaleY((View)view, (float)1.0f);
    }

    @Override
    public void handleRightPage(View view, float position) {
        ViewHelper.setAlpha((View)view, (float)(1.0f - position));
        ViewHelper.setTranslationX((View)view, (float)((float)(-view.getWidth()) * position));
        float scale = this.mMinScale + (1.0f - this.mMinScale) * (1.0f - position);
        ViewHelper.setScaleX((View)view, (float)scale);
        ViewHelper.setScaleY((View)view, (float)scale);
    }

    public void setMinScale(float minScale) {
        if (minScale >= 0.6f && minScale <= 1.0f) {
            this.mMinScale = minScale;
        }
    }
}

