/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import cn.bingoogolapple.bgabanner.PageChangeDurationScroller;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BGAViewPager
extends ViewPager {
    private boolean mScrollable = true;

    public BGAViewPager(Context context) {
        super(context);
    }

    public BGAViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        Class<ViewPager> viewpagerClass = ViewPager.class;
        try {
            boolean hasTransformer = transformer != null;
            Field pageTransformerField = viewpagerClass.getDeclaredField("mPageTransformer");
            pageTransformerField.setAccessible(true);
            ViewPager.PageTransformer mPageTransformer = (ViewPager.PageTransformer)pageTransformerField.get((Object)this);
            boolean needsPopulate = hasTransformer != (mPageTransformer != null);
            pageTransformerField.set((Object)this, transformer);
            Method setChildrenDrawingOrderEnabledCompatMethod = viewpagerClass.getDeclaredMethod("setChildrenDrawingOrderEnabledCompat", Boolean.TYPE);
            setChildrenDrawingOrderEnabledCompatMethod.setAccessible(true);
            setChildrenDrawingOrderEnabledCompatMethod.invoke((Object)this, hasTransformer);
            Field drawingOrderField = viewpagerClass.getDeclaredField("mDrawingOrder");
            drawingOrderField.setAccessible(true);
            if (hasTransformer) {
                drawingOrderField.setInt((Object)this, reverseDrawingOrder ? 2 : 1);
            } else {
                drawingOrderField.setInt((Object)this, 0);
            }
            if (needsPopulate) {
                Method populateMethod = viewpagerClass.getDeclaredMethod("populate", new Class[0]);
                populateMethod.setAccessible(true);
                populateMethod.invoke((Object)this, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPageChangeDuration(int duration) {
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            scrollerField.set((Object)this, (Object)new PageChangeDurationScroller(this.getContext(), duration));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAllowUserScrollable(boolean scrollable) {
        this.mScrollable = scrollable;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mScrollable) {
            return super.onInterceptTouchEvent(ev);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mScrollable) {
            return super.onTouchEvent(ev);
        }
        return false;
    }
}

