/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.bingoogolapple.bgabanner.BGAViewPager;
import cn.bingoogolapple.bgabanner.R;
import cn.bingoogolapple.bgabanner.transformer.AccordionPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.AlphaPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.CubePageTransformer;
import cn.bingoogolapple.bgabanner.transformer.DefaultPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.DepthPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.FadePageTransformer;
import cn.bingoogolapple.bgabanner.transformer.FlipPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.RotatePageTransformer;
import cn.bingoogolapple.bgabanner.transformer.StackPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.ZoomCenterPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.ZoomFadePageTransformer;
import cn.bingoogolapple.bgabanner.transformer.ZoomPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.ZoomStackPageTransformer;
import com.nineoldandroids.view.ViewHelper;
import java.util.ArrayList;
import java.util.List;

public class BGABanner
extends RelativeLayout {
    private static final int RMP = -1;
    private static final int RWC = -2;
    private static final int LWC = -2;
    private BGAViewPager mViewPager;
    private List<View> mViews;
    private List<String> mTips;
    private LinearLayout mPointRealContainerLl;
    private TextView mTipTv;
    private List<ImageView> mPoints;
    private boolean mAutoPlayAble = true;
    private boolean mIsAutoPlaying = false;
    private int mAutoPlayInterval = 2000;
    private int mPageChangeDuration = 2000;
    private int mPointGravity = 81;
    private int mPointLeftRightMargin;
    private int mPointTopBottomMargin;
    private int mPointContainerLeftRightPadding;
    private int mTipTextSize;
    private int mTipTextColor = -1;
    private int mCurrentPoint = 0;
    private Drawable mPointFocusedDrawable;
    private Drawable mPointUnfocusedDrawable;
    private Drawable mPointContainerBackgroundDrawable;
    private Handler mPagerHandler;
    private Runnable mAutoPlayTask = new Runnable(){

        @Override
        public void run() {
            BGABanner.this.mViewPager.setCurrentItem(BGABanner.this.mViewPager.getCurrentItem() + 1);
            BGABanner.this.mPagerHandler.postDelayed(BGABanner.this.mAutoPlayTask, (long)BGABanner.this.mAutoPlayInterval);
        }
    };

    public BGABanner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGABanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initDefaultAttrs(context);
        this.initCustomAttrs(context, attrs);
        this.initView(context);
    }

    private void initDefaultAttrs(Context context) {
        this.mViewPager = new BGAViewPager(context);
        this.mPagerHandler = new Handler();
        this.mPointLeftRightMargin = BGABanner.dp2px(context, 3.0f);
        this.mPointTopBottomMargin = BGABanner.dp2px(context, 6.0f);
        this.mPointContainerLeftRightPadding = BGABanner.dp2px(context, 10.0f);
        this.mTipTextSize = BGABanner.sp2px(context, 8.0f);
        this.mPointContainerBackgroundDrawable = new ColorDrawable(Color.parseColor((String)"#44aaaaaa"));
        this.mPointFocusedDrawable = this.getResources().getDrawable(R.drawable.banner_shape_point_select);
        this.mPointUnfocusedDrawable = this.getResources().getDrawable(R.drawable.banner_shape_point_normal);
    }

    private void initCustomAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BGABanner);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initCustomAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    private void initCustomAttr(int attr, TypedArray typedArray) {
        if (attr == R.styleable.BGABanner_banner_pointFocusedImg) {
            this.mPointFocusedDrawable = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.BGABanner_banner_pointUnfocusedImg) {
            this.mPointUnfocusedDrawable = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.BGABanner_banner_pointContainerBackground) {
            this.mPointContainerBackgroundDrawable = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.BGABanner_banner_pointLeftRightMargin) {
            this.mPointLeftRightMargin = typedArray.getDimensionPixelSize(attr, this.mPointLeftRightMargin);
        } else if (attr == R.styleable.BGABanner_banner_pointContainerLeftRightPadding) {
            this.mPointContainerLeftRightPadding = typedArray.getDimensionPixelSize(attr, this.mPointContainerLeftRightPadding);
        } else if (attr == R.styleable.BGABanner_banner_pointTopBottomMargin) {
            this.mPointTopBottomMargin = typedArray.getDimensionPixelSize(attr, this.mPointTopBottomMargin);
        } else if (attr == R.styleable.BGABanner_banner_pointGravity) {
            this.mPointGravity = typedArray.getInt(attr, this.mPointGravity);
        } else if (attr == R.styleable.BGABanner_banner_pointAutoPlayAble) {
            this.mAutoPlayAble = typedArray.getBoolean(attr, this.mAutoPlayAble);
        } else if (attr == R.styleable.BGABanner_banner_pointAutoPlayInterval) {
            this.mAutoPlayInterval = typedArray.getInteger(attr, this.mAutoPlayInterval);
        } else if (attr == R.styleable.BGABanner_banner_pageChangeDuration) {
            this.mPageChangeDuration = typedArray.getInteger(attr, this.mPageChangeDuration);
        } else if (attr == R.styleable.BGABanner_banner_transitionEffect) {
            int ordinal = typedArray.getInt(attr, TransitionEffect.Accordion.ordinal());
            this.setTransitionEffect(TransitionEffect.values()[ordinal]);
        } else if (attr == R.styleable.BGABanner_banner_tipTextColor) {
            this.mTipTextColor = typedArray.getColor(attr, this.mTipTextColor);
        } else if (attr == R.styleable.BGABanner_banner_tipTextSize) {
            this.mTipTextSize = typedArray.getDimensionPixelSize(attr, this.mTipTextSize);
        }
    }

    private void initView(Context context) {
        this.addView((View)this.mViewPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.setPageChangeDuration(this.mPageChangeDuration);
        if (this.mPointFocusedDrawable == null) {
            throw new RuntimeException("pointFocusedImg\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.mPointUnfocusedDrawable == null) {
            throw new RuntimeException("pointUnfocusedImg\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RelativeLayout pointContainerRl = new RelativeLayout(context);
        if (Build.VERSION.SDK_INT >= 16) {
            pointContainerRl.setBackground(this.mPointContainerBackgroundDrawable);
        } else {
            pointContainerRl.setBackgroundDrawable(this.mPointContainerBackgroundDrawable);
        }
        pointContainerRl.setPadding(this.mPointContainerLeftRightPadding, 0, this.mPointContainerLeftRightPadding, 0);
        RelativeLayout.LayoutParams pointContainerLp = new RelativeLayout.LayoutParams(-1, -2);
        if ((this.mPointGravity & 0x70) == 48) {
            pointContainerLp.addRule(10);
        } else {
            pointContainerLp.addRule(12);
        }
        this.addView((View)pointContainerRl, (ViewGroup.LayoutParams)pointContainerLp);
        this.mPointRealContainerLl = new LinearLayout(context);
        this.mPointRealContainerLl.setId(R.id.banner_pointContainerId);
        this.mPointRealContainerLl.setOrientation(0);
        RelativeLayout.LayoutParams pointRealContainerLp = new RelativeLayout.LayoutParams(-2, -2);
        pointContainerRl.addView((View)this.mPointRealContainerLl, (ViewGroup.LayoutParams)pointRealContainerLp);
        RelativeLayout.LayoutParams tipLp = new RelativeLayout.LayoutParams(-1, this.mPointFocusedDrawable.getIntrinsicHeight() + 2 * this.mPointTopBottomMargin);
        this.mTipTv = new TextView(context);
        this.mTipTv.setGravity(16);
        this.mTipTv.setSingleLine(true);
        this.mTipTv.setEllipsize(TextUtils.TruncateAt.END);
        this.mTipTv.setTextColor(this.mTipTextColor);
        this.mTipTv.setTextSize(0, (float)this.mTipTextSize);
        pointContainerRl.addView((View)this.mTipTv, (ViewGroup.LayoutParams)tipLp);
        int horizontalGravity = this.mPointGravity & 7;
        if (horizontalGravity == 3) {
            pointRealContainerLp.addRule(9);
            tipLp.addRule(1, R.id.banner_pointContainerId);
            this.mTipTv.setGravity(21);
        } else if (horizontalGravity == 5) {
            pointRealContainerLp.addRule(11);
            tipLp.addRule(0, R.id.banner_pointContainerId);
        } else {
            pointRealContainerLp.addRule(14);
            tipLp.addRule(0, R.id.banner_pointContainerId);
        }
    }

    public void setPageChangeDuration(int duration) {
        if (duration > 0 && duration < 5000) {
            this.mViewPager.setPageChangeDuration(duration);
        }
    }

    public void setViewsAndTips(List<View> views, List<String> tips) {
        if (this.mAutoPlayAble && views.size() < 3) {
            throw new RuntimeException("\u5f00\u542f\u6307\u5b9a\u8f6e\u64ad\u65f6\u81f3\u5c11\u6709\u4e09\u4e2a\u9875\u9762");
        }
        if (tips != null && tips.size() < views.size()) {
            throw new RuntimeException("\u63d0\u793a\u6587\u6848\u6570\u5fc5\u987b\u7b49\u4e8e\u9875\u9762\u6570\u91cf");
        }
        this.mViews = views;
        this.mTips = tips;
        this.mViewPager.setAdapter(new PageAdapter());
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ChangePointListener());
        this.initPoints();
        this.processAutoPlay();
    }

    public void setViews(List<View> views) {
        this.setViewsAndTips(views, null);
    }

    public void setTips(List<String> tips) {
        if (tips != null && this.mViews != null && tips.size() < this.mViews.size()) {
            throw new RuntimeException("\u63d0\u793a\u6587\u6848\u6570\u5fc5\u987b\u7b49\u4e8e\u9875\u9762\u6570\u91cf");
        }
        this.mTips = tips;
    }

    private void initPoints() {
        this.mPointRealContainerLl.removeAllViews();
        this.mViewPager.removeAllViews();
        if (this.mPoints != null) {
            this.mPoints.clear();
        } else {
            this.mPoints = new ArrayList<ImageView>();
        }
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        lp.setMargins(this.mPointLeftRightMargin, this.mPointTopBottomMargin, this.mPointLeftRightMargin, this.mPointTopBottomMargin);
        for (int i = 0; i < this.mViews.size(); ++i) {
            ImageView imageView = new ImageView(this.getContext());
            imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
            imageView.setImageDrawable(this.mPointUnfocusedDrawable);
            this.mPoints.add(imageView);
            this.mPointRealContainerLl.addView((View)imageView);
        }
    }

    private void processAutoPlay() {
        if (this.mAutoPlayAble) {
            this.mViewPager.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            BGABanner.this.stopAutoPlay();
                            break;
                        }
                        case 1: {
                            BGABanner.this.startAutoPlay();
                        }
                    }
                    return false;
                }
            });
            int zeroItem = 0x3FFFFFFF - 0x3FFFFFFF % this.mViews.size();
            this.mViewPager.setCurrentItem(zeroItem);
        } else {
            this.switchToPoint(this.mCurrentPoint);
        }
    }

    public void setCurrentItem(int item) {
        if (this.mAutoPlayAble) {
            int realCurrentItem = this.mViewPager.getCurrentItem();
            int currentItem = realCurrentItem % this.mViews.size();
            int offset = item - currentItem;
            if (offset < 0) {
                for (int i = -1; i >= offset; --i) {
                    this.mViewPager.setCurrentItem(realCurrentItem + i, false);
                }
            } else if (offset > 0) {
                for (int i = 1; i <= offset; ++i) {
                    this.mViewPager.setCurrentItem(realCurrentItem + i, false);
                }
            }
            this.stopAutoPlay();
            this.startAutoPlay();
        } else {
            this.mViewPager.setCurrentItem(item, false);
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.startAutoPlay();
        } else if (visibility == 4) {
            this.stopAutoPlay();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPagerHandler != null) {
            this.mPagerHandler.removeCallbacks(this.mAutoPlayTask);
        }
    }

    private void startAutoPlay() {
        if (this.mAutoPlayAble && !this.mIsAutoPlaying) {
            this.mIsAutoPlaying = true;
            this.mPagerHandler.postDelayed(this.mAutoPlayTask, (long)this.mAutoPlayInterval);
        }
    }

    private void stopAutoPlay() {
        if (this.mAutoPlayAble && this.mIsAutoPlaying) {
            this.mIsAutoPlaying = false;
            this.mPagerHandler.removeCallbacks(this.mAutoPlayTask);
        }
    }

    private void switchToPoint(int newCurrentPoint) {
        this.mPoints.get(this.mCurrentPoint).setImageDrawable(this.mPointUnfocusedDrawable);
        this.mPoints.get(newCurrentPoint).setImageDrawable(this.mPointFocusedDrawable);
        this.mCurrentPoint = newCurrentPoint;
        if (this.mTipTv != null && this.mTips != null) {
            this.mTipTv.setText((CharSequence)this.mTips.get(newCurrentPoint % this.mTips.size()));
        }
    }

    public void setTransitionEffect(TransitionEffect effect) {
        switch (effect) {
            case Default: {
                this.mViewPager.setPageTransformer(true, new DefaultPageTransformer());
                break;
            }
            case Alpha: {
                this.mViewPager.setPageTransformer(true, new AlphaPageTransformer());
                break;
            }
            case Rotate: {
                this.mViewPager.setPageTransformer(true, new RotatePageTransformer());
                break;
            }
            case Cube: {
                this.mViewPager.setPageTransformer(true, new CubePageTransformer());
                break;
            }
            case Flip: {
                this.mViewPager.setPageTransformer(true, new FlipPageTransformer());
                break;
            }
            case Accordion: {
                this.mViewPager.setPageTransformer(true, new AccordionPageTransformer());
                break;
            }
            case ZoomFade: {
                this.mViewPager.setPageTransformer(true, new ZoomFadePageTransformer());
                break;
            }
            case Fade: {
                this.mViewPager.setPageTransformer(true, new FadePageTransformer());
                break;
            }
            case ZoomCenter: {
                this.mViewPager.setPageTransformer(true, new ZoomCenterPageTransformer());
                break;
            }
            case ZoomStack: {
                this.mViewPager.setPageTransformer(true, new ZoomStackPageTransformer());
                break;
            }
            case Stack: {
                this.mViewPager.setPageTransformer(true, new StackPageTransformer());
                break;
            }
            case Depth: {
                this.mViewPager.setPageTransformer(true, new DepthPageTransformer());
                break;
            }
            case Zoom: {
                this.mViewPager.setPageTransformer(true, new ZoomPageTransformer());
                break;
            }
        }
    }

    public void setPageTransformer(ViewPager.PageTransformer transformer) {
        if (transformer != null) {
            this.mViewPager.setPageTransformer(true, transformer);
        }
    }

    public static int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int sp2px(Context context, float spValue) {
        return (int)TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static enum TransitionEffect {
        Default,
        Alpha,
        Rotate,
        Cube,
        Flip,
        Accordion,
        ZoomFade,
        Fade,
        ZoomCenter,
        ZoomStack,
        Stack,
        Depth,
        Zoom;

    }

    private final class ChangePointListener
    extends ViewPager.SimpleOnPageChangeListener {
        private ChangePointListener() {
        }

        public void onPageSelected(int position) {
            BGABanner.this.switchToPoint(position % BGABanner.this.mViews.size());
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (BGABanner.this.mTipTv != null && BGABanner.this.mTips != null) {
                if ((double)positionOffset > 0.5) {
                    BGABanner.this.mTipTv.setText((CharSequence)BGABanner.this.mTips.get((position + 1) % BGABanner.this.mTips.size()));
                    ViewHelper.setAlpha((View)BGABanner.this.mTipTv, (float)positionOffset);
                } else {
                    ViewHelper.setAlpha((View)BGABanner.this.mTipTv, (float)(1.0f - positionOffset));
                    BGABanner.this.mTipTv.setText((CharSequence)BGABanner.this.mTips.get(position % BGABanner.this.mTips.size()));
                }
            }
        }
    }

    private final class PageAdapter
    extends PagerAdapter {
        private PageAdapter() {
        }

        public int getCount() {
            return BGABanner.this.mAutoPlayAble ? Integer.MAX_VALUE : BGABanner.this.mViews.size();
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View view = (View)BGABanner.this.mViews.get(position % BGABanner.this.mViews.size());
            if (container.equals(view.getParent())) {
                container.removeView(view);
            }
            container.addView(view);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }
    }
}

