/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import cn.bingoogolapple.bgabanner.R;
import java.util.ArrayList;
import java.util.List;

public class BGABanner
extends RelativeLayout {
    private static final int RMP = -1;
    private static final int RWC = -2;
    private static final int LWC = -2;
    private ViewPager mViewPager = null;
    private List<View> mViews = null;
    private LinearLayout mPointContainer = null;
    private List<ImageView> mPoints = null;
    private boolean mPointVisibility = false;
    private boolean mAutoPlayAble = false;
    private boolean mIsAutoPlaying = false;
    private int mAutoPlayInterval = 2000;
    private int mPointGravity = 81;
    private int mPointSpacing = 15;
    private int mPointEdgeSpacing = 15;
    private int mPointContainerWidth = -1;
    private int mPointContainerHeight = -2;
    private int mCurrentPoint = 0;
    private Drawable mPointFocusedDrawable;
    private Drawable mPointUnfocusedDrawable;
    private Drawable mPointContainerBackgroundDrawable;
    private Handler mPagerHandler;
    private Runnable mAutoPlayTask = new Runnable(){

        @Override
        public void run() {
            BGABanner.this.mViewPager.setCurrentItem(BGABanner.this.mViewPager.getCurrentItem() + 1);
            BGABanner.this.mPagerHandler.postDelayed(BGABanner.this.mAutoPlayTask, (long)BGABanner.this.mAutoPlayInterval);
        }
    };

    public BGABanner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGABanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs);
        this.initView(context);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BGABanner);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    public void initAttr(int attr, TypedArray typedArray) {
        if (attr == R.styleable.BGABanner_banner_pointFocusedImg) {
            this.mPointFocusedDrawable = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.BGABanner_banner_pointUnfocusedImg) {
            this.mPointUnfocusedDrawable = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.BGABanner_banner_pointContainerBackground) {
            this.mPointContainerBackgroundDrawable = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.BGABanner_banner_pointSpacing) {
            this.mPointSpacing = typedArray.getDimensionPixelSize(attr, this.mPointSpacing);
        } else if (attr == R.styleable.BGABanner_banner_pointEdgeSpacing) {
            this.mPointEdgeSpacing = typedArray.getDimensionPixelSize(attr, this.mPointEdgeSpacing);
        } else if (attr == R.styleable.BGABanner_banner_pointGravity) {
            this.mPointGravity = typedArray.getInt(attr, this.mPointGravity);
        } else if (attr == R.styleable.BGABanner_banner_pointContainerWidth) {
            try {
                this.mPointContainerWidth = typedArray.getDimensionPixelSize(attr, this.mPointContainerWidth);
            }
            catch (UnsupportedOperationException e) {
                this.mPointContainerWidth = typedArray.getInt(attr, this.mPointContainerWidth);
            }
        } else if (attr == R.styleable.BGABanner_banner_pointContainerHeight) {
            try {
                this.mPointContainerHeight = typedArray.getDimensionPixelSize(attr, this.mPointContainerHeight);
            }
            catch (UnsupportedOperationException e) {
                this.mPointContainerHeight = typedArray.getInt(attr, this.mPointContainerHeight);
            }
        } else if (attr == R.styleable.BGABanner_banner_pointVisibility) {
            this.mPointVisibility = typedArray.getBoolean(attr, this.mPointVisibility);
        } else if (attr == R.styleable.BGABanner_banner_pointAutoPlayAble) {
            this.mAutoPlayAble = typedArray.getBoolean(attr, this.mAutoPlayAble);
        } else if (attr == R.styleable.BGABanner_banner_pointAutoPlayInterval) {
            this.mAutoPlayInterval = typedArray.getInteger(attr, this.mAutoPlayInterval);
        }
    }

    private void initView(Context context) {
        this.mViewPager = new ViewPager(context);
        this.addView((View)this.mViewPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (this.mPointVisibility) {
            if (this.mPointFocusedDrawable == null) {
                throw new RuntimeException("pointFocusedImg is not allowed to be NULL");
            }
            if (this.mPointUnfocusedDrawable == null) {
                throw new RuntimeException("pointUnfocusedImg is not allowed to be NULL");
            }
            this.mPointContainer = new LinearLayout(context);
            this.mPointContainer.setOrientation(0);
            this.mPointContainer.setPadding(this.mPointEdgeSpacing, 0, this.mPointEdgeSpacing, 0);
            if (this.mPointContainerBackgroundDrawable != null) {
                this.mPointContainer.setBackgroundDrawable(this.mPointContainerBackgroundDrawable);
            }
            RelativeLayout.LayoutParams pointContainerLp = new RelativeLayout.LayoutParams(this.mPointContainerWidth, this.mPointContainerHeight);
            if ((this.mPointGravity & 0x70) == 48) {
                pointContainerLp.addRule(10);
            } else {
                pointContainerLp.addRule(12);
            }
            int horizontalGravity = this.mPointGravity & 7;
            if (horizontalGravity == 3) {
                this.mPointContainer.setGravity(19);
            } else if (horizontalGravity == 5) {
                this.mPointContainer.setGravity(21);
            } else {
                this.mPointContainer.setGravity(17);
            }
            this.addView((View)this.mPointContainer, (ViewGroup.LayoutParams)pointContainerLp);
        }
    }

    public void setViewPagerViews(List<View> views) {
        this.mViews = views;
        this.mViewPager.setAdapter((PagerAdapter)new MyAdapter());
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new MyListener());
        if (this.mPointVisibility) {
            this.initPoints();
            this.processAutoPlay();
        }
    }

    private void initPoints() {
        this.mPointContainer.removeAllViews();
        this.mViewPager.removeAllViews();
        if (this.mPoints != null) {
            this.mPoints.clear();
        } else {
            this.mPoints = new ArrayList<ImageView>();
        }
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        int margin = this.mPointSpacing / 2;
        lp.setMargins(margin, 0, margin, 0);
        for (int i = 0; i < this.mViews.size(); ++i) {
            ImageView imageView = new ImageView(this.getContext());
            imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
            imageView.setImageDrawable(this.mPointUnfocusedDrawable);
            this.mPoints.add(imageView);
            this.mPointContainer.addView((View)imageView);
        }
    }

    private void processAutoPlay() {
        if (this.mAutoPlayAble) {
            this.mPagerHandler = new Handler();
            this.mViewPager.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            BGABanner.this.stopAutoPlay();
                            break;
                        }
                        case 1: {
                            BGABanner.this.startAutoPlay();
                        }
                    }
                    return false;
                }
            });
            this.mViewPager.setCurrentItem(0x3FFFFFFF - 0x3FFFFFFF % this.mViews.size());
        } else {
            this.switchToPoint(0);
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.startAutoPlay();
        } else if (visibility == 4) {
            this.stopAutoPlay();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPagerHandler != null) {
            this.mPagerHandler.removeCallbacks(this.mAutoPlayTask);
        }
    }

    private void startAutoPlay() {
        if (this.mAutoPlayAble && !this.mIsAutoPlaying) {
            this.mIsAutoPlaying = true;
            this.mPagerHandler.postDelayed(this.mAutoPlayTask, (long)this.mAutoPlayInterval);
        }
    }

    private void stopAutoPlay() {
        if (this.mAutoPlayAble && this.mIsAutoPlaying) {
            this.mIsAutoPlaying = false;
            this.mPagerHandler.removeCallbacks(this.mAutoPlayTask);
        }
    }

    private void switchToPoint(int newCurrentPoint) {
        this.mPoints.get(this.mCurrentPoint).setImageDrawable(this.mPointUnfocusedDrawable);
        this.mPoints.get(newCurrentPoint).setImageDrawable(this.mPointFocusedDrawable);
        this.mCurrentPoint = newCurrentPoint;
    }

    private final class MyListener
    implements ViewPager.OnPageChangeListener {
        private MyListener() {
        }

        public void onPageScrollStateChanged(int state) {
            switch (state) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            if (BGABanner.this.mPointVisibility) {
                if (BGABanner.this.mAutoPlayAble) {
                    BGABanner.this.switchToPoint(position % BGABanner.this.mViews.size());
                } else {
                    BGABanner.this.switchToPoint(position);
                }
            }
        }
    }

    private final class MyAdapter
    extends PagerAdapter {
        private MyAdapter() {
        }

        public int getCount() {
            return BGABanner.this.mAutoPlayAble ? Integer.MAX_VALUE : BGABanner.this.mViews.size();
        }

        public Object instantiateItem(View container, int position) {
            if (BGABanner.this.mAutoPlayAble) {
                ((ViewPager)container).addView((View)BGABanner.this.mViews.get(position % BGABanner.this.mViews.size()));
                return BGABanner.this.mViews.get(position % BGABanner.this.mViews.size());
            }
            ((ViewPager)container).addView((View)BGABanner.this.mViews.get(position));
            return BGABanner.this.mViews.get(position);
        }

        public void destroyItem(View container, int position, Object object) {
            if (BGABanner.this.mAutoPlayAble) {
                ((ViewPager)container).removeView((View)BGABanner.this.mViews.get(position % BGABanner.this.mViews.size()));
            } else {
                ((ViewPager)container).removeView((View)BGABanner.this.mViews.get(position));
            }
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }
    }
}

