/*
 * Decompiled with CFR 0.152.
 */
package cn.leaqi.drawer;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import cn.leaqi.drawer.AnimThread;
import cn.leaqi.drawer.OnDrawerChange;
import cn.leaqi.drawer.OnDrawerState;
import cn.leaqi.drawer.OnDrawerSwitch;
import cn.leaqi.drawer.R;
import cn.leaqi.drawer.ViewUtils;

public class SwipeDrawer
extends ViewGroup {
    public static final int MODE_DRAWER = 0;
    public static final int MODE_COVER = 1;
    public static final int MODE_FIXED = 2;
    public static final int DIRECTION_ORDER = -1;
    public static final int DIRECTION_MAIN = 0;
    public static final int DIRECTION_LEFT = 1;
    public static final int DIRECTION_TOP = 2;
    public static final int DIRECTION_RIGHT = 3;
    public static final int DIRECTION_BOTTOM = 4;
    public static final int MASK_NONE = 0;
    public static final int MASK_GENERAL = 1;
    public static final int MASK_GRADUAL = 2;
    public static final int TYPE_VIEW = 0;
    public static final int TYPE_SCROLL_Y = 1;
    public static final int TYPE_SCROLL_X = 2;
    public static final int MAIN_OPEN_NONE = 0;
    public static final int MAIN_OPEN_CLICK = 1;
    public static final int MAIN_OPEN_INTERCEPT = 2;
    public static final int STATE_START = 0;
    public static final int STATE_OPEN = 1;
    public static final int STATE_CLOSE = 2;
    public static final int STATE_PROGRESS = 3;
    public static final int STATE_ANIM_OVER = 4;
    public static final int STATE_CALL_OPEN = 5;
    public static final int STATE_CALL_CLOSE = 6;
    public static final int STATE_CANCEL = 7;
    public static final int STATE_DRAG_INTO = 8;
    public static final int STATE_DRAG_OUT = 9;
    private int open = 0;
    private int mask = 0;
    private int mode = 0;
    private int leftMode = -1;
    private int topMode = -1;
    private int rightMode = -1;
    private int bottomMode = -1;
    private int lastMode = 0;
    private int mainType = 0;
    private int leftType = 0;
    private int topType = 0;
    private int rightType = 0;
    private int bottomType = 0;
    private int mainOpen = 0;
    private int parentId = -1;
    private int mainScrollId = -1;
    private int leftScrollId = -1;
    private int topScrollId = -1;
    private int rightScrollId = -1;
    private int bottomScrollId = -1;
    private int mainId = -1;
    private int leftId = -1;
    private int topId = -1;
    private int rightId = -1;
    private int bottomId = -1;
    private SwipeDrawer parentDrawer = null;
    private ViewUtils mainScroll = null;
    private ViewUtils leftScroll = null;
    private ViewUtils topScroll = null;
    private ViewUtils rightScroll = null;
    private ViewUtils bottomScroll = null;
    private ViewUtils mainLayout = null;
    private ViewUtils leftLayout = null;
    private ViewUtils topLayout = null;
    private ViewUtils rightLayout = null;
    private ViewUtils bottomLayout = null;
    private View maskView = null;
    private float shrinkRange = 5.0f;
    private int dragDamping = 10;
    private int dragRange = 0;
    private int maxDragSize = 0;
    private int duration = 200;
    private int maskColor = Integer.MIN_VALUE;
    private boolean leftDragOpen = true;
    private boolean topDragOpen = true;
    private boolean rightDragOpen = true;
    private boolean bottomDragOpen = true;
    private boolean showLayout = false;
    private boolean autoClose = false;
    private boolean maskClose = false;
    private boolean dragClose = true;
    private boolean scrollOuterDrag = false;
    private static boolean allIntercept = false;
    private static SwipeDrawer autoDrawer = null;
    private int downX = 0;
    private int downY = 0;
    private int downMs = 0;
    private boolean isInit = false;
    private boolean isFinish = false;
    private boolean isTouch = false;
    private boolean isIntercept = false;
    private boolean isShow = false;
    private boolean arriveRange = false;
    private boolean isArriveCall = false;
    private int parentIntercept = 0;
    private int inDirection = -1;
    private float lastProgress = -1.0f;
    private AnimThread animThread = null;
    private OnDrawerState onDrawerState = null;
    private OnDrawerSwitch onDrawerSwitch = null;
    private OnDrawerChange onDrawerChange = null;
    private Interpolator animInterpolator = null;

    public SwipeDrawer(Context context) {
        super(context);
        this.attrInit(context, null);
    }

    public SwipeDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.attrInit(context, attrs);
    }

    public SwipeDrawer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.attrInit(context, attrs);
    }

    private void attrInit(Context context, AttributeSet attr) {
        if (attr != null) {
            TypedArray attrArr = context.obtainStyledAttributes(attr, R.styleable.SwipeDrawer);
            this.open = attrArr.getInteger(R.styleable.SwipeDrawer_open, this.open);
            int getMode = attrArr.getInteger(R.styleable.SwipeDrawer_mode, this.mode);
            int getMask = attrArr.getInteger(R.styleable.SwipeDrawer_mask, this.mask);
            int getLeftMode = attrArr.getInteger(R.styleable.SwipeDrawer_leftMode, this.leftMode);
            int getTopMode = attrArr.getInteger(R.styleable.SwipeDrawer_topMode, this.topMode);
            int getRightMode = attrArr.getInteger(R.styleable.SwipeDrawer_rightMode, this.rightMode);
            int getBottomMode = attrArr.getInteger(R.styleable.SwipeDrawer_bottomMode, this.bottomMode);
            int getMainType = attrArr.getInteger(R.styleable.SwipeDrawer_mainType, this.mainType);
            int getLeftType = attrArr.getInteger(R.styleable.SwipeDrawer_leftType, this.leftType);
            int getTopType = attrArr.getInteger(R.styleable.SwipeDrawer_topType, this.topType);
            int getRightType = attrArr.getInteger(R.styleable.SwipeDrawer_rightType, this.rightType);
            int getBottomType = attrArr.getInteger(R.styleable.SwipeDrawer_bottomType, this.bottomType);
            int getMainOpen = attrArr.getInteger(R.styleable.SwipeDrawer_mainOpen, this.mainOpen);
            float getShrinkRange = attrArr.getFloat(R.styleable.SwipeDrawer_shrinkRange, this.shrinkRange);
            int getDragDamping = attrArr.getInteger(R.styleable.SwipeDrawer_dragDamping, this.dragDamping);
            int getDragRange = attrArr.getDimensionPixelSize(R.styleable.SwipeDrawer_dragRange, this.dragRange);
            int getMaxDragSize = attrArr.getDimensionPixelSize(R.styleable.SwipeDrawer_maxDragSize, this.maxDragSize);
            int getDuration = attrArr.getInteger(R.styleable.SwipeDrawer_duration, this.duration);
            int getMaskColor = attrArr.getColor(R.styleable.SwipeDrawer_maskColor, this.maskColor);
            int getInterpolatorId = attrArr.getResourceId(R.styleable.SwipeDrawer_interpolator, -1);
            this.leftDragOpen = attrArr.getBoolean(R.styleable.SwipeDrawer_leftDragOpen, this.leftDragOpen);
            this.topDragOpen = attrArr.getBoolean(R.styleable.SwipeDrawer_topDragOpen, this.topDragOpen);
            this.rightDragOpen = attrArr.getBoolean(R.styleable.SwipeDrawer_rightDragOpen, this.rightDragOpen);
            this.bottomDragOpen = attrArr.getBoolean(R.styleable.SwipeDrawer_bottomDragOpen, this.bottomDragOpen);
            this.showLayout = attrArr.getBoolean(R.styleable.SwipeDrawer_showLayout, this.showLayout);
            this.autoClose = attrArr.getBoolean(R.styleable.SwipeDrawer_autoClose, this.autoClose);
            this.maskClose = attrArr.getBoolean(R.styleable.SwipeDrawer_maskClose, this.maskClose);
            this.dragClose = attrArr.getBoolean(R.styleable.SwipeDrawer_dragClose, this.dragClose);
            this.scrollOuterDrag = attrArr.getBoolean(R.styleable.SwipeDrawer_scrollOuterDrag, this.scrollOuterDrag);
            this.parentId = attrArr.getResourceId(R.styleable.SwipeDrawer_parentDrawer, this.parentId);
            this.mainScrollId = attrArr.getResourceId(R.styleable.SwipeDrawer_mainScroll, this.mainScrollId);
            this.leftScrollId = attrArr.getResourceId(R.styleable.SwipeDrawer_leftScroll, this.leftScrollId);
            this.topScrollId = attrArr.getResourceId(R.styleable.SwipeDrawer_topScroll, this.topScrollId);
            this.rightScrollId = attrArr.getResourceId(R.styleable.SwipeDrawer_rightScroll, this.rightScrollId);
            this.bottomScrollId = attrArr.getResourceId(R.styleable.SwipeDrawer_bottomScroll, this.bottomScrollId);
            this.mainId = attrArr.getResourceId(R.styleable.SwipeDrawer_mainLayout, this.mainId);
            this.leftId = attrArr.getResourceId(R.styleable.SwipeDrawer_leftLayout, this.leftId);
            this.topId = attrArr.getResourceId(R.styleable.SwipeDrawer_topLayout, this.topId);
            this.rightId = attrArr.getResourceId(R.styleable.SwipeDrawer_rightLayout, this.rightId);
            this.bottomId = attrArr.getResourceId(R.styleable.SwipeDrawer_bottomLayout, this.bottomId);
            if (getMode == 0 || getMode == 1 || getMode == 2) {
                this.mode = getMode;
            }
            if (getLeftMode == 0 || getLeftMode == 1 || getLeftMode == 2) {
                this.leftMode = getLeftMode;
            }
            if (getTopMode == 0 || getTopMode == 1 || getTopMode == 2) {
                this.topMode = getTopMode;
            }
            if (getRightMode == 0 || getRightMode == 1 || getRightMode == 2) {
                this.rightMode = getRightMode;
            }
            if (getBottomMode == 0 || getBottomMode == 1 || getBottomMode == 2) {
                this.bottomMode = getBottomMode;
            }
            this.setMask(getMask);
            this.setMainType(getMainType);
            this.setLeftType(getLeftType);
            this.setTopType(getTopType);
            this.setRightType(getRightType);
            this.setBottomType(getBottomType);
            this.setMainOpen(getMainOpen);
            this.setShrinkRange(getShrinkRange);
            this.setDragDamping(getDragDamping);
            this.setDragRange(getDragRange);
            this.setMaxDragSize(getMaxDragSize);
            this.setMaskColor(getMaskColor);
            this.setDuration(getDuration);
            if (getInterpolatorId != -1) {
                this.animInterpolator = AnimationUtils.loadInterpolator((Context)this.getContext(), (int)getInterpolatorId);
            }
            attrArr.recycle();
        }
    }

    public void setMode(int type) {
        if (this.isShow) {
            return;
        }
        if (type == 0 || type == 1 || type == 2) {
            this.mode = type;
            this.checkTouch();
            this.updateLayout();
        }
    }

    public void setLeftMode(int type) {
        if (this.isShow) {
            return;
        }
        if (type == 0 || type == 1 || type == 2) {
            this.leftMode = type;
            this.checkTouch();
            this.updateLayout();
        }
    }

    public void setRightMode(int type) {
        if (this.isShow) {
            return;
        }
        if (type == 0 || type == 1 || type == 2) {
            this.rightMode = type;
            this.checkTouch();
            this.updateLayout();
        }
    }

    public void setTopMode(int type) {
        if (this.isShow) {
            return;
        }
        if (type == 0 || type == 1 || type == 2) {
            this.topMode = type;
            this.checkTouch();
            this.updateLayout();
        }
    }

    public void setBottomMode(int type) {
        if (this.isShow) {
            return;
        }
        if (type == 0 || type == 1 || type == 2) {
            this.bottomMode = type;
            this.checkTouch();
            this.updateLayout();
        }
    }

    public void setMask(int type) {
        if (type == 0 || type == 1 || type == 2) {
            this.mask = type;
            this.checkTouch();
            this.requestLayout();
        }
    }

    public void setMainType(int type) {
        if (type == 0 || type == 1 || type == 2) {
            this.mainType = type;
        }
    }

    public void setLeftType(int type) {
        if (type == 0 || type == 1 || type == 2) {
            this.leftType = type;
        }
    }

    public void setTopType(int type) {
        if (type == 0 || type == 1 || type == 2) {
            this.topType = type;
        }
    }

    public void setRightType(int type) {
        if (type == 0 || type == 1 || type == 2) {
            this.rightType = type;
        }
    }

    public void setBottomType(int type) {
        if (type == 0 || type == 1 || type == 2) {
            this.bottomType = type;
        }
    }

    public void setMainOpen(int type) {
        if (type == 0 || type == 1 || type == 2) {
            this.mainOpen = type;
        }
    }

    public void setShrinkRange(float num) {
        if (num < 0.0f) {
            num = 0.0f;
        }
        this.shrinkRange = num;
    }

    public void setDragDamping(int num) {
        if (num < 0 || num > 10) {
            num = 10;
        }
        this.dragDamping = num;
    }

    public void setDragRange(int num) {
        if (num < -1) {
            num = -1;
        }
        this.dragRange = num;
    }

    public void setMaxDragSize(int num) {
        if (num < 0) {
            num = 0;
        }
        this.maxDragSize = num;
    }

    public void setDuration(int ms) {
        if (ms < 0) {
            return;
        }
        this.duration = ms;
    }

    public void setLeftDragOpen(boolean bool) {
        this.leftDragOpen = bool;
    }

    public void setTopDragOpen(boolean bool) {
        this.topDragOpen = bool;
    }

    public void setRightDragOpen(boolean bool) {
        this.rightDragOpen = bool;
    }

    public void setBottomDragOpen(boolean bool) {
        this.bottomDragOpen = bool;
    }

    public void setShowLayout(boolean bool) {
        this.showLayout = bool;
    }

    public void setAutoClose(boolean bool) {
        this.autoClose = bool;
    }

    public void setMaskClose(boolean bool) {
        this.maskClose = bool;
    }

    public void setMaskColor(int color) {
        this.maskColor = color;
        if (this.maskView != null) {
            this.maskView.setBackgroundColor(this.maskColor);
        }
    }

    public void setDragClose(boolean bool) {
        this.dragClose = bool;
    }

    public void setScrollOuterDrag(boolean bool) {
        this.scrollOuterDrag = bool;
    }

    public void setParentDrawer(final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SwipeDrawer view = SwipeDrawer.this;
                    while ((view = view.getParent()) != null) {
                        if (!(view instanceof SwipeDrawer) || view.getId() != id) continue;
                        SwipeDrawer.this.parentDrawer = view;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void setParentDrawer(SwipeDrawer view) {
        if (view == null) {
            return;
        }
        this.parentDrawer = view;
    }

    public void setMainScroll(int id) {
        this.setMainScroll(this.findViewById(id));
    }

    public void setMainScroll(View view) {
        if (view != null) {
            this.mainScroll = new ViewUtils(view, 0, true);
            this.requestLayout();
        }
    }

    public void setLeftScroll(int id) {
        this.setLeftScroll(this.findViewById(id));
    }

    public void setLeftScroll(View view) {
        if (view != null) {
            this.leftScroll = new ViewUtils(view, 1, true);
            this.requestLayout();
        }
    }

    public void setTopScroll(int id) {
        this.setTopScroll(this.findViewById(id));
    }

    public void setTopScroll(View view) {
        if (view != null) {
            this.topScroll = new ViewUtils(view, 2, true);
            this.requestLayout();
        }
    }

    public void setRightScroll(int id) {
        this.setRightScroll(this.findViewById(id));
    }

    public void setRightScroll(View view) {
        if (view != null) {
            this.rightScroll = new ViewUtils(view, 3, true);
            this.requestLayout();
        }
    }

    public void setBottomScroll(int id) {
        this.setBottomScroll(this.findViewById(id));
    }

    public void setBottomScroll(View view) {
        if (view != null) {
            this.bottomScroll = new ViewUtils(view, 4, true);
            this.requestLayout();
        }
    }

    public void setMainLayout(int id) {
        this.setMainLayout(this.findViewById(id));
    }

    public void setMainLayout(View view) {
        if (this.isShow) {
            return;
        }
        if (view != null) {
            this.mainLayout = new ViewUtils(view, 0, true);
            this.checkTouch();
            this.requestLayout();
        }
    }

    public void setLeftLayout(int id) {
        this.setLeftLayout(this.findViewById(id));
    }

    public void setLeftLayout(View view) {
        if (this.isShow) {
            return;
        }
        if (view != null) {
            this.leftLayout = new ViewUtils(view, 1, true);
            this.checkTouch();
            this.requestLayout();
        }
    }

    public void setTopLayout(int id) {
        this.setTopLayout(this.findViewById(id));
    }

    public void setTopLayout(View view) {
        if (this.isShow) {
            return;
        }
        if (view != null) {
            this.topLayout = new ViewUtils(view, 2, true);
            this.checkTouch();
            this.requestLayout();
        }
    }

    public void setRightLayout(int id) {
        this.setRightLayout(this.findViewById(id));
    }

    public void setRightLayout(View view) {
        if (this.isShow) {
            return;
        }
        if (view != null) {
            this.rightLayout = new ViewUtils(view, 3, true);
            this.checkTouch();
            this.requestLayout();
        }
    }

    public void setBottomLayout(int id) {
        this.setBottomLayout(this.findViewById(id));
    }

    public void setBottomLayout(View view) {
        if (this.isShow) {
            return;
        }
        if (view != null) {
            this.bottomLayout = new ViewUtils(view, 4, true);
            this.checkTouch();
            this.requestLayout();
        }
    }

    public void setMainScale(float scale) {
        if (this.isTouch) {
            this.mainLayout.setScale(scale);
        }
    }

    public void setMainRotation(float rotation) {
        if (this.isTouch) {
            this.mainLayout.setRotation(rotation);
        }
    }

    public boolean setIntercept(boolean intercept) {
        return this.setIntercept(1, intercept) || this.setIntercept(2, intercept) || this.setIntercept(3, intercept) || this.setIntercept(4, intercept);
    }

    public boolean setIntercept(View view, boolean intercept) {
        int type = this.getDirection(view);
        return this.setIntercept(type, intercept);
    }

    public boolean setIntercept(int type, boolean intercept) {
        ViewUtils utils = this.getViewUtils(type);
        if (utils != null) {
            utils.intercept = intercept;
        }
        return utils != null;
    }

    public void setOnDrawerState(OnDrawerState listener) {
        this.onDrawerState = listener;
    }

    public void setOnDrawerSwitch(OnDrawerSwitch listener) {
        this.onDrawerSwitch = listener;
    }

    public void setOnDrawerChange(OnDrawerChange listener) {
        this.onDrawerChange = listener;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.animInterpolator = interpolator;
    }

    public static void setAllIntercept(boolean bool) {
        allIntercept = bool;
    }

    public static boolean getAllIntercept() {
        return allIntercept;
    }

    public static SwipeDrawer getParentDrawer(View view) {
        try {
            if (view != null) {
                for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof SwipeDrawer)) continue;
                    return (SwipeDrawer)parent;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public int getMode() {
        return this.mode;
    }

    public int getLeftMode() {
        return this.leftMode;
    }

    public int getTopMode() {
        return this.topMode;
    }

    public int getRightMode() {
        return this.rightMode;
    }

    public int getBottomMode() {
        return this.bottomMode;
    }

    public int getMask() {
        return this.mask;
    }

    public View getMaskView() {
        return this.maskView;
    }

    public View getMainView() {
        return this.mainLayout == null ? null : this.mainLayout.view;
    }

    public View getLeftView() {
        return this.leftLayout == null ? null : this.leftLayout.view;
    }

    public View getTopView() {
        return this.topLayout == null ? null : this.topLayout.view;
    }

    public View getRightView() {
        return this.rightLayout == null ? null : this.rightLayout.view;
    }

    public View getBottomView() {
        return this.bottomLayout == null ? null : this.bottomLayout.view;
    }

    public int getMainType() {
        return this.mainType;
    }

    public int getLeftType() {
        return this.leftType;
    }

    public int getTopType() {
        return this.topType;
    }

    public int getRightType() {
        return this.rightType;
    }

    public int getBottomType() {
        return this.bottomType;
    }

    public int getMainOpen() {
        return this.mainOpen;
    }

    public float getShrinkRange() {
        return this.shrinkRange;
    }

    public int getDragDamping() {
        return this.dragDamping;
    }

    public int getDragRange() {
        return this.dragRange;
    }

    public int getMaxDragSize() {
        return this.maxDragSize;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean getLeftDragOpen() {
        return this.leftDragOpen;
    }

    public boolean getTopDragOpen() {
        return this.topDragOpen;
    }

    public boolean getRightDragOpen() {
        return this.rightDragOpen;
    }

    public boolean getBottomDragOpen() {
        return this.bottomDragOpen;
    }

    public boolean getShowLayout() {
        return this.showLayout;
    }

    public boolean getAutoClose() {
        return this.autoClose;
    }

    public boolean getMaskClose() {
        return this.maskClose;
    }

    public boolean getScrollOuterDrag() {
        return this.scrollOuterDrag;
    }

    public boolean getIntercept() {
        return this.isIntercept;
    }

    public boolean getShow() {
        return this.isShow;
    }

    public boolean getArriveRange() {
        return this.arriveRange;
    }

    public int getDirection() {
        return this.inDirection;
    }

    public int getMaskColor() {
        return this.maskColor;
    }

    public int getDirection(View view) {
        if (this.mainLayout != null && view == this.mainLayout.view) {
            return 0;
        }
        if (this.leftLayout != null && view == this.leftLayout.view) {
            return 1;
        }
        if (this.topLayout != null && view == this.topLayout.view) {
            return 2;
        }
        if (this.rightLayout != null && view == this.rightLayout.view) {
            return 3;
        }
        if (this.bottomLayout != null && view == this.bottomLayout.view) {
            return 4;
        }
        return -1;
    }

    public int getDirectionMode(int type) {
        if (type == 1 && this.leftMode != -1) {
            return this.leftMode;
        }
        if (type == 2 && this.topMode != -1) {
            return this.topMode;
        }
        if (type == 3 && this.rightMode != -1) {
            return this.rightMode;
        }
        if (type == 4 && this.bottomMode != -1) {
            return this.bottomMode;
        }
        return this.mode;
    }

    public ViewUtils getViewUtils(int type) {
        if (type == 0 && this.mainLayout != null) {
            return this.mainLayout;
        }
        if (type == 1 && this.leftLayout != null) {
            return this.leftLayout;
        }
        if (type == 2 && this.topLayout != null) {
            return this.topLayout;
        }
        if (type == 3 && this.rightLayout != null) {
            return this.rightLayout;
        }
        if (type == 4 && this.bottomLayout != null) {
            return this.bottomLayout;
        }
        return null;
    }

    public ViewUtils getScrollUtils(int type) {
        if (type == 0 && this.mainScroll != null) {
            return this.mainScroll;
        }
        if (type == 1 && this.leftScroll != null) {
            return this.leftScroll;
        }
        if (type == 2 && this.topScroll != null) {
            return this.topScroll;
        }
        if (type == 3 && this.rightScroll != null) {
            return this.rightScroll;
        }
        if (type == 4 && this.bottomScroll != null) {
            return this.bottomScroll;
        }
        return null;
    }

    public void openDrawer(int type) {
        this.openDrawer(type, true, true);
    }

    public void openDrawer(int type, boolean anim) {
        this.openDrawer(type, anim, true);
    }

    public void openDrawer(int type, boolean anim, boolean call) {
        if (this.isShow || AnimThread.isThread(this.animThread)) {
            return;
        }
        ViewUtils viewUtils = this.getViewUtils(type);
        if (viewUtils != null) {
            if (!this.isInit) {
                this.open = type;
                return;
            }
            this.inDirection = type;
            if (this.getDirectionMode(this.inDirection) == 1) {
                this.mainLayout.setFront();
                this.requestMask(true);
                viewUtils.setFront();
            } else {
                viewUtils.setFront();
                this.requestMask(true);
                this.mainLayout.setFront();
            }
            this.isShow = true;
            if (this.onDrawerChange != null) {
                this.onDrawerChange.onChange(this, 5, 0.0f);
            }
            this.checkView();
            this.animRecovery(true, anim, call);
            if (call) {
                this.onOpen();
            }
            if (this.mask == 1) {
                this.progressMask(1.0f);
            }
        }
    }

    public void closeDrawer() {
        this.closeDrawer(this.inDirection, true, true);
    }

    public void closeDrawer(boolean anim) {
        this.closeDrawer(this.inDirection, anim, true);
    }

    public void closeDrawer(boolean anim, boolean call) {
        this.closeDrawer(this.inDirection, anim, call);
    }

    public void closeDrawer(int type) {
        this.closeDrawer(type, true, true);
    }

    public void closeDrawer(int type, boolean anim) {
        this.closeDrawer(type, anim, true);
    }

    public void closeDrawer(int type, boolean anim, boolean call) {
        if (!this.isShow || type != this.inDirection || AnimThread.isThread(this.animThread)) {
            return;
        }
        ViewUtils viewUtils = this.getViewUtils(type);
        if (viewUtils != null) {
            this.inDirection = type;
            this.isShow = false;
            if (this.onDrawerChange != null) {
                this.onDrawerChange.onChange(this, 6, 0.0f);
            }
            this.checkView();
            this.animRecovery(false, anim, call);
            if (call) {
                this.onClose();
            }
            if (this.mask == 1) {
                this.progressMask(0.0f);
            }
        }
    }

    public void forceClose(boolean anim) {
        this.forceClose(anim, true);
    }

    public void forceClose(boolean anim, boolean call) {
        if (this.isShow) {
            if (AnimThread.isThread(this.animThread)) {
                this.animThread.setStop();
                this.animThread.setAlive();
            }
            this.isShow = false;
            if (this.onDrawerChange != null) {
                this.onDrawerChange.onChange(this, 6, 0.0f);
            }
            this.checkView();
            this.animRecovery(false, anim, call);
            if (call) {
                this.onClose();
            }
            if (this.mask == 1) {
                this.progressMask(0.0f);
            }
        }
    }

    public void toggleDrawer(int type) {
        this.toggleDrawer(type, true, true);
    }

    public void toggleDrawer(int type, boolean anim) {
        this.toggleDrawer(type, anim, true);
    }

    public void toggleDrawer(int type, boolean anim, boolean call) {
        if (this.isShow) {
            this.closeDrawer(type, anim, call);
        } else {
            this.openDrawer(type, anim, call);
        }
    }

    public void updateLayout() {
        this.lastMode = 0;
        this.requestLayout();
    }

    public void updateSize(boolean isAll) {
        if (this.mainScroll != null) {
            this.mainScroll.Update(isAll);
        }
        if (this.leftScroll != null) {
            this.leftScroll.Update(isAll);
        }
        if (this.topScroll != null) {
            this.topScroll.Update(isAll);
        }
        if (this.rightScroll != null) {
            this.rightScroll.Update(isAll);
        }
        if (this.bottomScroll != null) {
            this.bottomScroll.Update(isAll);
        }
        if (this.mainLayout != null) {
            this.mainLayout.Update(isAll);
        }
        if (this.leftLayout != null) {
            this.leftLayout.Update(isAll);
        }
        if (this.topLayout != null) {
            this.topLayout.Update(isAll);
        }
        if (this.rightLayout != null) {
            this.rightLayout.Update(isAll);
        }
        if (this.bottomLayout != null) {
            this.bottomLayout.Update(isAll);
        }
    }

    private void setParentIntercept(int intercept, boolean isAll) {
        try {
            if (this.parentDrawer != null) {
                SwipeDrawer view = this.parentDrawer;
                view.parentIntercept = intercept;
                if (isAll) {
                    while ((view = view.parentDrawer) != null) {
                        view.parentIntercept = intercept;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void progressMask(float alpha) {
        if (this.maskView != null) {
            this.maskView.setAlpha(alpha);
        }
    }

    private void requestMask(boolean bool) {
        if (this.maskView != null) {
            if (bool) {
                this.maskView.bringToFront();
                this.maskView.setVisibility(0);
            } else {
                this.maskView.setAlpha(0.0f);
                this.maskView.setVisibility(8);
            }
        }
    }

    private void requestIntercept() {
        try {
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int[] getLocation() {
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        return location;
    }

    private boolean isScrollType(int type) {
        ViewUtils viewUtils;
        boolean isLeft = type == 1;
        boolean isTop = type == 2;
        boolean isRight = type == 3;
        boolean isBottom = type == 4;
        boolean bool = true;
        if (this.isShow) {
            viewUtils = this.getScrollUtils(type);
            if (viewUtils != null) {
                if (isTop && !viewUtils.isScrollBottom()) {
                    bool = false;
                }
                if (isBottom && !viewUtils.isScrollTop()) {
                    bool = false;
                }
                if (isLeft && !viewUtils.isScrollRight()) {
                    bool = false;
                }
                if (isRight && !viewUtils.isScrollLeft()) {
                    bool = false;
                }
            } else {
                int setType = 0;
                if (isTop) {
                    setType = this.topType;
                }
                if (isBottom) {
                    setType = this.bottomType;
                }
                if (isLeft) {
                    setType = this.leftType;
                }
                if (isRight) {
                    setType = this.rightType;
                }
                if ((viewUtils = this.getViewUtils(type)) != null) {
                    if (setType == 1) {
                        if (isTop && !viewUtils.isScrollBottom()) {
                            bool = false;
                        }
                        if (isBottom && !viewUtils.isScrollTop()) {
                            bool = false;
                        }
                    } else if (setType == 2) {
                        if (isLeft && !viewUtils.isScrollRight()) {
                            bool = false;
                        }
                        if (isRight && !viewUtils.isScrollLeft()) {
                            bool = false;
                        }
                    }
                }
            }
        } else {
            viewUtils = this.getScrollUtils(0);
            if (viewUtils != null) {
                if (isTop && !viewUtils.isScrollTop()) {
                    bool = false;
                }
                if (isBottom && !viewUtils.isScrollBottom()) {
                    bool = false;
                }
                if (isLeft && !viewUtils.isScrollLeft()) {
                    bool = false;
                }
                if (isRight && !viewUtils.isScrollRight()) {
                    bool = false;
                }
            } else {
                viewUtils = this.getViewUtils(0);
                if (this.mainType == 1) {
                    if (isTop && !viewUtils.isScrollTop()) {
                        bool = false;
                    }
                    if (isBottom && !viewUtils.isScrollBottom()) {
                        bool = false;
                    }
                } else if (this.mainType == 2) {
                    if (isLeft && !viewUtils.isScrollLeft()) {
                        bool = false;
                    }
                    if (isRight && !viewUtils.isScrollRight()) {
                        bool = false;
                    }
                }
            }
        }
        if (viewUtils != null && this.scrollOuterDrag && !viewUtils.isActionDown(this.downX, this.downY, this.getLocation())) {
            bool = true;
        }
        return bool;
    }

    private ViewUtils getIntercept(int shiftX, int shiftY) {
        if (this.leftLayout != null && (this.isShow && this.inDirection == 1 && shiftX < 0 && Math.abs(shiftX) > Math.abs(shiftY) || !this.isShow && this.leftDragOpen && shiftX > Math.abs(shiftY)) && this.leftLayout.intercept && this.isScrollType(1) && (this.isShow || this.dragRange == 0 || this.dragRange >= this.downX)) {
            return this.leftLayout;
        }
        if (this.rightLayout != null && (!this.isShow && this.rightDragOpen && shiftX < 0 && Math.abs(shiftX) > Math.abs(shiftY) || this.isShow && this.inDirection == 3 && shiftX > Math.abs(shiftY)) && this.rightLayout.intercept && this.isScrollType(3) && (this.isShow || this.dragRange == 0 || this.dragRange >= this.mainLayout.width - this.downX)) {
            return this.rightLayout;
        }
        if (this.topLayout != null && (this.isShow && this.inDirection == 2 && shiftY < 0 && Math.abs(shiftY) > Math.abs(shiftX) || !this.isShow && this.topDragOpen && shiftY > Math.abs(shiftX)) && this.topLayout.intercept && this.isScrollType(2) && (this.isShow || this.dragRange == 0 || this.dragRange >= this.downY)) {
            return this.topLayout;
        }
        if (this.bottomLayout != null && (!this.isShow && this.bottomDragOpen && shiftY < 0 && Math.abs(shiftY) > Math.abs(shiftX) || this.isShow && this.inDirection == 4 && shiftY > Math.abs(shiftX)) && this.bottomLayout.intercept && this.isScrollType(4) && (this.isShow || this.dragRange == 0 || this.dragRange >= this.mainLayout.height - this.downY)) {
            return this.bottomLayout;
        }
        this.setParentIntercept(0, false);
        return null;
    }

    private void animRecovery(boolean bool, boolean anim, final boolean call) {
        int oldNum;
        boolean isBottom;
        if (!this.isTouch) {
            return;
        }
        final ViewUtils viewUtils = this.getViewUtils(this.inDirection);
        if (viewUtils == null) {
            return;
        }
        int getMode = this.getDirectionMode(this.inDirection);
        final boolean isDrawer = getMode == 0;
        final boolean isFixed = getMode == 2;
        final boolean isCover = getMode == 1;
        final boolean isLeft = this.inDirection == 1;
        final boolean isTop = this.inDirection == 2;
        final boolean isRight = this.inDirection == 3;
        boolean bl = isBottom = this.inDirection == 4;
        int setNum = isLeft || isRight ? (isLeft ? this.leftLayout.width : -this.rightLayout.width) : (isTop ? this.topLayout.height : -this.bottomLayout.height);
        int n = oldNum = isLeft || isRight ? this.mainLayout.left : this.mainLayout.top;
        if (isCover) {
            if (isLeft) {
                oldNum = viewUtils.width + viewUtils.left;
            }
            if (isRight) {
                oldNum = viewUtils.left - this.mainLayout.width;
            }
            if (isTop) {
                oldNum = viewUtils.height + viewUtils.top;
            }
            if (isBottom) {
                oldNum = viewUtils.top - this.mainLayout.height;
            }
        }
        final int oldValue = oldNum;
        final int setValue = (bool ? setNum : 0) - oldValue;
        this.isIntercept = false;
        if (anim && this.duration > 0) {
            this.animThread = new AnimThread(this.duration, this.animInterpolator){

                @Override
                protected void onUpdate(final float value) {
                    SwipeDrawer.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (this.getStop()) {
                                return;
                            }
                            int newValue = (int)Math.ceil((float)setValue * value);
                            if (isLeft || isRight) {
                                if (isDrawer || isFixed) {
                                    SwipeDrawer.this.mainLayout.setLeft(oldValue + newValue);
                                }
                                if (isDrawer || isCover) {
                                    viewUtils.setLeft(oldValue + newValue + (isLeft ? -viewUtils.width : ((SwipeDrawer)SwipeDrawer.this).mainLayout.width));
                                }
                            } else if (isTop || isBottom) {
                                if (isDrawer || isFixed) {
                                    SwipeDrawer.this.mainLayout.setTop(oldValue + newValue);
                                }
                                if (isDrawer || isCover) {
                                    viewUtils.setTop(oldValue + newValue + (isTop ? -viewUtils.height : ((SwipeDrawer)SwipeDrawer.this).mainLayout.height));
                                }
                            }
                            float progress = (float)Math.abs(oldValue + newValue) / (float)(isLeft || isRight ? viewUtils.width : viewUtils.height);
                            if (SwipeDrawer.this.lastProgress != progress) {
                                if (SwipeDrawer.this.onDrawerState != null && call) {
                                    SwipeDrawer.this.onDrawerState.onMove(SwipeDrawer.this.inDirection, progress);
                                }
                                if (SwipeDrawer.this.onDrawerChange != null && call) {
                                    SwipeDrawer.this.onDrawerChange.onChange(SwipeDrawer.this, 3, progress);
                                }
                                SwipeDrawer.this.lastProgress = progress;
                            }
                            if (SwipeDrawer.this.mask == 2) {
                                SwipeDrawer.this.progressMask(progress);
                            }
                            if (value >= 1.0f) {
                                this.setStop();
                                this.setAlive();
                                if (!SwipeDrawer.this.isShow) {
                                    SwipeDrawer.this.requestMask(false);
                                }
                                if (SwipeDrawer.this.onDrawerChange != null && call) {
                                    SwipeDrawer.this.onDrawerChange.onChange(SwipeDrawer.this, 4, 0.0f);
                                }
                            }
                        }
                    });
                }
            };
        } else {
            if (AnimThread.isThread(this.animThread)) {
                this.animThread.setStop();
                this.animThread.setAlive();
            }
            if (isLeft || isRight) {
                if (isDrawer || isFixed) {
                    this.mainLayout.setLeft(oldValue + setValue);
                }
                if (isDrawer || isCover) {
                    viewUtils.setLeft(oldValue + setValue + (isLeft ? -viewUtils.width : this.mainLayout.width));
                }
            } else if (isTop || isBottom) {
                if (isDrawer || isFixed) {
                    this.mainLayout.setTop(oldValue + setValue);
                }
                if (isDrawer || isCover) {
                    viewUtils.setTop(oldValue + setValue + (isTop ? -viewUtils.height : this.mainLayout.height));
                }
            }
            this.progressMask(this.isShow ? 1.0f : 0.0f);
            if (!this.isShow) {
                this.requestMask(false);
            }
            if (this.onDrawerChange != null && call) {
                this.onDrawerChange.onChange(this, 4, 0.0f);
            }
        }
        if (this.isShow && this.autoClose) {
            autoDrawer = this;
        }
    }

    private void onOpen() {
        if (this.isShow) {
            if (this.onDrawerState != null) {
                this.onDrawerState.onOpen(this.inDirection);
            }
            if (this.onDrawerSwitch != null) {
                this.onDrawerSwitch.onOpen(this);
            }
            if (this.onDrawerChange != null) {
                this.onDrawerChange.onChange(this, 1, 0.0f);
            }
        }
    }

    private void onClose() {
        if (!this.isShow) {
            if (this.onDrawerState != null) {
                this.onDrawerState.onClose(this.inDirection);
            }
            if (this.onDrawerSwitch != null) {
                this.onDrawerSwitch.onClose(this);
            }
            if (this.onDrawerChange != null) {
                this.onDrawerChange.onChange(this, 2, 0.0f);
            }
        }
    }

    private void cacheDrawer(boolean anim) {
        try {
            if (this.autoClose && autoDrawer != null && autoDrawer != this) {
                autoDrawer.forceClose(anim);
                autoDrawer = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkView() {
        if (this.showLayout) {
            return;
        }
        if (this.leftLayout != null) {
            this.leftLayout.setVisibility(this.inDirection == this.leftLayout.type);
        }
        if (this.topLayout != null) {
            this.topLayout.setVisibility(this.inDirection == this.topLayout.type);
        }
        if (this.rightLayout != null) {
            this.rightLayout.setVisibility(this.inDirection == this.rightLayout.type);
        }
        if (this.bottomLayout != null) {
            this.bottomLayout.setVisibility(this.inDirection == this.bottomLayout.type);
        }
    }

    private void checkMask() {
        if (this.mask != 0) {
            if (this.maskView == null) {
                View view = null;
                try {
                    view = new View(this.getContext());
                    view.setAlpha(0.0f);
                    view.setVisibility(8);
                    view.setBackgroundColor(this.maskColor);
                    this.addView(view, new ViewGroup.LayoutParams(-1, -1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (view != null) {
                    this.maskView = view;
                }
            }
        } else if (this.maskView != null) {
            this.removeView(this.maskView);
            this.maskView = null;
            this.mainLayout.setMask(null);
        }
    }

    private void checkTouch() {
        if (this.isFinish) {
            this.checkMask();
            this.checkView();
            boolean bl = this.isTouch = this.mainLayout != null && (this.leftLayout != null || this.topLayout != null || this.rightLayout != null || this.bottomLayout != null);
            if (this.isTouch) {
                this.mainLayout.setFront();
                if (this.maskView != null) {
                    this.mainLayout.setMask(this.maskView);
                    this.maskView.setLayoutParams(this.mainLayout.view.getLayoutParams());
                }
            }
        }
    }

    private boolean checkIntercept(MotionEvent ev) {
        ViewUtils showUtils;
        if (this.isIntercept) {
            return false;
        }
        if (AnimThread.isThread(this.animThread)) {
            return true;
        }
        if (!this.isShow && this.dragRange == -1) {
            this.setParentIntercept(0, false);
            return false;
        }
        int getX = (int)ev.getX();
        int getY = (int)ev.getY();
        int shiftX = getX - this.downX;
        int shiftY = getY - this.downY;
        ViewUtils viewUtils = this.getIntercept(shiftX, shiftY);
        if (this.isShow && (this.mainOpen == 1 || this.mainOpen == 2) && (showUtils = this.getViewUtils(this.inDirection)) != null && viewUtils == null) {
            if (this.maskView != null) {
                this.requestIntercept();
                return false;
            }
            if (!showUtils.isActionDown(this.downX, this.downY, this.getLocation())) {
                return true;
            }
        }
        if (!this.isIntercept && !AnimThread.isThread(this.animThread) && viewUtils != null) {
            this.downX = getX;
            this.downY = getY;
            this.isIntercept = true;
            this.inDirection = viewUtils.type;
            this.checkView();
            if (this.getDirectionMode(this.inDirection) == 1) {
                this.mainLayout.setFront();
                this.requestMask(true);
                viewUtils.setFront();
            } else {
                viewUtils.setFront();
                this.requestMask(true);
                this.mainLayout.setFront();
            }
            if (this.onDrawerState != null) {
                this.onDrawerState.onStart(this.inDirection);
            }
            if (this.onDrawerChange != null) {
                this.onDrawerChange.onChange(this, 0, 0.0f);
            }
            this.requestIntercept();
        }
        return false;
    }

    private void checkRange(ViewUtils viewUtils, boolean isCover, boolean isLeft, boolean isRight, boolean isTop, boolean isBottom) {
        if (this.shrinkRange == 0.0f) {
            this.arriveRange = false;
        } else {
            int viewSize = isLeft || isRight ? viewUtils.width : viewUtils.height;
            int mainSize = Math.abs(isLeft || isRight ? this.mainLayout.left : this.mainLayout.top);
            if (isCover) {
                if (isLeft) {
                    mainSize = viewUtils.width + viewUtils.left;
                }
                if (isRight) {
                    mainSize = this.mainLayout.width - viewUtils.left;
                }
                if (isTop) {
                    mainSize = viewUtils.height + viewUtils.top;
                }
                if (isBottom) {
                    mainSize = this.mainLayout.height - viewUtils.top;
                }
            }
            if (this.isShow) {
                mainSize = viewSize - mainSize;
            }
            this.arriveRange = mainSize >= Math.round((float)viewSize / this.shrinkRange);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setClickable(true);
        if (this.getChildCount() > 1) {
            View view;
            if (this.mainScrollId != -1 && (view = this.findViewById(this.mainScrollId)) != null) {
                this.mainScroll = new ViewUtils(view, 0);
            }
            if (this.leftScrollId != -1 && (view = this.findViewById(this.leftScrollId)) != null) {
                this.leftScroll = new ViewUtils(view, 1);
            }
            if (this.topScrollId != -1 && (view = this.findViewById(this.topScrollId)) != null) {
                this.topScroll = new ViewUtils(view, 2);
            }
            if (this.rightScrollId != -1 && (view = this.findViewById(this.rightScrollId)) != null) {
                this.rightScroll = new ViewUtils(view, 3);
            }
            if (this.bottomScrollId != -1 && (view = this.findViewById(this.bottomScrollId)) != null) {
                this.bottomScroll = new ViewUtils(view, 4);
            }
            if (this.mainId != -1 && (view = this.findViewById(this.mainId)) != null) {
                this.mainLayout = new ViewUtils(view, 0);
            }
            if (this.leftId != -1 && (view = this.findViewById(this.leftId)) != null) {
                this.leftLayout = new ViewUtils(view, 1);
            }
            if (this.topId != -1 && (view = this.findViewById(this.topId)) != null) {
                this.topLayout = new ViewUtils(view, 2);
            }
            if (this.rightId != -1 && (view = this.findViewById(this.rightId)) != null) {
                this.rightLayout = new ViewUtils(view, 3);
            }
            if (this.bottomId != -1 && (view = this.findViewById(this.bottomId)) != null) {
                this.bottomLayout = new ViewUtils(view, 4);
            }
            if (this.mainLayout == null) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    if (this.getDirection(child) != -1 || child == this.maskView) continue;
                    this.mainLayout = new ViewUtils(child, 0);
                    break;
                }
            }
            this.isFinish = true;
            this.checkTouch();
        }
    }

    public boolean canScrollVertically(int direction) {
        if (direction == -1) {
            if (this.topLayout == null) {
                return false;
            }
            return !this.isShow || this.inDirection == 4;
        }
        if (direction == 1) {
            if (this.bottomLayout == null) {
                return false;
            }
            return !this.isShow || this.inDirection == 2;
        }
        return super.canScrollVertically(direction);
    }

    public boolean canScrollHorizontally(int direction) {
        if (direction == -1) {
            if (this.leftLayout == null) {
                return false;
            }
            return !this.isShow || this.inDirection == 3;
        }
        if (direction == 1) {
            if (this.rightLayout == null) {
                return false;
            }
            return !this.isShow || this.inDirection == 1;
        }
        return super.canScrollHorizontally(direction);
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isTouch || !this.dragClose && this.isShow || this.parentIntercept == 1 && !this.isShow || this.parentIntercept == 2 || allIntercept) {
            return super.onInterceptTouchEvent(ev);
        }
        int getX = (int)ev.getX();
        int getY = (int)ev.getY();
        int getMs = (int)ev.getEventTime();
        switch (ev.getAction()) {
            case 0: {
                this.downX = getX;
                this.downY = getY;
                this.downMs = getMs;
                this.cacheDrawer(true);
                this.setParentIntercept(1, true);
                if (!this.isShow || this.mainOpen != 2) break;
                if (this.maskView != null) {
                    this.requestIntercept();
                    this.setParentIntercept(2, true);
                    break;
                }
                ViewUtils showUtils = this.getViewUtils(this.inDirection);
                if (showUtils == null || showUtils.isActionDown(this.downX, this.downY, this.getLocation())) break;
                return true;
            }
            case 2: {
                if (!this.checkIntercept(ev)) break;
                this.requestIntercept();
                return true;
            }
            case 1: 
            case 3: {
                int getMoveX = Math.abs(getX - this.downX);
                int getMoveY = Math.abs(getY - this.downY);
                if (!this.isIntercept && getMs - this.downMs < ViewConfiguration.getLongPressTimeout() && getMoveX < 3 && getMoveY < 3) {
                    ViewUtils showUtils;
                    boolean isClose = false;
                    if (this.isShow && this.maskClose && this.maskView != null && (showUtils = this.getViewUtils(this.inDirection)) != null && !showUtils.isActionDown(this.downX, this.downY, this.getLocation())) {
                        this.closeDrawer();
                        isClose = true;
                    }
                    if (!isClose) {
                        this.performClick();
                    }
                }
                this.isIntercept = false;
                this.setParentIntercept(0, true);
            }
        }
        return this.isIntercept;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isTouch || !this.dragClose && this.isShow || this.parentIntercept == 1 && !this.isShow || this.parentIntercept == 2 || allIntercept) {
            return super.onTouchEvent(ev);
        }
        int getX = (int)ev.getX();
        int getY = (int)ev.getY();
        int getMs = (int)ev.getEventTime();
        int getMode = this.getDirectionMode(this.inDirection);
        boolean isDrawer = getMode == 0;
        boolean isFixed = getMode == 2;
        boolean isCover = getMode == 1;
        boolean isLeft = this.inDirection == 1;
        boolean isTop = this.inDirection == 2;
        boolean isRight = this.inDirection == 3;
        boolean isBottom = this.inDirection == 4;
        switch (ev.getAction()) {
            case 2: {
                int newSize;
                if (this.checkIntercept(ev)) {
                    this.requestIntercept();
                    return true;
                }
                if (!this.isIntercept) break;
                int shiftX = getX - this.downX;
                int shiftY = getY - this.downY;
                ViewUtils viewUtils = this.getViewUtils(this.inDirection);
                if (viewUtils == null) break;
                int moveSize = isLeft || isRight ? shiftX : shiftY;
                int viewSize = isLeft || isRight ? viewUtils.width : viewUtils.height;
                int mainSize = isLeft || isRight ? this.mainLayout.width : this.mainLayout.height;
                int n = newSize = this.maxDragSize > 0 && !this.isShow ? this.maxDragSize : viewSize;
                if (this.dragDamping > 0 && this.dragDamping < 10) {
                    moveSize = (int)((float)moveSize * ((float)this.dragDamping / 10.0f));
                }
                if ((isLeft || isTop) && (this.isShow && moveSize > 0 || !this.isShow && moveSize < 0) || (isRight || isBottom) && (this.isShow && moveSize < 0 || !this.isShow && moveSize > 0)) {
                    moveSize = 0;
                }
                if (Math.abs(moveSize) > newSize) {
                    int n2 = moveSize = this.isShow && (isLeft || isTop) || !this.isShow && (isRight || isBottom) ? -newSize : newSize;
                }
                if (this.isShow) {
                    if (isLeft || isRight) {
                        if (isDrawer || isFixed) {
                            this.mainLayout.setRight(moveSize + mainSize + (isLeft ? viewSize : -viewSize));
                        }
                        if (isDrawer || isCover) {
                            viewUtils.setRight(moveSize + (isLeft ? viewSize : mainSize));
                        }
                    } else if (isTop || isBottom) {
                        if (isDrawer || isFixed) {
                            this.mainLayout.setBottom(moveSize + mainSize + (isTop ? viewSize : -viewSize));
                        }
                        if (isDrawer || isCover) {
                            viewUtils.setBottom(moveSize + (isTop ? viewSize : mainSize));
                        }
                    }
                } else if (isLeft || isRight) {
                    if (isDrawer || isFixed) {
                        this.mainLayout.setLeft(moveSize);
                    }
                    if (isDrawer || isCover) {
                        viewUtils.setLeft(moveSize + (isLeft ? -viewSize : mainSize));
                    }
                } else if (isTop || isBottom) {
                    if (isDrawer || isFixed) {
                        this.mainLayout.setTop(moveSize);
                    }
                    if (isDrawer || isCover) {
                        viewUtils.setTop(moveSize + (isTop ? -viewSize : mainSize));
                    }
                }
                this.checkRange(viewUtils, isCover, isLeft, isRight, isTop, isBottom);
                float progress = (float)Math.abs(moveSize) / (float)(isLeft || isRight ? viewUtils.width : viewUtils.height);
                if (this.lastProgress != progress) {
                    if (this.onDrawerState != null) {
                        this.onDrawerState.onMove(this.inDirection, this.isShow ? 1.0f - progress : progress);
                    }
                    if (this.onDrawerChange != null) {
                        this.onDrawerChange.onChange(this, 3, this.isShow ? 1.0f - progress : progress);
                    }
                    this.lastProgress = progress;
                }
                if (this.onDrawerChange != null) {
                    if (this.arriveRange) {
                        if (!this.isArriveCall) {
                            this.onDrawerChange.onChange(this, 8, 0.0f);
                            this.isArriveCall = true;
                        }
                    } else if (this.isArriveCall) {
                        this.onDrawerChange.onChange(this, 9, 0.0f);
                        this.isArriveCall = false;
                    }
                }
                if (this.mask == 2) {
                    this.progressMask(this.isShow ? 1.0f - progress : progress);
                }
                this.requestIntercept();
                break;
            }
            case 1: 
            case 3: {
                if (this.isIntercept) {
                    ViewUtils viewUtils = this.getViewUtils(this.inDirection);
                    if (viewUtils != null) {
                        this.checkRange(viewUtils, isCover, isLeft, isRight, isTop, isBottom);
                        if (this.shrinkRange == 0.0f) {
                            this.animRecovery(this.isShow, true, true);
                            if (this.onDrawerState != null) {
                                this.onDrawerState.onCancel(this.inDirection);
                            }
                            if (this.onDrawerChange != null) {
                                this.onDrawerChange.onChange(this, 7, 0.0f);
                            }
                        } else if (this.arriveRange) {
                            this.isShow = !this.isShow;
                            this.animRecovery(this.isShow, true, true);
                            if (this.isShow) {
                                this.onOpen();
                            } else {
                                this.onClose();
                            }
                            if (this.mask == 1) {
                                this.progressMask(this.isShow ? 1.0f : 0.0f);
                            }
                        } else {
                            this.animRecovery(this.isShow, true, true);
                            if (this.onDrawerState != null) {
                                this.onDrawerState.onCancel(this.inDirection);
                            }
                            if (this.onDrawerChange != null) {
                                this.onDrawerChange.onChange(this, 7, 0.0f);
                            }
                        }
                    }
                    this.isIntercept = false;
                    this.setParentIntercept(0, true);
                    break;
                }
                int getMoveX = Math.abs(getX - this.downX);
                int getMoveY = Math.abs(getY - this.downY);
                if (getMs - this.downMs >= ViewConfiguration.getLongPressTimeout() || getMoveX >= 3 || getMoveY >= 3) break;
                this.performClick();
            }
        }
        if (!this.isIntercept) {
            super.onTouchEvent(ev);
        }
        return true;
    }

    protected void onDetachedFromWindow() {
        this.cacheDrawer(false);
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int setWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int setHeight = 0;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            view.setClickable(true);
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            setHeight = Math.max(setHeight, view.getMeasuredHeight());
        }
        if (heightMode == 0x40000000) {
            setHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        }
        this.setMeasuredDimension(setWidth, setHeight);
        this.updateSize(false);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            if (view.getLeft() == 0 && view.getTop() == 0 && view.getRight() == 0 && view.getBottom() == 0 || this.lastMode != this.mode) {
                int setLeft = 0;
                int setTop = 0;
                int setRight = view.getMeasuredWidth();
                int setBottom = view.getMeasuredHeight();
                if (this.isTouch) {
                    int getDirection = this.getDirection(view);
                    int getMode = this.getDirectionMode(getDirection);
                    if (getMode == 0 || getMode == 1) {
                        if (getDirection == 1) {
                            setLeft = -setRight;
                            setRight = 0;
                        } else if (getDirection == 3) {
                            setLeft = this.mainLayout.width;
                            setRight += setLeft;
                        } else if (getDirection == 2) {
                            setTop = -setBottom;
                            setBottom = 0;
                        } else if (getDirection == 4) {
                            setTop = this.mainLayout.height;
                            setBottom += setTop;
                        }
                    } else if (getDirection == 3) {
                        setLeft = this.getMeasuredWidth() - setRight;
                        setRight = this.getMeasuredWidth();
                    } else if (getDirection == 4) {
                        setTop = this.getMeasuredHeight() - setBottom;
                        setBottom = this.getMeasuredHeight();
                    }
                }
                view.layout(setLeft, setTop, setRight, setBottom);
                continue;
            }
            view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
        this.updateSize(true);
        if (!this.isInit) {
            this.isInit = true;
        }
        if (this.open > 0) {
            this.openDrawer(this.open, false, false);
            this.open = 0;
        }
        if (this.lastMode != this.mode) {
            this.lastMode = this.mode;
        }
        if (this.parentId != -1) {
            this.setParentDrawer(this.parentId);
            this.parentId = -1;
        }
    }
}

