/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.eightchar;

import com.nlf.calendar.Lunar;
import com.nlf.calendar.eightchar.DaYun;
import com.nlf.calendar.util.LunarUtil;

public class XiaoYun {
    private final int index;
    private final DaYun daYun;
    private final int year;
    private final int age;
    private final boolean forward;
    private final Lunar lunar;

    public XiaoYun(DaYun daYun, int index, boolean forward) {
        this.daYun = daYun;
        this.lunar = daYun.getLunar();
        this.index = index;
        this.year = daYun.getStartYear() + index;
        this.age = daYun.getStartAge() + index;
        this.forward = forward;
    }

    public int getIndex() {
        return this.index;
    }

    public int getYear() {
        return this.year;
    }

    public int getAge() {
        return this.age;
    }

    public String getGanZhi() {
        int offset = LunarUtil.getJiaZiIndex(this.lunar.getTimeInGanZhi());
        int add = this.index + 1;
        if (this.daYun.getIndex() > 0) {
            add += this.daYun.getStartAge() - 1;
        }
        offset += this.forward ? add : -add;
        int size = LunarUtil.JIA_ZI.length;
        while (offset < 0) {
            offset += size;
        }
        return LunarUtil.JIA_ZI[offset %= size];
    }

    public String getXun() {
        return LunarUtil.getXun(this.getGanZhi());
    }

    public String getXunKong() {
        return LunarUtil.getXunKong(this.getGanZhi());
    }
}

