/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.eightchar;

import com.nlf.calendar.eightchar.LiuNian;
import com.nlf.calendar.util.LunarUtil;

public class LiuYue {
    private final int index;
    private final LiuNian liuNian;

    public LiuYue(LiuNian liuNian, int index) {
        this.liuNian = liuNian;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getMonthInChinese() {
        return LunarUtil.MONTH[this.index + 1];
    }

    public String getGanZhi() {
        int offset = 0;
        String yearGan = this.liuNian.getGanZhi().substring(0, 1);
        if ("\u7532".equals(yearGan) || "\u5df1".equals(yearGan)) {
            offset = 2;
        } else if ("\u4e59".equals(yearGan) || "\u5e9a".equals(yearGan)) {
            offset = 4;
        } else if ("\u4e19".equals(yearGan) || "\u8f9b".equals(yearGan)) {
            offset = 6;
        } else if ("\u4e01".equals(yearGan) || "\u58ec".equals(yearGan)) {
            offset = 8;
        }
        String gan = LunarUtil.GAN[(this.index + offset) % 10 + 1];
        String zhi = LunarUtil.ZHI[(this.index + 2) % 12 + 1];
        return gan + zhi;
    }

    public String getXun() {
        return LunarUtil.getXun(this.getGanZhi());
    }

    public String getXunKong() {
        return LunarUtil.getXunKong(this.getGanZhi());
    }
}

