/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.EightChar;
import com.nlf.calendar.Foto;
import com.nlf.calendar.Fu;
import com.nlf.calendar.JieQi;
import com.nlf.calendar.LunarMonth;
import com.nlf.calendar.LunarTime;
import com.nlf.calendar.LunarYear;
import com.nlf.calendar.NineStar;
import com.nlf.calendar.ShuJiu;
import com.nlf.calendar.Solar;
import com.nlf.calendar.Tao;
import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lunar {
    public static final String[] JIE_QI = new String[]{"\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea"};
    public static final String[] JIE_QI_IN_USE = new String[]{"DA_XUE", "\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "DONG_ZHI", "XIAO_HAN", "DA_HAN", "LI_CHUN", "YU_SHUI", "JING_ZHE"};
    private int year;
    private int month;
    private int day;
    private final Solar solar;
    private int timeGanIndex;
    private int timeZhiIndex;
    private int dayGanIndex;
    private int dayZhiIndex;
    private int dayGanIndexExact;
    private int dayZhiIndexExact;
    private int dayGanIndexExact2;
    private int dayZhiIndexExact2;
    private int monthGanIndex;
    private int monthZhiIndex;
    private int monthGanIndexExact;
    private int monthZhiIndexExact;
    private int yearGanIndex;
    private int yearZhiIndex;
    private int yearGanIndexByLiChun;
    private int yearZhiIndexByLiChun;
    private int yearGanIndexExact;
    private int yearZhiIndexExact;
    private int weekIndex;
    private final int hour;
    private final int minute;
    private final int second;
    private EightChar eightChar;
    private final Map<String, Solar> jieQi = new LinkedHashMap<String, Solar>();

    public Lunar() {
        this(new Date());
    }

    public Lunar(int lunarYear, int lunarMonth, int lunarDay) {
        this(lunarYear, lunarMonth, lunarDay, 0, 0, 0);
    }

    public Lunar(int lunarYear, int lunarMonth, int lunarDay, int hour, int minute, int second) {
        LunarYear y = LunarYear.fromYear(lunarYear);
        LunarMonth m = y.getMonth(lunarMonth);
        if (null == m) {
            throw new IllegalArgumentException(String.format("wrong lunar year %d month %d", lunarYear, lunarMonth));
        }
        if (lunarDay < 1) {
            throw new IllegalArgumentException("lunar day must bigger than 0");
        }
        int days = m.getDayCount();
        if (lunarDay > days) {
            throw new IllegalArgumentException(String.format("only %d days in lunar year %d month %d", days, lunarYear, lunarMonth));
        }
        this.year = lunarYear;
        this.month = lunarMonth;
        this.day = lunarDay;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        Solar noon = Solar.fromJulianDay(m.getFirstJulianDay() + (double)lunarDay - 1.0);
        this.solar = Solar.fromYmdHms(noon.getYear(), noon.getMonth(), noon.getDay(), hour, minute, second);
        if (noon.getYear() != lunarYear) {
            y = LunarYear.fromYear(noon.getYear());
        }
        this.compute(y);
    }

    public Lunar(Solar solar) {
        LunarYear ly = LunarYear.fromYear(solar.getYear());
        for (LunarMonth m : ly.getMonths()) {
            int days = solar.subtract(Solar.fromJulianDay(m.getFirstJulianDay()));
            if (days >= m.getDayCount()) continue;
            this.year = m.getYear();
            this.month = m.getMonth();
            this.day = days + 1;
            break;
        }
        this.hour = solar.getHour();
        this.minute = solar.getMinute();
        this.second = solar.getSecond();
        this.solar = solar;
        this.compute(ly);
    }

    public Lunar(Date date) {
        this(Solar.fromDate(date));
    }

    private void computeJieQi(LunarYear lunarYear) {
        List<Double> julianDays = lunarYear.getJieQiJulianDays();
        int j = JIE_QI_IN_USE.length;
        for (int i = 0; i < j; ++i) {
            this.jieQi.put(JIE_QI_IN_USE[i], Solar.fromJulianDay(julianDays.get(i)));
        }
    }

    private void computeYear() {
        int offset = this.year - 4;
        this.yearGanIndex = offset % 10;
        this.yearZhiIndex = offset % 12;
        if (this.yearGanIndex < 0) {
            this.yearGanIndex += 10;
        }
        if (this.yearZhiIndex < 0) {
            this.yearZhiIndex += 12;
        }
        int g = this.yearGanIndex;
        int z = this.yearZhiIndex;
        int gExact = this.yearGanIndex;
        int zExact = this.yearZhiIndex;
        int solarYear = this.solar.getYear();
        String solarYmd = this.solar.toYmd();
        String solarYmdHms = this.solar.toYmdHms();
        Solar liChun = this.jieQi.get("\u7acb\u6625");
        if (liChun.getYear() != solarYear) {
            liChun = this.jieQi.get("LI_CHUN");
        }
        String liChunYmd = liChun.toYmd();
        String liChunYmdHms = liChun.toYmdHms();
        if (this.year == solarYear) {
            if (solarYmd.compareTo(liChunYmd) < 0) {
                --g;
                --z;
            }
            if (solarYmdHms.compareTo(liChunYmdHms) < 0) {
                --gExact;
                --zExact;
            }
        } else if (this.year < solarYear) {
            if (solarYmd.compareTo(liChunYmd) >= 0) {
                ++g;
                ++z;
            }
            if (solarYmdHms.compareTo(liChunYmdHms) >= 0) {
                ++gExact;
                ++zExact;
            }
        }
        this.yearGanIndexByLiChun = (g < 0 ? g + 10 : g) % 10;
        this.yearZhiIndexByLiChun = (z < 0 ? z + 12 : z) % 12;
        this.yearGanIndexExact = (gExact < 0 ? gExact + 10 : gExact) % 10;
        this.yearZhiIndexExact = (zExact < 0 ? zExact + 12 : zExact) % 12;
    }

    private void computeMonth() {
        Solar end;
        Solar start = null;
        String ymd = this.solar.toYmd();
        String time = this.solar.toYmdHms();
        int size = JIE_QI_IN_USE.length;
        int index = -3;
        for (int i = 0; i < size; i += 2) {
            String symd;
            end = this.jieQi.get(JIE_QI_IN_USE[i]);
            String string = symd = null == start ? ymd : start.toYmd();
            if (ymd.compareTo(symd) >= 0 && ymd.compareTo(end.toYmd()) < 0) break;
            start = end;
            ++index;
        }
        int offset = ((this.yearGanIndexByLiChun + (index < 0 ? 1 : 0)) % 5 + 1) * 2 % 10;
        this.monthGanIndex = ((index < 0 ? index + 10 : index) + offset) % 10;
        this.monthZhiIndex = ((index < 0 ? index + 12 : index) + 2) % 12;
        start = null;
        index = -3;
        for (int i = 0; i < size; i += 2) {
            String stime;
            end = this.jieQi.get(JIE_QI_IN_USE[i]);
            String string = stime = null == start ? time : start.toYmdHms();
            if (time.compareTo(stime) >= 0 && time.compareTo(end.toYmdHms()) < 0) break;
            start = end;
            ++index;
        }
        offset = ((this.yearGanIndexExact + (index < 0 ? 1 : 0)) % 5 + 1) * 2 % 10;
        this.monthGanIndexExact = ((index < 0 ? index + 10 : index) + offset) % 10;
        this.monthZhiIndexExact = ((index < 0 ? index + 12 : index) + 2) % 12;
    }

    private void computeDay() {
        Solar noon = Solar.fromYmdHms(this.solar.getYear(), this.solar.getMonth(), this.solar.getDay(), 12, 0, 0);
        int offset = (int)noon.getJulianDay() - 11;
        this.dayGanIndex = offset % 10;
        this.dayZhiIndex = offset % 12;
        int dayGanExact = this.dayGanIndex;
        int dayZhiExact = this.dayZhiIndex;
        this.dayGanIndexExact2 = dayGanExact;
        this.dayZhiIndexExact2 = dayZhiExact;
        String hm = (this.hour < 10 ? "0" : "") + this.hour + ":" + (this.minute < 10 ? "0" : "") + this.minute;
        if (hm.compareTo("23:00") >= 0 && hm.compareTo("23:59") <= 0) {
            if (++dayGanExact >= 10) {
                dayGanExact -= 10;
            }
            if (++dayZhiExact >= 12) {
                dayZhiExact -= 12;
            }
        }
        this.dayGanIndexExact = dayGanExact;
        this.dayZhiIndexExact = dayZhiExact;
    }

    private void computeTime() {
        String hm = (this.hour < 10 ? "0" : "") + this.hour + ":" + (this.minute < 10 ? "0" : "") + this.minute;
        this.timeZhiIndex = LunarUtil.getTimeZhiIndex(hm);
        this.timeGanIndex = (this.dayGanIndexExact % 5 * 2 + this.timeZhiIndex) % 10;
    }

    private void computeWeek() {
        this.weekIndex = this.solar.getWeek();
    }

    private void compute(LunarYear lunarYear) {
        this.computeJieQi(lunarYear);
        this.computeYear();
        this.computeMonth();
        this.computeDay();
        this.computeTime();
        this.computeWeek();
    }

    public static Lunar fromDate(Date date) {
        return new Lunar(date);
    }

    public static Lunar fromYmd(int lunarYear, int lunarMonth, int lunarDay) {
        return new Lunar(lunarYear, lunarMonth, lunarDay);
    }

    public static Lunar fromYmdHms(int lunarYear, int lunarMonth, int lunarDay, int hour, int minute, int second) {
        return new Lunar(lunarYear, lunarMonth, lunarDay, hour, minute, second);
    }

    @Deprecated
    public String getGan() {
        return this.getYearGan();
    }

    public String getYearGan() {
        return LunarUtil.GAN[this.yearGanIndex + 1];
    }

    public String getYearGanByLiChun() {
        return LunarUtil.GAN[this.yearGanIndexByLiChun + 1];
    }

    public String getYearGanExact() {
        return LunarUtil.GAN[this.yearGanIndexExact + 1];
    }

    @Deprecated
    public String getZhi() {
        return this.getYearZhi();
    }

    public String getYearZhi() {
        return LunarUtil.ZHI[this.yearZhiIndex + 1];
    }

    public String getYearZhiByLiChun() {
        return LunarUtil.ZHI[this.yearZhiIndexByLiChun + 1];
    }

    public String getYearZhiExact() {
        return LunarUtil.ZHI[this.yearZhiIndexExact + 1];
    }

    public String getYearInGanZhi() {
        return this.getYearGan() + this.getYearZhi();
    }

    public String getYearInGanZhiByLiChun() {
        return this.getYearGanByLiChun() + this.getYearZhiByLiChun();
    }

    public String getYearInGanZhiExact() {
        return this.getYearGanExact() + this.getYearZhiExact();
    }

    public String getMonthInGanZhi() {
        return this.getMonthGan() + this.getMonthZhi();
    }

    public String getMonthInGanZhiExact() {
        return this.getMonthGanExact() + this.getMonthZhiExact();
    }

    public String getMonthGan() {
        return LunarUtil.GAN[this.monthGanIndex + 1];
    }

    public String getMonthGanExact() {
        return LunarUtil.GAN[this.monthGanIndexExact + 1];
    }

    public String getMonthZhi() {
        return LunarUtil.ZHI[this.monthZhiIndex + 1];
    }

    public String getMonthZhiExact() {
        return LunarUtil.ZHI[this.monthZhiIndexExact + 1];
    }

    public String getDayInGanZhi() {
        return this.getDayGan() + this.getDayZhi();
    }

    public String getDayInGanZhiExact() {
        return this.getDayGanExact() + this.getDayZhiExact();
    }

    public String getDayInGanZhiExact2() {
        return this.getDayGanExact2() + this.getDayZhiExact2();
    }

    public String getDayGan() {
        return LunarUtil.GAN[this.dayGanIndex + 1];
    }

    public String getDayGanExact() {
        return LunarUtil.GAN[this.dayGanIndexExact + 1];
    }

    public String getDayGanExact2() {
        return LunarUtil.GAN[this.dayGanIndexExact2 + 1];
    }

    public String getDayZhi() {
        return LunarUtil.ZHI[this.dayZhiIndex + 1];
    }

    public String getDayZhiExact() {
        return LunarUtil.ZHI[this.dayZhiIndexExact + 1];
    }

    public String getDayZhiExact2() {
        return LunarUtil.ZHI[this.dayZhiIndexExact2 + 1];
    }

    @Deprecated
    public String getShengxiao() {
        return this.getYearShengXiao();
    }

    public String getYearShengXiao() {
        return LunarUtil.SHENGXIAO[this.yearZhiIndex + 1];
    }

    public String getYearShengXiaoByLiChun() {
        return LunarUtil.SHENGXIAO[this.yearZhiIndexByLiChun + 1];
    }

    public String getYearShengXiaoExact() {
        return LunarUtil.SHENGXIAO[this.yearZhiIndexExact + 1];
    }

    public String getMonthShengXiao() {
        return LunarUtil.SHENGXIAO[this.monthZhiIndex + 1];
    }

    public String getDayShengXiao() {
        return LunarUtil.SHENGXIAO[this.dayZhiIndex + 1];
    }

    public String getTimeShengXiao() {
        return LunarUtil.SHENGXIAO[this.timeZhiIndex + 1];
    }

    public String getYearInChinese() {
        String y = this.year + "";
        StringBuilder s = new StringBuilder();
        int j = y.length();
        for (int i = 0; i < j; ++i) {
            s.append(LunarUtil.NUMBER[y.charAt(i) - 48]);
        }
        return s.toString();
    }

    public String getMonthInChinese() {
        return (this.month < 0 ? "\u95f0" : "") + LunarUtil.MONTH[Math.abs(this.month)];
    }

    public String getDayInChinese() {
        return LunarUtil.DAY[this.day];
    }

    public String getTimeZhi() {
        return LunarUtil.ZHI[this.timeZhiIndex + 1];
    }

    public String getTimeGan() {
        return LunarUtil.GAN[this.timeGanIndex + 1];
    }

    public String getTimeInGanZhi() {
        return this.getTimeGan() + this.getTimeZhi();
    }

    public String getSeason() {
        return LunarUtil.SEASON[Math.abs(this.month)];
    }

    protected String convertJieQi(String name) {
        String jq = name;
        if ("DONG_ZHI".equals(jq)) {
            jq = "\u51ac\u81f3";
        } else if ("DA_HAN".equals(jq)) {
            jq = "\u5927\u5bd2";
        } else if ("XIAO_HAN".equals(jq)) {
            jq = "\u5c0f\u5bd2";
        } else if ("LI_CHUN".equals(jq)) {
            jq = "\u7acb\u6625";
        } else if ("DA_XUE".equals(jq)) {
            jq = "\u5927\u96ea";
        } else if ("YU_SHUI".equals(jq)) {
            jq = "\u96e8\u6c34";
        } else if ("JING_ZHE".equals(jq)) {
            jq = "\u60ca\u86f0";
        }
        return jq;
    }

    public String getJie() {
        int j = JIE_QI_IN_USE.length;
        for (int i = 0; i < j; i += 2) {
            String key = JIE_QI_IN_USE[i];
            Solar d = this.jieQi.get(key);
            if (d.getYear() != this.solar.getYear() || d.getMonth() != this.solar.getMonth() || d.getDay() != this.solar.getDay()) continue;
            return this.convertJieQi(key);
        }
        return "";
    }

    public String getQi() {
        int j = JIE_QI_IN_USE.length;
        for (int i = 1; i < j; i += 2) {
            String key = JIE_QI_IN_USE[i];
            Solar d = this.jieQi.get(key);
            if (d.getYear() != this.solar.getYear() || d.getMonth() != this.solar.getMonth() || d.getDay() != this.solar.getDay()) continue;
            return this.convertJieQi(key);
        }
        return "";
    }

    public int getWeek() {
        return this.weekIndex;
    }

    public String getWeekInChinese() {
        return SolarUtil.WEEK[this.getWeek()];
    }

    public String getXiu() {
        return LunarUtil.XIU.get(this.getDayZhi() + this.getWeek());
    }

    public String getXiuLuck() {
        return LunarUtil.XIU_LUCK.get(this.getXiu());
    }

    public String getXiuSong() {
        return LunarUtil.XIU_SONG.get(this.getXiu());
    }

    public String getZheng() {
        return LunarUtil.ZHENG.get(this.getXiu());
    }

    public String getAnimal() {
        return LunarUtil.ANIMAL.get(this.getXiu());
    }

    public String getGong() {
        return LunarUtil.GONG.get(this.getXiu());
    }

    public String getShou() {
        return LunarUtil.SHOU.get(this.getGong());
    }

    public List<String> getFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        String f = LunarUtil.FESTIVAL.get(this.month + "-" + this.day);
        if (null != f) {
            l.add(f);
        }
        if (Math.abs(this.month) == 12 && this.day >= 29 && this.year != this.next(1).getYear()) {
            l.add("\u9664\u5915");
        }
        return l;
    }

    public List<String> getOtherFestivals() {
        Solar jq;
        int offset;
        String solarYmd;
        ArrayList<String> l = new ArrayList<String>();
        List<String> fs = LunarUtil.OTHER_FESTIVAL.get(this.month + "-" + this.day);
        if (null != fs) {
            l.addAll(fs);
        }
        if ((solarYmd = this.solar.toYmd()).equals(this.jieQi.get("\u6e05\u660e").next(-1).toYmd())) {
            l.add("\u5bd2\u98df\u8282");
        }
        if ((offset = 4 - (jq = this.jieQi.get("\u7acb\u6625")).getLunar().getDayGanIndex()) < 0) {
            offset += 10;
        }
        if (solarYmd.equals(jq.next(offset + 40).toYmd())) {
            l.add("\u6625\u793e");
        }
        if ((offset = 4 - (jq = this.jieQi.get("\u7acb\u79cb")).getLunar().getDayGanIndex()) < 0) {
            offset += 10;
        }
        if (solarYmd.equals(jq.next(offset + 40).toYmd())) {
            l.add("\u79cb\u793e");
        }
        return l;
    }

    public String getPengZuGan() {
        return LunarUtil.PENGZU_GAN[this.dayGanIndex + 1];
    }

    public String getPengZuZhi() {
        return LunarUtil.PENGZU_ZHI[this.dayZhiIndex + 1];
    }

    public String getPositionXi() {
        return this.getDayPositionXi();
    }

    public String getPositionXiDesc() {
        return this.getDayPositionXiDesc();
    }

    public String getPositionYangGui() {
        return this.getDayPositionYangGui();
    }

    public String getPositionYangGuiDesc() {
        return this.getDayPositionYangGuiDesc();
    }

    public String getPositionYinGui() {
        return this.getDayPositionYinGui();
    }

    public String getPositionYinGuiDesc() {
        return this.getDayPositionYinGuiDesc();
    }

    public String getPositionFu() {
        return this.getDayPositionFu();
    }

    public String getPositionFuDesc() {
        return this.getDayPositionFuDesc();
    }

    public String getPositionCai() {
        return this.getDayPositionCai();
    }

    public String getPositionCaiDesc() {
        return this.getDayPositionCaiDesc();
    }

    public String getDayPositionXi() {
        return LunarUtil.POSITION_XI[this.dayGanIndex + 1];
    }

    public String getDayPositionXiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionXi());
    }

    public String getDayPositionYangGui() {
        return LunarUtil.POSITION_YANG_GUI[this.dayGanIndex + 1];
    }

    public String getDayPositionYangGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionYangGui());
    }

    public String getDayPositionYinGui() {
        return LunarUtil.POSITION_YIN_GUI[this.dayGanIndex + 1];
    }

    public String getDayPositionYinGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionYinGui());
    }

    public String getDayPositionFu() {
        return this.getDayPositionFu(2);
    }

    public String getDayPositionFu(int sect) {
        return (1 == sect ? LunarUtil.POSITION_FU : LunarUtil.POSITION_FU_2)[this.dayGanIndex + 1];
    }

    public String getDayPositionFuDesc() {
        return this.getDayPositionFuDesc(2);
    }

    public String getDayPositionFuDesc(int sect) {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionFu(sect));
    }

    public String getDayPositionCai() {
        return LunarUtil.POSITION_CAI[this.dayGanIndex + 1];
    }

    public String getDayPositionCaiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionCai());
    }

    public String getYearPositionTaiSui() {
        return this.getYearPositionTaiSui(2);
    }

    public String getYearPositionTaiSui(int sect) {
        int yearZhiIndex;
        switch (sect) {
            case 1: {
                yearZhiIndex = this.yearZhiIndex;
                break;
            }
            case 3: {
                yearZhiIndex = this.yearZhiIndexExact;
                break;
            }
            default: {
                yearZhiIndex = this.yearZhiIndexByLiChun;
            }
        }
        return LunarUtil.POSITION_TAI_SUI_YEAR[yearZhiIndex];
    }

    public String getYearPositionTaiSuiDesc() {
        return this.getYearPositionTaiSuiDesc(2);
    }

    public String getYearPositionTaiSuiDesc(int sect) {
        return LunarUtil.POSITION_DESC.get(this.getYearPositionTaiSui(sect));
    }

    protected String getMonthPositionTaiSui(int monthZhiIndex, int monthGanIndex) {
        String p;
        int m = monthZhiIndex - 2;
        if (m < 0) {
            m += 12;
        }
        switch (m %= 4) {
            case 0: {
                p = "\u826e";
                break;
            }
            case 2: {
                p = "\u5764";
                break;
            }
            case 3: {
                p = "\u5dfd";
                break;
            }
            default: {
                p = LunarUtil.POSITION_GAN[monthGanIndex];
            }
        }
        return p;
    }

    public String getMonthPositionTaiSui() {
        return this.getMonthPositionTaiSui(2);
    }

    public String getMonthPositionTaiSui(int sect) {
        int monthGanIndex;
        int monthZhiIndex;
        if (sect == 3) {
            monthZhiIndex = this.monthZhiIndexExact;
            monthGanIndex = this.monthGanIndexExact;
        } else {
            monthZhiIndex = this.monthZhiIndex;
            monthGanIndex = this.monthGanIndex;
        }
        return this.getMonthPositionTaiSui(monthZhiIndex, monthGanIndex);
    }

    public String getMonthPositionTaiSuiDesc() {
        return this.getMonthPositionTaiSuiDesc(2);
    }

    public String getMonthPositionTaiSuiDesc(int sect) {
        return LunarUtil.POSITION_DESC.get(this.getMonthPositionTaiSui(sect));
    }

    protected String getDayPositionTaiSui(String dayInGanZhi, int yearZhiIndex) {
        String p = "\u7532\u5b50,\u4e59\u4e11,\u4e19\u5bc5,\u4e01\u536f,\u620a\u8fb0,\u5df1\u5df3".contains(dayInGanZhi) ? "\u9707" : ("\u4e19\u5b50,\u4e01\u4e11,\u620a\u5bc5,\u5df1\u536f,\u5e9a\u8fb0,\u8f9b\u5df3".contains(dayInGanZhi) ? "\u79bb" : ("\u620a\u5b50,\u5df1\u4e11,\u5e9a\u5bc5,\u8f9b\u536f,\u58ec\u8fb0,\u7678\u5df3".contains(dayInGanZhi) ? "\u4e2d" : ("\u5e9a\u5b50,\u8f9b\u4e11,\u58ec\u5bc5,\u7678\u536f,\u7532\u8fb0,\u4e59\u5df3".contains(dayInGanZhi) ? "\u5151" : ("\u58ec\u5b50,\u7678\u4e11,\u7532\u5bc5,\u4e59\u536f,\u4e19\u8fb0,\u4e01\u5df3".contains(dayInGanZhi) ? "\u574e" : LunarUtil.POSITION_TAI_SUI_YEAR[yearZhiIndex]))));
        return p;
    }

    public String getDayPositionTaiSui() {
        return this.getDayPositionTaiSui(2);
    }

    public String getDayPositionTaiSui(int sect) {
        int yearZhiIndex;
        String dayInGanZhi;
        switch (sect) {
            case 1: {
                dayInGanZhi = this.getDayInGanZhi();
                yearZhiIndex = this.yearZhiIndex;
                break;
            }
            case 3: {
                dayInGanZhi = this.getDayInGanZhi();
                yearZhiIndex = this.yearZhiIndexExact;
                break;
            }
            default: {
                dayInGanZhi = this.getDayInGanZhiExact2();
                yearZhiIndex = this.yearZhiIndexByLiChun;
            }
        }
        return this.getDayPositionTaiSui(dayInGanZhi, yearZhiIndex);
    }

    public String getDayPositionTaiSuiDesc() {
        return this.getDayPositionTaiSuiDesc(2);
    }

    public String getDayPositionTaiSuiDesc(int sect) {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionTaiSui(sect));
    }

    public String getTimePositionXi() {
        return LunarUtil.POSITION_XI[this.timeGanIndex + 1];
    }

    public String getTimePositionXiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionXi());
    }

    public String getTimePositionYangGui() {
        return LunarUtil.POSITION_YANG_GUI[this.timeGanIndex + 1];
    }

    public String getTimePositionYangGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionYangGui());
    }

    public String getTimePositionYinGui() {
        return LunarUtil.POSITION_YIN_GUI[this.timeGanIndex + 1];
    }

    public String getTimePositionYinGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionYinGui());
    }

    public String getTimePositionFu() {
        return this.getTimePositionFu(2);
    }

    public String getTimePositionFu(int sect) {
        return (1 == sect ? LunarUtil.POSITION_FU : LunarUtil.POSITION_FU_2)[this.timeGanIndex + 1];
    }

    public String getTimePositionFuDesc() {
        return this.getTimePositionFuDesc(2);
    }

    public String getTimePositionFuDesc(int sect) {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionFu(sect));
    }

    public String getTimePositionCai() {
        return LunarUtil.POSITION_CAI[this.timeGanIndex + 1];
    }

    public String getTimePositionCaiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionCai());
    }

    @Deprecated
    public String getChong() {
        return this.getDayChong();
    }

    @Deprecated
    public String getChongGan() {
        return this.getDayChongGan();
    }

    @Deprecated
    public String getChongGanTie() {
        return this.getDayChongGanTie();
    }

    @Deprecated
    public String getChongShengXiao() {
        return this.getDayChongShengXiao();
    }

    @Deprecated
    public String getChongDesc() {
        return this.getDayChongDesc();
    }

    @Deprecated
    public String getSha() {
        return this.getDaySha();
    }

    public String getYearNaYin() {
        return LunarUtil.NAYIN.get(this.getYearInGanZhi());
    }

    public String getMonthNaYin() {
        return LunarUtil.NAYIN.get(this.getMonthInGanZhi());
    }

    public String getDayNaYin() {
        return LunarUtil.NAYIN.get(this.getDayInGanZhi());
    }

    public String getTimeNaYin() {
        return LunarUtil.NAYIN.get(this.getTimeInGanZhi());
    }

    @Deprecated
    public List<String> getBaZi() {
        ArrayList<String> l = new ArrayList<String>(4);
        EightChar eightChar = this.getEightChar();
        l.add(eightChar.getYear());
        l.add(eightChar.getMonth());
        l.add(eightChar.getDay());
        l.add(eightChar.getTime());
        return l;
    }

    @Deprecated
    public List<String> getBaZiWuXing() {
        ArrayList<String> l = new ArrayList<String>(4);
        EightChar eightChar = this.getEightChar();
        l.add(eightChar.getYearWuXing());
        l.add(eightChar.getMonthWuXing());
        l.add(eightChar.getDayWuXing());
        l.add(eightChar.getTimeWuXing());
        return l;
    }

    @Deprecated
    public List<String> getBaZiNaYin() {
        ArrayList<String> l = new ArrayList<String>(4);
        EightChar eightChar = this.getEightChar();
        l.add(eightChar.getYearNaYin());
        l.add(eightChar.getMonthNaYin());
        l.add(eightChar.getDayNaYin());
        l.add(eightChar.getTimeNaYin());
        return l;
    }

    @Deprecated
    public List<String> getBaZiShiShenGan() {
        ArrayList<String> l = new ArrayList<String>(4);
        EightChar eightChar = this.getEightChar();
        l.add(eightChar.getYearShiShenGan());
        l.add(eightChar.getMonthShiShenGan());
        l.add(eightChar.getDayShiShenGan());
        l.add(eightChar.getTimeShiShenGan());
        return l;
    }

    @Deprecated
    public List<String> getBaZiShiShenZhi() {
        ArrayList<String> l = new ArrayList<String>(4);
        EightChar eightChar = this.getEightChar();
        l.add(eightChar.getYearShiShenZhi().get(0));
        l.add(eightChar.getMonthShiShenZhi().get(0));
        l.add(eightChar.getDayShiShenZhi().get(0));
        l.add(eightChar.getTimeShiShenZhi().get(0));
        return l;
    }

    @Deprecated
    public List<String> getBaZiShiShenYearZhi() {
        return this.getEightChar().getYearShiShenZhi();
    }

    @Deprecated
    public List<String> getBaZiShiShenMonthZhi() {
        return this.getEightChar().getMonthShiShenZhi();
    }

    @Deprecated
    public List<String> getBaZiShiShenDayZhi() {
        return this.getEightChar().getDayShiShenZhi();
    }

    @Deprecated
    public List<String> getBaZiShiShenTimeZhi() {
        return this.getEightChar().getTimeShiShenZhi();
    }

    public String getZhiXing() {
        int offset = this.dayZhiIndex - this.monthZhiIndex;
        if (offset < 0) {
            offset += 12;
        }
        return LunarUtil.ZHI_XING[offset + 1];
    }

    public String getDayTianShen() {
        return LunarUtil.TIAN_SHEN[(this.dayZhiIndex + LunarUtil.ZHI_TIAN_SHEN_OFFSET.get(this.getMonthZhi())) % 12 + 1];
    }

    public String getTimeTianShen() {
        return LunarUtil.TIAN_SHEN[(this.timeZhiIndex + LunarUtil.ZHI_TIAN_SHEN_OFFSET.get(this.getDayZhiExact())) % 12 + 1];
    }

    public String getDayTianShenType() {
        return LunarUtil.TIAN_SHEN_TYPE.get(this.getDayTianShen());
    }

    public String getTimeTianShenType() {
        return LunarUtil.TIAN_SHEN_TYPE.get(this.getTimeTianShen());
    }

    public String getDayTianShenLuck() {
        return LunarUtil.TIAN_SHEN_TYPE_LUCK.get(this.getDayTianShenType());
    }

    public String getTimeTianShenLuck() {
        return LunarUtil.TIAN_SHEN_TYPE_LUCK.get(this.getTimeTianShenType());
    }

    public String getDayPositionTai() {
        return LunarUtil.POSITION_TAI_DAY[LunarUtil.getJiaZiIndex(this.getDayInGanZhi())];
    }

    public String getMonthPositionTai() {
        if (this.month < 0) {
            return "";
        }
        return LunarUtil.POSITION_TAI_MONTH[this.month - 1];
    }

    public List<String> getDayYi() {
        return this.getDayYi(1);
    }

    public List<String> getDayYi(int sect) {
        return LunarUtil.getDayYi(2 == sect ? this.getMonthInGanZhiExact() : this.getMonthInGanZhi(), this.getDayInGanZhi());
    }

    public List<String> getDayJi() {
        return this.getDayJi(1);
    }

    public List<String> getDayJi(int sect) {
        return LunarUtil.getDayJi(2 == sect ? this.getMonthInGanZhiExact() : this.getMonthInGanZhi(), this.getDayInGanZhi());
    }

    public List<String> getDayJiShen() {
        return LunarUtil.getDayJiShen(this.getMonth(), this.getDayInGanZhi());
    }

    public List<String> getDayXiongSha() {
        return LunarUtil.getDayXiongSha(this.getMonth(), this.getDayInGanZhi());
    }

    public String getDayChong() {
        return LunarUtil.CHONG[this.dayZhiIndex];
    }

    public String getDaySha() {
        return LunarUtil.SHA.get(this.getDayZhi());
    }

    public String getDayChongDesc() {
        return "(" + this.getDayChongGan() + this.getDayChong() + ")" + this.getDayChongShengXiao();
    }

    public String getDayChongShengXiao() {
        String chong = this.getDayChong();
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(chong)) continue;
            return LunarUtil.SHENGXIAO[i];
        }
        return "";
    }

    public String getDayChongGan() {
        return LunarUtil.CHONG_GAN[this.dayGanIndex];
    }

    public String getDayChongGanTie() {
        return LunarUtil.CHONG_GAN_TIE[this.dayGanIndex];
    }

    public String getTimeChong() {
        return LunarUtil.CHONG[this.timeZhiIndex];
    }

    public String getTimeSha() {
        return LunarUtil.SHA.get(this.getTimeZhi());
    }

    public String getTimeChongShengXiao() {
        String chong = this.getTimeChong();
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(chong)) continue;
            return LunarUtil.SHENGXIAO[i];
        }
        return "";
    }

    public String getTimeChongDesc() {
        return "(" + this.getTimeChongGan() + this.getTimeChong() + ")" + this.getTimeChongShengXiao();
    }

    public String getTimeChongGan() {
        return LunarUtil.CHONG_GAN[this.timeGanIndex];
    }

    public String getTimeChongGanTie() {
        return LunarUtil.CHONG_GAN_TIE[this.timeGanIndex];
    }

    public List<String> getTimeYi() {
        return LunarUtil.getTimeYi(this.getDayInGanZhiExact(), this.getTimeInGanZhi());
    }

    public List<String> getTimeJi() {
        return LunarUtil.getTimeJi(this.getDayInGanZhiExact(), this.getTimeInGanZhi());
    }

    public String getYueXiang() {
        return LunarUtil.YUE_XIANG[this.day];
    }

    protected NineStar getYearNineStar(String yearInGanZhi) {
        int index;
        int indexExact = LunarUtil.getJiaZiIndex(yearInGanZhi) + 1;
        int yearOffset = indexExact - (index = LunarUtil.getJiaZiIndex(this.getYearInGanZhi()) + 1);
        if (yearOffset > 1) {
            yearOffset -= 60;
        } else if (yearOffset < -1) {
            yearOffset += 60;
        }
        int yuan = (this.year + yearOffset + 2696) / 60 % 3;
        int offset = (62 + yuan * 3 - indexExact) % 9;
        if (0 == offset) {
            offset = 9;
        }
        return NineStar.fromIndex(offset - 1);
    }

    public NineStar getYearNineStar() {
        return this.getYearNineStar(2);
    }

    public NineStar getYearNineStar(int sect) {
        String yearInGanZhi;
        switch (sect) {
            case 1: {
                yearInGanZhi = this.getYearInGanZhi();
                break;
            }
            case 3: {
                yearInGanZhi = this.getYearInGanZhiExact();
                break;
            }
            default: {
                yearInGanZhi = this.getYearInGanZhiByLiChun();
            }
        }
        return this.getYearNineStar(yearInGanZhi);
    }

    protected NineStar getMonthNineStar(int yearZhiIndex, int monthZhiIndex) {
        int index = yearZhiIndex % 3;
        int n = 27 - index * 3;
        if (monthZhiIndex < 2) {
            n -= 3;
        }
        int offset = (n - monthZhiIndex) % 9;
        return NineStar.fromIndex(offset);
    }

    public NineStar getMonthNineStar() {
        return this.getMonthNineStar(2);
    }

    public NineStar getMonthNineStar(int sect) {
        int monthZhiIndex;
        int yearZhiIndex;
        switch (sect) {
            case 1: {
                yearZhiIndex = this.yearZhiIndex;
                monthZhiIndex = this.monthZhiIndex;
                break;
            }
            case 3: {
                yearZhiIndex = this.yearZhiIndexExact;
                monthZhiIndex = this.monthZhiIndexExact;
                break;
            }
            default: {
                yearZhiIndex = this.yearZhiIndexByLiChun;
                monthZhiIndex = this.monthZhiIndex;
            }
        }
        return this.getMonthNineStar(yearZhiIndex, monthZhiIndex);
    }

    public NineStar getDayNineStar() {
        String solarYmd = this.solar.toYmd();
        Solar dongZhi = this.jieQi.get("\u51ac\u81f3");
        Solar dongZhi2 = this.jieQi.get("DONG_ZHI");
        Solar xiaZhi = this.jieQi.get("\u590f\u81f3");
        int dongZhiIndex = LunarUtil.getJiaZiIndex(dongZhi.getLunar().getDayInGanZhi());
        int dongZhiIndex2 = LunarUtil.getJiaZiIndex(dongZhi2.getLunar().getDayInGanZhi());
        int xiaZhiIndex = LunarUtil.getJiaZiIndex(xiaZhi.getLunar().getDayInGanZhi());
        Solar solarShunBai = dongZhiIndex > 29 ? dongZhi.next(60 - dongZhiIndex) : dongZhi.next(-dongZhiIndex);
        String solarShunBaiYmd = solarShunBai.toYmd();
        Solar solarShunBai2 = dongZhiIndex2 > 29 ? dongZhi2.next(60 - dongZhiIndex2) : dongZhi2.next(-dongZhiIndex2);
        String solarShunBaiYmd2 = solarShunBai2.toYmd();
        Solar solarNiZi = xiaZhiIndex > 29 ? xiaZhi.next(60 - xiaZhiIndex) : xiaZhi.next(-xiaZhiIndex);
        String solarNiZiYmd = solarNiZi.toYmd();
        int offset = 0;
        if (solarYmd.compareTo(solarShunBaiYmd) >= 0 && solarYmd.compareTo(solarNiZiYmd) < 0) {
            offset = this.solar.subtract(solarShunBai) % 9;
        } else if (solarYmd.compareTo(solarNiZiYmd) >= 0 && solarYmd.compareTo(solarShunBaiYmd2) < 0) {
            offset = 8 - this.solar.subtract(solarNiZi) % 9;
        } else if (solarYmd.compareTo(solarShunBaiYmd2) >= 0) {
            offset = this.solar.subtract(solarShunBai2) % 9;
        } else if (solarYmd.compareTo(solarShunBaiYmd) < 0) {
            offset = (8 + solarShunBai.subtract(this.solar)) % 9;
        }
        return NineStar.fromIndex(offset);
    }

    public NineStar getTimeNineStar() {
        String solarYmd = this.solar.toYmd();
        boolean asc = false;
        if (solarYmd.compareTo(this.jieQi.get("\u51ac\u81f3").toYmd()) >= 0 && solarYmd.compareTo(this.jieQi.get("\u590f\u81f3").toYmd()) < 0) {
            asc = true;
        } else if (solarYmd.compareTo(this.jieQi.get("DONG_ZHI").toYmd()) >= 0) {
            asc = true;
        }
        int start = asc ? 6 : 2;
        String dayZhi = this.getDayZhi();
        if ("\u5b50\u5348\u536f\u9149".contains(dayZhi)) {
            start = asc ? 0 : 8;
        } else if ("\u8fb0\u620c\u4e11\u672a".contains(dayZhi)) {
            start = asc ? 3 : 5;
        }
        int index = asc ? start + this.timeZhiIndex : start + 9 - this.timeZhiIndex;
        return new NineStar(index % 9);
    }

    public Map<String, Solar> getJieQiTable() {
        return this.jieQi;
    }

    public JieQi getNextJie() {
        return this.getNextJie(false);
    }

    public JieQi getNextJie(boolean wholeDay) {
        int l = JIE_QI_IN_USE.length / 2;
        String[] conditions = new String[l];
        for (int i = 0; i < l; ++i) {
            conditions[i] = JIE_QI_IN_USE[i * 2];
        }
        return this.getNearJieQi(true, conditions, wholeDay);
    }

    public JieQi getPrevJie() {
        return this.getPrevJie(false);
    }

    public JieQi getPrevJie(boolean wholeDay) {
        int l = JIE_QI_IN_USE.length / 2;
        String[] conditions = new String[l];
        for (int i = 0; i < l; ++i) {
            conditions[i] = JIE_QI_IN_USE[i * 2];
        }
        return this.getNearJieQi(false, conditions, wholeDay);
    }

    public JieQi getNextQi() {
        return this.getNextQi(false);
    }

    public JieQi getNextQi(boolean wholeDay) {
        int l = JIE_QI_IN_USE.length / 2;
        String[] conditions = new String[l];
        for (int i = 0; i < l; ++i) {
            conditions[i] = JIE_QI_IN_USE[i * 2 + 1];
        }
        return this.getNearJieQi(true, conditions, wholeDay);
    }

    public JieQi getPrevQi() {
        return this.getPrevQi(false);
    }

    public JieQi getPrevQi(boolean wholeDay) {
        int l = JIE_QI_IN_USE.length / 2;
        String[] conditions = new String[l];
        for (int i = 0; i < l; ++i) {
            conditions[i] = JIE_QI_IN_USE[i * 2 + 1];
        }
        return this.getNearJieQi(false, conditions, wholeDay);
    }

    public JieQi getNextJieQi() {
        return this.getNextJieQi(false);
    }

    public JieQi getNextJieQi(boolean wholeDay) {
        return this.getNearJieQi(true, null, wholeDay);
    }

    public JieQi getPrevJieQi() {
        return this.getPrevJieQi(false);
    }

    public JieQi getPrevJieQi(boolean wholeDay) {
        return this.getNearJieQi(false, null, wholeDay);
    }

    protected JieQi getNearJieQi(boolean forward, String[] conditions, boolean wholeDay) {
        String name = null;
        Solar near = null;
        HashSet filters = new HashSet();
        if (null != conditions) {
            Collections.addAll(filters, conditions);
        }
        boolean filter = !filters.isEmpty();
        String today = wholeDay ? this.solar.toYmd() : this.solar.toYmdHms();
        for (Map.Entry<String, Solar> entry : this.jieQi.entrySet()) {
            String nearDay;
            String day;
            String jq = this.convertJieQi(entry.getKey());
            if (filter && !filters.contains(jq)) continue;
            Solar solar = entry.getValue();
            String string = day = wholeDay ? solar.toYmd() : solar.toYmdHms();
            if (forward) {
                if (day.compareTo(today) <= 0) continue;
                if (null == near) {
                    name = jq;
                    near = solar;
                    continue;
                }
                nearDay = wholeDay ? near.toYmd() : near.toYmdHms();
                if (day.compareTo(nearDay) >= 0) continue;
                name = jq;
                near = solar;
                continue;
            }
            if (day.compareTo(today) > 0) continue;
            if (null == near) {
                name = jq;
                near = solar;
                continue;
            }
            nearDay = wholeDay ? near.toYmd() : near.toYmdHms();
            if (day.compareTo(nearDay) <= 0) continue;
            name = jq;
            near = solar;
        }
        if (null == near) {
            return null;
        }
        return new JieQi(name, near);
    }

    public String getJieQi() {
        for (Map.Entry<String, Solar> jq : this.jieQi.entrySet()) {
            Solar d = jq.getValue();
            if (d.getYear() != this.solar.getYear() || d.getMonth() != this.solar.getMonth() || d.getDay() != this.solar.getDay()) continue;
            return this.convertJieQi(jq.getKey());
        }
        return "";
    }

    public JieQi getCurrentJieQi() {
        for (Map.Entry<String, Solar> jq : this.jieQi.entrySet()) {
            Solar d = jq.getValue();
            if (d.getYear() != this.solar.getYear() || d.getMonth() != this.solar.getMonth() || d.getDay() != this.solar.getDay()) continue;
            return new JieQi(this.convertJieQi(jq.getKey()), d);
        }
        return null;
    }

    public JieQi getCurrentJie() {
        int j = JIE_QI_IN_USE.length;
        for (int i = 0; i < j; i += 2) {
            String key = JIE_QI_IN_USE[i];
            Solar d = this.jieQi.get(key);
            if (d.getYear() != this.solar.getYear() || d.getMonth() != this.solar.getMonth() || d.getDay() != this.solar.getDay()) continue;
            return new JieQi(this.convertJieQi(key), d);
        }
        return null;
    }

    public JieQi getCurrentQi() {
        int j = JIE_QI_IN_USE.length;
        for (int i = 1; i < j; i += 2) {
            String key = JIE_QI_IN_USE[i];
            Solar d = this.jieQi.get(key);
            if (d.getYear() != this.solar.getYear() || d.getMonth() != this.solar.getMonth() || d.getDay() != this.solar.getDay()) continue;
            return new JieQi(this.convertJieQi(key), d);
        }
        return null;
    }

    public String toFullString() {
        StringBuilder s = new StringBuilder();
        s.append(this);
        s.append(" ");
        s.append(this.getYearInGanZhi());
        s.append("(");
        s.append(this.getYearShengXiao());
        s.append(")\u5e74 ");
        s.append(this.getMonthInGanZhi());
        s.append("(");
        s.append(this.getMonthShengXiao());
        s.append(")\u6708 ");
        s.append(this.getDayInGanZhi());
        s.append("(");
        s.append(this.getDayShengXiao());
        s.append(")\u65e5 ");
        s.append(this.getTimeZhi());
        s.append("(");
        s.append(this.getTimeShengXiao());
        s.append(")\u65f6 \u7eb3\u97f3[");
        s.append(this.getYearNaYin());
        s.append(" ");
        s.append(this.getMonthNaYin());
        s.append(" ");
        s.append(this.getDayNaYin());
        s.append(" ");
        s.append(this.getTimeNaYin());
        s.append("] \u661f\u671f");
        s.append(this.getWeekInChinese());
        for (String f : this.getFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        for (String f : this.getOtherFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        String jq = this.getJieQi();
        if (jq.length() > 0) {
            s.append(" [");
            s.append(jq);
            s.append("]");
        }
        s.append(" ");
        s.append(this.getGong());
        s.append("\u65b9");
        s.append(this.getShou());
        s.append(" \u661f\u5bbf[");
        s.append(this.getXiu());
        s.append(this.getZheng());
        s.append(this.getAnimal());
        s.append("](");
        s.append(this.getXiuLuck());
        s.append(") \u5f6d\u7956\u767e\u5fcc[");
        s.append(this.getPengZuGan());
        s.append(" ");
        s.append(this.getPengZuZhi());
        s.append("] \u559c\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionXi());
        s.append("](");
        s.append(this.getDayPositionXiDesc());
        s.append(") \u9633\u8d35\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionYangGui());
        s.append("](");
        s.append(this.getDayPositionYangGuiDesc());
        s.append(") \u9634\u8d35\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionYinGui());
        s.append("](");
        s.append(this.getDayPositionYinGuiDesc());
        s.append(") \u798f\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionFu());
        s.append("](");
        s.append(this.getDayPositionFuDesc());
        s.append(") \u8d22\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionCai());
        s.append("](");
        s.append(this.getDayPositionCaiDesc());
        s.append(") \u51b2[");
        s.append(this.getDayChongDesc());
        s.append("] \u715e[");
        s.append(this.getDaySha());
        s.append("]");
        return s.toString();
    }

    public String toString() {
        return this.getYearInChinese() + "\u5e74" + this.getMonthInChinese() + "\u6708" + this.getDayInChinese();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getTimeGanIndex() {
        return this.timeGanIndex;
    }

    public int getTimeZhiIndex() {
        return this.timeZhiIndex;
    }

    public int getDayGanIndex() {
        return this.dayGanIndex;
    }

    public int getDayZhiIndex() {
        return this.dayZhiIndex;
    }

    public int getMonthGanIndex() {
        return this.monthGanIndex;
    }

    public int getMonthZhiIndex() {
        return this.monthZhiIndex;
    }

    public int getYearGanIndex() {
        return this.yearGanIndex;
    }

    public int getYearZhiIndex() {
        return this.yearZhiIndex;
    }

    public int getYearGanIndexByLiChun() {
        return this.yearGanIndexByLiChun;
    }

    public int getYearZhiIndexByLiChun() {
        return this.yearZhiIndexByLiChun;
    }

    public int getDayGanIndexExact() {
        return this.dayGanIndexExact;
    }

    public int getDayGanIndexExact2() {
        return this.dayGanIndexExact2;
    }

    public int getDayZhiIndexExact() {
        return this.dayZhiIndexExact;
    }

    public int getDayZhiIndexExact2() {
        return this.dayZhiIndexExact2;
    }

    public int getMonthGanIndexExact() {
        return this.monthGanIndexExact;
    }

    public int getMonthZhiIndexExact() {
        return this.monthZhiIndexExact;
    }

    public int getYearGanIndexExact() {
        return this.yearGanIndexExact;
    }

    public int getYearZhiIndexExact() {
        return this.yearZhiIndexExact;
    }

    public Solar getSolar() {
        return this.solar;
    }

    public EightChar getEightChar() {
        if (null == this.eightChar) {
            this.eightChar = new EightChar(this);
        }
        return this.eightChar;
    }

    public Lunar next(int days) {
        return this.solar.next(days).getLunar();
    }

    public String getYearXun() {
        return LunarUtil.getXun(this.getYearInGanZhi());
    }

    public String getYearXunByLiChun() {
        return LunarUtil.getXun(this.getYearInGanZhiByLiChun());
    }

    public String getYearXunExact() {
        return LunarUtil.getXun(this.getYearInGanZhiExact());
    }

    public String getYearXunKong() {
        return LunarUtil.getXunKong(this.getYearInGanZhi());
    }

    public String getYearXunKongByLiChun() {
        return LunarUtil.getXunKong(this.getYearInGanZhiByLiChun());
    }

    public String getYearXunKongExact() {
        return LunarUtil.getXunKong(this.getYearInGanZhiExact());
    }

    public String getMonthXun() {
        return LunarUtil.getXun(this.getMonthInGanZhi());
    }

    public String getMonthXunExact() {
        return LunarUtil.getXun(this.getMonthInGanZhiExact());
    }

    public String getMonthXunKong() {
        return LunarUtil.getXunKong(this.getMonthInGanZhi());
    }

    public String getMonthXunKongExact() {
        return LunarUtil.getXunKong(this.getMonthInGanZhiExact());
    }

    public String getDayXun() {
        return LunarUtil.getXun(this.getDayInGanZhi());
    }

    public String getDayXunExact() {
        return LunarUtil.getXun(this.getDayInGanZhiExact());
    }

    public String getDayXunExact2() {
        return LunarUtil.getXun(this.getDayInGanZhiExact2());
    }

    public String getDayXunKong() {
        return LunarUtil.getXunKong(this.getDayInGanZhi());
    }

    public String getDayXunKongExact() {
        return LunarUtil.getXunKong(this.getDayInGanZhiExact());
    }

    public String getDayXunKongExact2() {
        return LunarUtil.getXunKong(this.getDayInGanZhiExact2());
    }

    public String getTimeXun() {
        return LunarUtil.getXun(this.getTimeInGanZhi());
    }

    public String getTimeXunKong() {
        return LunarUtil.getXunKong(this.getTimeInGanZhi());
    }

    public ShuJiu getShuJiu() {
        Solar current = Solar.fromYmd(this.solar.getYear(), this.solar.getMonth(), this.solar.getDay());
        Solar start = this.jieQi.get("DONG_ZHI");
        if (current.isBefore(start = Solar.fromYmd(start.getYear(), start.getMonth(), start.getDay()))) {
            start = this.jieQi.get("\u51ac\u81f3");
            start = Solar.fromYmd(start.getYear(), start.getMonth(), start.getDay());
        }
        Solar end = Solar.fromYmd(start.getYear(), start.getMonth(), start.getDay()).next(81);
        if (current.isBefore(start) || !current.isBefore(end)) {
            return null;
        }
        int days = current.subtract(start);
        return new ShuJiu(LunarUtil.NUMBER[days / 9 + 1] + "\u4e5d", days % 9 + 1);
    }

    public Fu getFu() {
        Solar current = Solar.fromYmd(this.solar.getYear(), this.solar.getMonth(), this.solar.getDay());
        Solar xiaZhi = this.jieQi.get("\u590f\u81f3");
        Solar liQiu = this.jieQi.get("\u7acb\u79cb");
        Solar start = Solar.fromYmd(xiaZhi.getYear(), xiaZhi.getMonth(), xiaZhi.getDay());
        int add = 6 - xiaZhi.getLunar().getDayGanIndex();
        if (add < 0) {
            add += 10;
        }
        if (current.isBefore(start = start.next(add += 20))) {
            return null;
        }
        int days = current.subtract(start);
        if (days < 10) {
            return new Fu("\u521d\u4f0f", days + 1);
        }
        days = current.subtract(start = start.next(10));
        if (days < 10) {
            return new Fu("\u4e2d\u4f0f", days + 1);
        }
        start = start.next(10);
        days = current.subtract(start);
        Solar liQiuSolar = Solar.fromYmd(liQiu.getYear(), liQiu.getMonth(), liQiu.getDay());
        if (liQiuSolar.isAfter(start)) {
            if (days < 10) {
                return new Fu("\u4e2d\u4f0f", days + 11);
            }
            start = start.next(10);
            days = current.subtract(start);
        }
        if (days < 10) {
            return new Fu("\u672b\u4f0f", days + 1);
        }
        return null;
    }

    public String getLiuYao() {
        return LunarUtil.LIU_YAO[(Math.abs(this.month) - 1 + this.day - 1) % 6];
    }

    public String getWuHou() {
        int index;
        JieQi jieQi = this.getPrevJieQi(true);
        int offset = 0;
        int j = JIE_QI.length;
        for (int i = 0; i < j; ++i) {
            if (!jieQi.getName().equals(JIE_QI[i])) continue;
            offset = i;
            break;
        }
        if ((index = this.solar.subtract(jieQi.getSolar()) / 5) > 2) {
            index = 2;
        }
        return LunarUtil.WU_HOU[(offset * 3 + index) % LunarUtil.WU_HOU.length];
    }

    public String getHou() {
        JieQi jieQi = this.getPrevJieQi(true);
        int max = LunarUtil.HOU.length - 1;
        int offset = this.solar.subtract(jieQi.getSolar()) / 5;
        if (offset > max) {
            offset = max;
        }
        return String.format("%s %s", jieQi.getName(), LunarUtil.HOU[offset]);
    }

    public String getDayLu() {
        String gan = LunarUtil.LU.get(this.getDayGan());
        String zhi = LunarUtil.LU.get(this.getDayZhi());
        String lu = gan + "\u547d\u4e92\u7984";
        if (null != zhi) {
            lu = lu + " " + zhi + "\u547d\u8fdb\u7984";
        }
        return lu;
    }

    public LunarTime getTime() {
        return new LunarTime(this.year, this.month, this.day, this.hour, this.minute, this.second);
    }

    public List<LunarTime> getTimes() {
        ArrayList<LunarTime> l = new ArrayList<LunarTime>();
        l.add(new LunarTime(this.year, this.month, this.day, 0, 0, 0));
        for (int i = 0; i < 12; ++i) {
            l.add(new LunarTime(this.year, this.month, this.day, (i + 1) * 2 - 1, 0, 0));
        }
        return l;
    }

    public Foto getFoto() {
        return Foto.fromLunar(this);
    }

    public Tao getTao() {
        return Tao.fromLunar(this);
    }
}

